/*
============================================================================
 Name        : $(viewname)Container.cpp
 Author      : $(author)
 Version     :
 Copyright   : $(copyright)
 Description : C$(viewname)Container implementation
============================================================================
*/

#include "$(viewname)Container.h"
#include <$(basename).rsg>		// for R_SETTING_ITEM_LIST
#include "$(viewname)SettingItemList.h"

void C$(viewname)Container::ConstructL(const TRect& aRect)
{
	CreateWindowL();
	iSettings.RestoreL();
	iSettingItemList = new C$(viewname)SettingItemList (iSettings);
	iSettingItemList->SetMopParent(this);
	iSettingItemList->ConstructFromResourceL(R_SETTING_ITEM_LIST);
	SetRect(aRect);
	//SetComponentsToInheritVisibility();
	ActivateL();
}

C$(viewname)Container* C$(viewname)Container::NewL(const TRect& aRect)
{
	C$(viewname)Container* self = C$(viewname)Container::NewLC(aRect);
	CleanupStack::Pop(self);
	return self;
}

C$(viewname)Container* C$(viewname)Container::NewLC(const TRect& aRect)
{
	C$(viewname)Container* self = new (ELeave) C$(viewname)Container;
	CleanupStack::PushL(self);
	self->ConstructL(aRect);
	return self;
}

C$(viewname)Container::~C$(viewname)Container()
{
	delete iSettingItemList;
}

TInt C$(viewname)Container::CountComponentControls() const
{
	return 1; // number of controls inside this container
}

CCoeControl* C$(viewname)Container::ComponentControl(TInt aIndex) const
{
	switch (aIndex) {
	case 0:
		return iSettingItemList;
	default:
		return NULL;
	}
}

TKeyResponse C$(viewname)Container::OfferKeyEventL(const TKeyEvent& aKeyEvent,TEventCode aType)
{
	if (iSettingItemList)
		return iSettingItemList->OfferKeyEventL (aKeyEvent, aType);
	else
		return EKeyWasNotConsumed;
}

void C$(viewname)Container::ChangeSelectedItemL()
{
	if (iSettingItemList)
		iSettingItemList->ChangeSelectedItemL();
}

