/*
============================================================================
 Name        : $(viewname)SettingItemList.cpp
 Author      : $(author)
 Version     :
 Copyright   : $(copyright)
 Description : C$(viewname)SettingItemList implementation
============================================================================
*/

#include "$(viewname)SettingItemList.h"
#include "$(viewname)Settings.h"

C$(viewname)SettingItemList::C$(viewname)SettingItemList(T$(viewname)Settings& aSettings)
		: iSettings (aSettings)
{}

void C$(viewname)SettingItemList::SizeChanged()
{
	if (ListBox()) {
		ListBox()->SetRect(Rect());
	}
}

/**
* Creates the actual setting items for the list, passing ownership of them
* to the calling class. Each setting item holds a reference to the variable
* it sets values in.
*/
CAknSettingItem* C$(viewname)SettingItemList::CreateSettingItemL(TInt aIdentifier)
{
	CAknSettingItem* item = NULL;
	switch (aIdentifier) {
	case ESettingItemMyString:
		item = new (ELeave) CAknTextSettingItem(aIdentifier, iSettings.iMyString);
		break;
	case ESettingItemMyInt:
		item = new (ELeave) CAknSliderSettingItem(aIdentifier, iSettings.iMyInt);
		break;
	}
	return item; // passing ownership
}

void C$(viewname)SettingItemList::ChangeSelectedItemL()
{
	EditItemL(ListBox()->CurrentItemIndex(), ETrue);
}

void C$(viewname)SettingItemList::EditItemL(TInt aIndex, TBool aCalledFromMenu)
{
	CAknSettingItemList::EditItemL(aIndex, aCalledFromMenu);
	(*SettingItemArray())[aIndex]->StoreL();
}
