/*
============================================================================
 Name        : $(viewname)Settings.cpp
 Author      : $(author)
 Version     :
 Copyright   : $(copyright)
 Description : C$(viewname)Settings implementation
============================================================================
*/

#include "$(viewname)Settings.h"
#include <eikappui.h>
#include <eikenv.h>
#include <eikapp.h>
#include <s32file.h>	// Link against efsrv.lib

_LIT(KSettingsStore, "settings.dat");

TFileName T$(viewname)Settings::AddPath(const TDesC& aFileName) const
{
	TFileName appFullName = CEikonEnv::Static()->EikAppUi()->Application()->AppFullName();
	TParse parse;
#ifdef __WINS__
	// On WINS the application is on the z drive
	parse.Set(_L("c:"), &appFullName, NULL);
#else
	parse.Set(appFullName, NULL, NULL);
#endif
	TFileName driveAndPath = parse.DriveAndPath();
	TParse thePath;
	thePath.Set(driveAndPath,  &aFileName,  NULL);
	return thePath.FullName();
}

void T$(viewname)Settings::StoreL() const
{
	//CCoeEnv::Static()->FsSession();
	RFs fs;
	User::LeaveIfError(fs.Connect());
	RFileWriteStream out;
	out.PushL();	// out on cleanup stack
	User::LeaveIfError(out.Replace(fs, AddPath(KSettingsStore), EFileWrite));

	ExternalizeL(out);

	out.Close();
	CleanupStack::PopAndDestroy(); // out
	fs.Close();
}

void T$(viewname)Settings::RestoreL()
{
	RFs fs;
	User::LeaveIfError(fs.Connect());
	RFileReadStream in;
	in.PushL();		// in on cleanup stack
	//User::LeaveIfError(in.Open(fs, AddPath(KSettingsStore), EFileRead));
	if (in.Open(fs, AddPath(KSettingsStore), EFileRead) == KErrNone) {
		InternalizeL(in);
	} else {
		// Set default values
		iMyInt = 3;
	}

	CleanupStack::PopAndDestroy(); // in
	fs.Close();
}

void T$(viewname)Settings::ExternalizeL(RWriteStream& aStream) const
{
	TBuf8<256> str;
	str.Copy(iMyString);
	str.Append(_L("\n"));
	aStream.WriteL(str);

	TBuf8<256> str2;
	str2.Format(_L8("%d"), iMyInt);
	str2.Append(_L("\n"));
	aStream.WriteL(str2);
}

void T$(viewname)Settings::InternalizeL(RReadStream& aStream)
{
	TBuf8<256> str;
	TLex8 lex;

	aStream.ReadL(str, TChar('\n'));
	str.Trim();
	iMyString.Copy(str);

	aStream.ReadL(str, TChar('\n'));
	lex.Assign(str); lex.Val(iMyInt);
}

