/*
============================================================================
 Name        : C$(viewname)View from $(viewname)View.h
 Author      : $(author)
 Version     :
 Copyright   : $(copyright)
 Description : C$(viewname)View declaration
============================================================================
*/

#ifndef $(viewname)VIEW_H
#define $(viewname)VIEW_H

// INCLUDES
#include <aknview.h>


// CONSTANTS
// UID of view
const TUid KViewId = {$(viewid)};

// FORWARD DECLARATIONS
class C$(viewname)Container;

// CLASS DECLARATION

/**
*  C$(viewname)View view class.
* 
*/
class C$(viewname)View : public CAknView
    {
    public: // Constructors and destructor

        /**
        * EPOC default constructor.
        */
        void ConstructL();

        /**
        * Destructor.
        */
        ~C$(viewname)View();

    public: // Functions from base classes
        
        /**
        * From CAknView returns Uid of View
        * @return TUid uid of the view
        */
        TUid Id() const;

        /**
        * From MEikMenuObserver delegate commands from the menu
        * @param aCommand a command emitted by the menu 
        * @return void
        */
        void HandleCommandL(TInt aCommand);

        /**
        * From CAknView reaction if size change
        * @return void
        */
        void HandleClientRectChange();

    private:

        /**
        * From CAknView activate the view
        * @param aPrevViewId 
        * @param aCustomMessageId 
        * @param aCustomMessage 
        * @return void
        */
        void DoActivateL(const TVwsViewId& aPrevViewId,TUid aCustomMessageId,
            const TDesC8& aCustomMessage);

        /**
        * From CAknView deactivate the view (free resources)
        * @return void
        */
        void DoDeactivate();

    private: // Data
        C$(viewname)Container* iContainer;
    };

#endif

// End of File
