/*
============================================================================
 Name        : C$(viewname)Container from $(viewname)Container.h
 Author      : $(author)
 Version     :
 Copyright   : $(copyright)
 Description : C$(viewname)Container implementation
============================================================================
*/

// INCLUDE FILES
#include "$(viewname)Container.h"

#include <eiklabel.h>  // for example label control


// ================= MEMBER FUNCTIONS =======================

// ---------------------------------------------------------
// C$(viewname)Container::ConstructL(const TRect& aRect)
// EPOC two phased constructor
// ---------------------------------------------------------
//
void C$(viewname)Container::ConstructL(const TRect& aRect)
    {
    CreateWindowL();

    iLabel = new (ELeave) CEikLabel;
    iLabel->SetContainerWindowL( *this );
    iLabel->SetTextL( _L("Example View") );

    iToDoLabel = new (ELeave) CEikLabel;
    iToDoLabel->SetContainerWindowL( *this );
    iToDoLabel->SetTextL( _L("Add Your controls\n here") );

    SetRect(aRect);
    ActivateL();
    }

// Destructor
C$(viewname)Container::~C$(viewname)Container()
    {
    delete iLabel;
    delete iToDoLabel;
    }

// ---------------------------------------------------------
// C$(viewname)Container::SizeChanged()
// Called by framework when the view size is changed
// ---------------------------------------------------------
//
void C$(viewname)Container::SizeChanged()
    {
    // TODO: Add here control resize code etc.
    iLabel->SetExtent( TPoint(10,10), iLabel->MinimumSize() );
    iToDoLabel->SetExtent( TPoint(10,100), iToDoLabel->MinimumSize() );
    }

// ---------------------------------------------------------
// C$(viewname)Container::CountComponentControls() const
// ---------------------------------------------------------
//
TInt C$(viewname)Container::CountComponentControls() const
    {
    return 2; // return nbr of controls inside this container
    }

// ---------------------------------------------------------
// C$(viewname)Container::ComponentControl(TInt aIndex) const
// ---------------------------------------------------------
//
CCoeControl* C$(viewname)Container::ComponentControl(TInt aIndex) const
    {
    switch ( aIndex )
        {
        case 0:
            return iLabel;
        case 1:
            return iToDoLabel;
        default:
            return NULL;
        }
    }

// ---------------------------------------------------------
// C$(viewname)Container::Draw(const TRect& aRect) const
// ---------------------------------------------------------
//
void C$(viewname)Container::Draw(const TRect& aRect) const
    {
    CWindowGc& gc = SystemGc();
    // TODO: Add your drawing code here
    // example code...
    gc.SetPenStyle( CGraphicsContext::ENullPen );
    gc.SetBrushColor( KRgbGray );
    gc.SetBrushStyle( CGraphicsContext::ESolidBrush );
    gc.DrawRect( aRect );
    }

// ---------------------------------------------------------
// C$(viewname)Container::HandleControlEventL(
//     CCoeControl* aControl,TCoeEvent aEventType)
// ---------------------------------------------------------
//
void C$(viewname)Container::HandleControlEventL(
    CCoeControl* /*aControl*/,TCoeEvent /*aEventType*/)
    {
    // TODO: Add your control event handler code here
    }


// End of File  
