/*
============================================================================
 Name        : C$(viewname)View from $(viewname)View.h
 Author      : $(author)
 Version     :
 Copyright   : $(copyright)
 Description : C$(viewname)View implementation
============================================================================
*/

// INCLUDE FILES
#include  <aknviewappui.h>
#include  <avkon.hrh>
#include  <$(basename).rsg>
#include  "$(viewname)View.h"
#include  "$(viewname)Container.h" 

// ================= MEMBER FUNCTIONS =======================

// ---------------------------------------------------------
// C$(viewname)View::ConstructL(const TRect& aRect)
// EPOC two-phased constructor
// ---------------------------------------------------------
//
void C$(viewname)View::ConstructL()
    {
    BaseConstructL( R_$(basename)_$(viewname)_VIEW );
    }

// ---------------------------------------------------------
// C$(viewname)View::~C$(viewname)View()
// destructor
// ---------------------------------------------------------
//
C$(viewname)View::~C$(viewname)View()
    {
    if ( iContainer )
        {
        AppUi()->RemoveFromViewStack( *this, iContainer );
        }

    delete iContainer;
    }

// ---------------------------------------------------------
// TUid C$(viewname)View::Id()
//
// ---------------------------------------------------------
//
TUid C$(viewname)View::Id() const
    {
    return KViewId;
    }

// ---------------------------------------------------------
// C$(viewname)View::HandleCommandL(TInt aCommand)
// takes care of view command handling
// ---------------------------------------------------------
//
void C$(viewname)View::HandleCommandL(TInt aCommand)
    {   
    switch ( aCommand )
        {
        case EAknSoftkeyOk:
            {
            iEikonEnv->InfoMsg( _L("view1 ok") );
            break;
            }
        case EAknSoftkeyBack:
            {
            AppUi()->HandleCommandL(EEikCmdExit);
            break;
            }
        default:
            {
            AppUi()->HandleCommandL( aCommand );
            break;
            }
        }
    }

// ---------------------------------------------------------
// C$(viewname)View::HandleClientRectChange()
// ---------------------------------------------------------
//
void C$(viewname)View::HandleClientRectChange()
    {
    if ( iContainer )
        {
        iContainer->SetRect( ClientRect() );
        }
    }

// ---------------------------------------------------------
// C$(viewname)View::DoActivateL(...)
// 
// ---------------------------------------------------------
//
void C$(viewname)View::DoActivateL(
   const TVwsViewId& /*aPrevViewId*/,TUid /*aCustomMessageId*/,
   const TDesC8& /*aCustomMessage*/)
    {
    if (!iContainer)
        {
        iContainer = new (ELeave) C$(viewname)Container;
        iContainer->SetMopParent(this);
        iContainer->ConstructL( ClientRect() );
        AppUi()->AddToStackL( *this, iContainer );
        } 
   }

// ---------------------------------------------------------
// C$(viewname)View::DoDeactivate()
// 
// ---------------------------------------------------------
//
void C$(viewname)View::DoDeactivate()
    {
    if ( iContainer )
        {
        AppUi()->RemoveFromViewStack( *this, iContainer );
        }
    
    delete iContainer;
    iContainer = NULL;
    }

// End of File

