/*
============================================================================
 Name        : C$(baseName)Container from $(baseName)Container.h
 Author      : $(author)
 Version     :
 Copyright   : $(copyright)
 Description : Container control implementation
============================================================================
*/

// INCLUDE FILES
#include "$(baseName)Container.h"

#include <eiklabel.h>  // for example label control


// ================= MEMBER FUNCTIONS =======================

// ---------------------------------------------------------
// C$(baseName)Container::ConstructL(const TRect& aRect)
// EPOC two phased constructor
// ---------------------------------------------------------
//
void C$(baseName)Container::ConstructL(const TRect& aRect)
    {
    CreateWindowL();

    iLabel = new (ELeave) CEikLabel;
    iLabel->SetContainerWindowL( *this );
    iLabel->SetTextL( _L("Example View") );

    iToDoLabel = new (ELeave) CEikLabel;
    iToDoLabel->SetContainerWindowL( *this );
    iToDoLabel->SetTextL( _L("Add Your controls\n here") );

    SetRect(aRect);
    ActivateL();
    }

// Destructor
C$(baseName)Container::~C$(baseName)Container()
    {
    delete iLabel;
    delete iToDoLabel;
    }

// ---------------------------------------------------------
// C$(baseName)Container::SizeChanged()
// Called by framework when the view size is changed
// ---------------------------------------------------------
//
void C$(baseName)Container::SizeChanged()
    {
    // TODO: Add here control resize code etc.
    iLabel->SetExtent( TPoint(10,10), iLabel->MinimumSize() );
    iToDoLabel->SetExtent( TPoint(10,100), iToDoLabel->MinimumSize() );
    }

// ---------------------------------------------------------
// C$(baseName)Container::CountComponentControls() const
// ---------------------------------------------------------
//
TInt C$(baseName)Container::CountComponentControls() const
    {
    return 2; // return nbr of controls inside this container
    }

// ---------------------------------------------------------
// C$(baseName)Container::ComponentControl(TInt aIndex) const
// ---------------------------------------------------------
//
CCoeControl* C$(baseName)Container::ComponentControl(TInt aIndex) const
    {
    switch ( aIndex )
        {
        case 0:
            return iLabel;
        case 1:
            return iToDoLabel;
        default:
            return NULL;
        }
    }

// ---------------------------------------------------------
// C$(baseName)Container::Draw(const TRect& aRect) const
// ---------------------------------------------------------
//
void C$(baseName)Container::Draw(const TRect& aRect) const
    {
    CWindowGc& gc = SystemGc();
    // TODO: Add your drawing code here
    // example code...
    gc.SetPenStyle( CGraphicsContext::ENullPen );
    gc.SetBrushColor( KRgbGray );
    gc.SetBrushStyle( CGraphicsContext::ESolidBrush );
    gc.DrawRect( aRect );
    }

// ---------------------------------------------------------
// C$(baseName)Container::HandleControlEventL(
//     CCoeControl* aControl,TCoeEvent aEventType)
// ---------------------------------------------------------
//
void C$(baseName)Container::HandleControlEventL(
    CCoeControl* /*aControl*/,TCoeEvent /*aEventType*/)
    {
    // TODO: Add your control event handler code here
    }



