/*
============================================================================
 Name        : C$(basename)AppUi from $(basename)Appui.cpp
 Author      : $(author)
 Version     :
 Copyright   : $(copyright)
 Description : C$(basename)AppUi implementation
============================================================================
*/

// INCLUDE FILES
#include "$(basename)Appui.h"
#include "$(basename)View.h"
#include "$(basename)View2.h"
#include <$(basename).rsg>
#include "$(basename).hrh"

#include <avkon.hrh>

// ================= MEMBER FUNCTIONS =======================
//
// ----------------------------------------------------------
// C$(basename)AppUi::ConstructL()
// 
// ----------------------------------------------------------
//
void C$(basename)AppUi::ConstructL()
    {
    BaseConstructL();


    // Show tabs for main views from resources
    CEikStatusPane* sp = StatusPane();

    // Fetch pointer to the default navi pane control
    iNaviPane = (CAknNavigationControlContainer*)sp->ControlL( 
        TUid::Uid(EEikStatusPaneUidNavi));

    // Tabgroup has been read from resource and it were pushed to the navi pane. 
    // Get pointer to the navigation decorator with the ResourceDecorator() function. 
    // Application owns the decorator and it has responsibility to delete the object.
    iDecoratedTabGroup = iNaviPane->ResourceDecorator();
    if (iDecoratedTabGroup)
        {
        iTabGroup = (CAknTabGroup*) iDecoratedTabGroup->DecoratedControl();
		iTabGroup->SetObserver( this );
}

    C$(basename)View* view1 = new (ELeave) C$(basename)View;

    CleanupStack::PushL( view1 );
    view1->ConstructL();
    AddViewL( view1 );      // transfer ownership to CAknViewAppUi
    CleanupStack::Pop();    // view1

    C$(basename)View2* view2 = new (ELeave) C$(basename)View2;

    CleanupStack::PushL( view2 );
    view2->ConstructL();
    AddViewL( view2 );      // transfer ownership to CAknViewAppUi
    CleanupStack::Pop();    // view2

    SetDefaultViewL(*view1);

    }

// ----------------------------------------------------
// C$(basename)AppUi::~C$(basename)AppUi()
// Destructor
// Frees reserved resources
// ----------------------------------------------------
//
C$(basename)AppUi::~C$(basename)AppUi()
    {
    delete iDecoratedTabGroup;
   }

// ------------------------------------------------------------------------------
// C$(basename)AppUi::DynInitMenuPaneL(TInt aResourceId,CEikMenuPane* aMenuPane)
//  This function is called by the EIKON framework just before it displays
//  a menu pane. Its default implementation is empty, and by overriding it,
//  the application can set the state of menu items dynamically according
//  to the state of application data.
// ------------------------------------------------------------------------------
//
void C$(basename)AppUi::DynInitMenuPaneL(
    TInt /*aResourceId*/,CEikMenuPane* /*aMenuPane*/)
    {
    }

// ----------------------------------------------------
// C$(basename)AppUi::HandleKeyEventL(
//     const TKeyEvent& aKeyEvent,TEventCode /*aType*/)
// takes care of key event handling
// ----------------------------------------------------
//
TKeyResponse C$(basename)AppUi::HandleKeyEventL(
    const TKeyEvent& aKeyEvent,TEventCode aType)
    {
	if ( iTabGroup == NULL )
        {
        return EKeyWasNotConsumed;
        }

    if ( aKeyEvent.iCode == EKeyLeftArrow || aKeyEvent.iCode == EKeyRightArrow )
        {
        return iTabGroup->OfferKeyEventL( aKeyEvent, aType );
        }
    else
        {
        return EKeyWasNotConsumed;
        }
    }

// ----------------------------------------------------
// C$(basename)AppUi::HandleCommandL(TInt aCommand)
// takes care of command handling
// ----------------------------------------------------
//
void C$(basename)AppUi::HandleCommandL(TInt aCommand)
    {
    switch ( aCommand )
        {
        case EEikCmdExit:
            {
            Exit();
            break;
            }
        case E$(basename)CmdAppTest:
            {
            iEikonEnv->InfoMsg(_L("test"));
            break;
            }
        // TODO: Add Your command handling code here

        default:
            break;      
        }
    }


 // ----------------------------------------------------
 // C$(basename)AppUi::TabChangedL(TInt aIndex)
 // This method gets called when CAknTabGroup active 
 // tab has changed.
 // ----------------------------------------------------
 //
 void C$(basename)AppUi::TabChangedL(TInt aIndex)
     {
     ActivateLocalViewL(TUid::Uid(iTabGroup->TabIdFromIndex(aIndex)));
     }

  
