/*
============================================================================
 Name        : C$(basename)Container2 from $(basename)Container2.cpp
 Author      : $(author)
 Version     :
 Copyright   : $(copyright)
 Description : Container control implementation
============================================================================
*/

// INCLUDE FILES
#include "$(basename)Container2.h"

#include <eiklabel.h>  // for example label control


// ================= MEMBER FUNCTIONS =======================

// ---------------------------------------------------------
// C$(basename)Container2::ConstructL(const TRect& aRect)
// EPOC two phased constructor
// ---------------------------------------------------------
//
void C$(basename)Container2::ConstructL(const TRect& aRect)
    {
    CreateWindowL();

    iLabel = new (ELeave) CEikLabel;
    iLabel->SetContainerWindowL( *this );
    iLabel->SetTextL( _L("Example View 2") );

    iToDoLabel = new (ELeave) CEikLabel;
    iToDoLabel->SetContainerWindowL( *this );
    iToDoLabel->SetTextL( _L("Add Your controls\n here") );

    SetRect(aRect);
    ActivateL();
    }

// Destructor
C$(basename)Container2::~C$(basename)Container2()
    {
    delete iLabel;
    delete iToDoLabel;
    }

// ---------------------------------------------------------
// C$(basename)Container2::SizeChanged()
// Called by framework when the view size is changed
// ---------------------------------------------------------
//
void C$(basename)Container2::SizeChanged()
    {
    // TODO: Add here control resize code etc.
    iLabel->SetExtent( TPoint(10,10), iLabel->MinimumSize() );
    iToDoLabel->SetExtent( TPoint(10,100), iToDoLabel->MinimumSize() );
    }

// ---------------------------------------------------------
// C$(basename)Container2::CountComponentControls() const
// ---------------------------------------------------------
//
TInt C$(basename)Container2::CountComponentControls() const
    {
    return 2; // return nbr of controls inside this container
    }

// ---------------------------------------------------------
// C$(basename)Container2::ComponentControl(TInt aIndex) const
// ---------------------------------------------------------
//
CCoeControl* C$(basename)Container2::ComponentControl(TInt aIndex) const
    {
    switch ( aIndex )
        {
        case 0:
            return iLabel;
        case 1:
            return iToDoLabel;
        default:
            return NULL;
        }
    }

// ---------------------------------------------------------
// C$(basename)Container2::Draw(const TRect& aRect) const
// ---------------------------------------------------------
//
void C$(basename)Container2::Draw(const TRect& aRect) const
    {
    CWindowGc& gc = SystemGc();
    // TODO: Add your drawing code here
    // example code...
    gc.SetPenStyle( CGraphicsContext::ENullPen );
    gc.SetBrushColor( KRgbGray );
    gc.SetBrushStyle( CGraphicsContext::ESolidBrush );
    gc.DrawRect( aRect );
    }

// ---------------------------------------------------------
// C$(basename)Container2::HandleControlEventL(
//     CCoeControl* aControl,TCoeEvent aEventType)
// ---------------------------------------------------------
//
void C$(basename)Container2::HandleControlEventL(
    CCoeControl* /*aControl*/,TCoeEvent /*aEventType*/)
    {
    // TODO: Add your control event handler code here
    }


  
