/*
============================================================================
 Name        : C$(basename)View from $(basename)View.h
 Author      : $(author)
 Version     :
 Copyright   : $(copyright)
 Description : C$(basename)View implementation
============================================================================
*/

// INCLUDE FILES
#include  <aknviewappui.h>
#include  <avkon.hrh>
#include  <$(basename).rsg>
#include  "$(basename)View.h"
#include  "$(basename)Container.h" 

// ================= MEMBER FUNCTIONS =======================

// ---------------------------------------------------------
// C$(basename)View::ConstructL(const TRect& aRect)
// EPOC two-phased constructor
// ---------------------------------------------------------
//
void C$(basename)View::ConstructL()
    {
    BaseConstructL( R_$(basename)_VIEW1 );
    }

// ---------------------------------------------------------
// C$(basename)View::~C$(basename)View()
// destructor
// ---------------------------------------------------------
//
C$(basename)View::~C$(basename)View()
    {
    if ( iContainer )
        {
        AppUi()->RemoveFromViewStack( *this, iContainer );
        }

    delete iContainer;
    }

// ---------------------------------------------------------
// TUid C$(basename)View::Id()
//
// ---------------------------------------------------------
//
TUid C$(basename)View::Id() const
    {
    return KViewId;
    }

// ---------------------------------------------------------
// C$(basename)View::HandleCommandL(TInt aCommand)
// takes care of view command handling
// ---------------------------------------------------------
//
void C$(basename)View::HandleCommandL(TInt aCommand)
    {   
    switch ( aCommand )
        {
        case EAknSoftkeyOk:
            {
            iEikonEnv->InfoMsg( _L("view1 ok") );
            break;
            }
        case EAknSoftkeyBack:
            {
            AppUi()->HandleCommandL(EEikCmdExit);
            break;
            }
        default:
            {
            AppUi()->HandleCommandL( aCommand );
            break;
            }
        }
    }

// ---------------------------------------------------------
// C$(basename)View::HandleClientRectChange()
// ---------------------------------------------------------
//
void C$(basename)View::HandleClientRectChange()
    {
    if ( iContainer )
        {
        iContainer->SetRect( ClientRect() );
        }
    }

// ---------------------------------------------------------
// C$(basename)View::DoActivateL(...)
// 
// ---------------------------------------------------------
//
void C$(basename)View::DoActivateL(
   const TVwsViewId& /*aPrevViewId*/,TUid /*aCustomMessageId*/,
   const TDesC8& /*aCustomMessage*/)
    {
    if (!iContainer)
        {
        iContainer = new (ELeave) C$(basename)Container;
        iContainer->SetMopParent(this);
        iContainer->ConstructL( ClientRect() );
        AppUi()->AddToStackL( *this, iContainer );
        } 
   }

// ---------------------------------------------------------
// C$(basename)View::DoDeactivate()
// 
// ---------------------------------------------------------
//
void C$(basename)View::DoDeactivate()
    {
    if ( iContainer )
        {
        AppUi()->RemoveFromViewStack( *this, iContainer );
        }
    
    delete iContainer;
    iContainer = NULL;
    }



