/*
============================================================================
 Name        : C$(basename)View2 from $(basename)View2.h
 Author      : $(author)
 Version     :
 Copyright   : $(copyright)
 Description : C$(basename)View2 implementation
============================================================================
*/

// INCLUDE FILES
#include  <aknviewappui.h>
#include  <avkon.hrh>
#include  <$(basename).rsg>
#include  "$(basename)View2.h"
#include  "$(basename)Container2.h" 

// ================= MEMBER FUNCTIONS =======================

// ---------------------------------------------------------
// C$(basename)View2::ConstructL(const TRect& aRect)
// EPOC two-phased constructor
// ---------------------------------------------------------
//
void C$(basename)View2::ConstructL()
    {
    BaseConstructL( R_$(basename)_VIEW2 );
    }

// ---------------------------------------------------------
// C$(basename)View2::~C$(basename)View2()
// destructor
// ---------------------------------------------------------
//
C$(basename)View2::~C$(basename)View2()
    {
    if ( iContainer )
        {
        AppUi()->RemoveFromViewStack( *this, iContainer );
        }

    delete iContainer;
    }

// ---------------------------------------------------------
// TUid C$(basename)View2::Id()
// 
// ---------------------------------------------------------
//
TUid C$(basename)View2::Id() const
    {
    return KView2Id;
    }

// ---------------------------------------------------------
// C$(basename)View2::HandleCommandL(TInt aCommand)
// takes care of view command handling
// ---------------------------------------------------------
//
void C$(basename)View2::HandleCommandL(TInt aCommand)
    {   
    switch ( aCommand )
        {
        case EAknSoftkeyOk:
            {
            iEikonEnv->InfoMsg( _L("view2 ok") );
            break;
            }
        case EAknSoftkeyBack:
            {
            AppUi()->HandleCommandL(EEikCmdExit);
            break;
            }
        default:
            {
            AppUi()->HandleCommandL( aCommand );
            break;
            }
        }
    }

// ---------------------------------------------------------
// C$(basename)View2::HandleClientRectChange()
// ---------------------------------------------------------
//
void C$(basename)View2::HandleClientRectChange()
    {
    if ( iContainer )
        {
        iContainer->SetRect( ClientRect() );
        }
    }

// ---------------------------------------------------------
// C$(basename)View2::DoActivateL(...)
// 
// ---------------------------------------------------------
//
void C$(basename)View2::DoActivateL(
   const TVwsViewId& /*aPrevViewId*/,TUid /*aCustomMessageId*/,
   const TDesC8& /*aCustomMessage*/)
    {
    if (!iContainer)
        {
        iContainer = new (ELeave) C$(basename)Container2;
        iContainer->SetMopParent(this);
        iContainer->ConstructL( ClientRect() );
        AppUi()->AddToStackL( *this, iContainer );
        }
   }

// ---------------------------------------------------------
// C$(basename)View2::DoDeactivate()
// 
// ---------------------------------------------------------
//
void C$(basename)View2::DoDeactivate()
    {
    if ( iContainer )
        {
        AppUi()->RemoveFromViewStack( *this, iContainer );
        }
    
    delete iContainer;
    iContainer = NULL;
    }



