/*
============================================================================
 Name        : C$(basename)AppUi from $(basename)Appui.cpp
 Author      : $(author)
 Version     :
 Copyright   : $(copyright)
 Description : C$(basename)AppUi implementation
============================================================================
*/

#include <eikenv.h>
#include <ckninfo.h>
#include <eikrted.h>
#include <txtrich.h>
#include <ckntitle.h>
#include <eiktbar.h>
#include <eikaufty.h>
#include <eikspane.h>
#include <eikdoc.h>


#include "$(basename).pan"
#include "$(basename)AppUi.h"
#include "$(basename)Document.h"
#include "$(basename).hrh"

const TInt KDefaultTextGranularity=256;

// ConstructL is called by the application framework
void C$(basename)AppUi::ConstructL()
    {
    BaseConstructL();

    iEditor = new (ELeave) CEikRichTextEditor();

	iRichText = CRichText::NewL( CEikonEnv::Static()->SystemParaFormatLayerL(), CEikonEnv::Static()->SystemCharFormatLayerL(),
							CEditableText::ESegmentedStorage, KDefaultTextGranularity);


    const TInt flags=EEikEdwinOwnsWindow|EEikEdwinKeepDocument|EEikEdwinInclusiveSizeFixed|EEikEdwinUserSuppliedText|
						EEikEdwinNoAutoSelection|EEikEdwinAlwaysShowSelection;

	iEditor->ConstructL(NULL,0,0, flags);
	iEditor->CreateScrollBarFrameL();
	iEditor->ScrollBarFrame()->SetScrollBarVisibilityL(CEikScrollBarFrame::EOff, CEikScrollBarFrame::EAuto);
	iEditor->SetAdjacent(EGulAdjLeft | EGulAdjRight | EGulAdjTop | EGulAdjBottom);

	TRect clientRect=ClientRect();	
    
	iEditor->SetDocumentContentL( *iRichText, CEikEdwin::EUseText );

	iEditor->SetRect(clientRect);
	iEditor->ActivateL();
	iEditor->SetFocus(ETrue);
	iEditor->SetAllowBorders(ETrue);
    }

C$(basename)AppUi::C$(basename)AppUi()                              
    {
    // no implementation required
    }

C$(basename)AppUi::~C$(basename)AppUi()
    {
    delete iEditor;
    iEditor = NULL;
    delete iRichText;
    iRichText = NULL;
    }

// Changes normal view to full screen or vice versa. 
void C$(basename)AppUi::ChangeFullScreenL()
	{
	MEikAppUiFactory* factory = iEikonEnv->AppUiFactory(); 
	CEikButtonGroupContainer* bar = factory->ToolBar();			// CBA
	CEikToolBar* band = factory->ToolBand();					// Title
	CEikToolBar* titleband = factory->TitleBand();				// This is not used
	CEikStatusPane* pane = factory->StatusPane();				// left hand status pane
	CCknAppTitle* title	= static_cast<CCknAppTitle*>( band->ControlById(E$(basename)AppTitle) ); // title control

	TInt titleBarAdjacent	= EGulAdjNone;

	if ( titleband )
		{
		titleband->MakeVisible(EFalse);
		}

	bar->SetComponentsToInheritVisibility(ETrue);
	bar->MakeVisible(!bar->IsVisible());
	band->SetComponentsToInheritVisibility(ETrue);


	if ( pane )
		{
		pane->MakeVisible(!pane->IsVisible());
		}

	band->MakeVisible(!band->IsVisible());

	TRect clientRect = ClientRect();

	TRect bandRect	= band->Rect();
	bandRect.iTl.iX	= clientRect.iTl.iX;
	bandRect.iBr.iX	= clientRect.iBr.iX;
	bandRect.iBr.iY	= bandRect.iTl.iY + title->MinimumSize().iHeight;
	band->SetRect(bandRect);
	title->SetRect(band->Rect());

	band->SetAdjacent(titleBarAdjacent);
	band->DrawDeferred();
	bar->DrawDeferred();
	title->DrawDeferred();
	iEditor->SetRect(clientRect);
	iEditor->ForceScrollBarUpdateL();
	iEditor->DrawDeferred();
	}	


TKeyResponse C$(basename)AppUi::HandleKeyEventL(const TKeyEvent& aKeyEvent, TEventCode aType)
	{
	return iEditor->OfferKeyEventL(aKeyEvent, aType);
	}


// handle any menu commands
void C$(basename)AppUi::HandleCommandL(TInt aCommand)
	{
    switch(aCommand)
		{
		case EEikCmdExit:
			{
			CBaActiveScheduler::Exit();
			}
			break;

		case E$(basename)Copy:
			{
			iEditor->ClipboardL(CEikEdwin::ECopy);
			}
			break;
		case E$(basename)Cut:
			{
			iEditor->ClipboardL( CEikEdwin::ECut );
			}
			break;
		case E$(basename)Paste:
			{
			iEditor->ClipboardL( CEikEdwin::EPaste );
            }
            break;
		case E$(basename)FullScreen:
			{
			ChangeFullScreenL();
			}
			break;
		case E$(basename)SelectAll:
			{
			iEditor->SelectAllL();
			}
			break;
		case E$(basename)Open:
			{
			// TODO: 
			// Implement open functionality here
			}
			break;
		case E$(basename)Save:
			{
			// TODO: 
            // Implement document saving here
			// NOTE: Document should have application UID in content.
			}
			break;
        default:
			{
            Panic(E$(basename)Ui);
            break;
			}
        }
    }


TBool C$(basename)AppUi::ProcessCommandParametersL( TApaCommand /*aCommand*/, TFileName& /*aDocumentName*/, const TDesC8& /*aTail*/)
	{
	// TODO: Implement ProcessCommandParametersL function to enable processing shell commands.
	return EFalse;
	}
