/*
============================================================================
 Name        : C$(basename) from $(basename).h
 Author      : $(author)
 Version     :
 Copyright   : $(copyright)
 Description : C$(basename) DLL source
============================================================================
*/

//  Include Files  

#include "$(basename).h"	// C$(basename)
#include "$(basename).pan"      	// panic codes


//  Member Functions

EXPORT_C C$(basename)* C$(basename)::NewLC()
    {
    C$(basename)* self = new (ELeave) C$(basename);
    CleanupStack::PushL(self);
    self->ConstructL();
    return self;
    }


EXPORT_C C$(basename)* C$(basename)::NewL()
    {
    C$(basename)* self = C$(basename)::NewLC();
    CleanupStack::Pop(self);
    return self;
    }


C$(basename)::C$(basename)()
// note, CBase initialises all member variables to zero
    {
    }


void C$(basename)::ConstructL()
    {
    // second phase constructor, anything that may leave must be constructed here
    iString = new (ELeave) T$(basename)ExampleString;
    }


EXPORT_C C$(basename)::~C$(basename)()
    {
    delete iString;
    }


EXPORT_C TVersion C$(basename)::Version() const
    {
    // Version number of example API
    const TInt KMajor = 1;
    const TInt KMinor = 0;
    const TInt KBuild = 1;
    return TVersion(KMajor, KMinor, KBuild);
    }


EXPORT_C void C$(basename)::ExampleFuncAddCharL(const TChar& aChar)
    {
    __ASSERT_ALWAYS(iString != NULL, Panic(E$(basename)NullPointer));

    if (iString->Length() >= K$(basename)BufferLength)
        {
        User::Leave(KErrTooBig);
        }

    iString->Append(aChar);
    }


EXPORT_C void C$(basename)::ExampleFuncRemoveLast()
    {
    __ASSERT_ALWAYS(iString != NULL, Panic(E$(basename)NullPointer));

    if (iString->Length() > 0)
        {
        iString->SetLength(iString->Length() - 1);
        }
    }


EXPORT_C const TPtrC C$(basename)::ExampleFuncString() const
    {
    __ASSERT_ALWAYS(iString != NULL, Panic(E$(basename)NullPointer));
    return *iString;
    }



