/*
-----------------------------------------------------------------------------

    basenameTest.cpp - test application source

-----------------------------------------------------------------------------
*/

//  Include Files

#include "basenameTest.h"
#include <basename.h>   // Cbasename
#include <uikon.hrh>            // command codes
#include <eikenv.h>             // CEikonEnv


//  Constants

const TUid KUidbasenameTestApp = { 0x01234567 };    // random temporary UID


//  Member Functions

CApaDocument* CbasenameTestApplication::CreateDocumentL()
    {
    return new (ELeave) CbasenameTestDocument(*this);
    }


TUid CbasenameTestApplication::AppDllUid() const
    {
    return KUidbasenameTestApp;
    }


CbasenameTestDocument::CbasenameTestDocument(CEikApplication& aApp) : CEikDocument(aApp)
    {
    }


CEikAppUi* CbasenameTestDocument::CreateAppUiL()
    {
    return new (ELeave) CbasenameTestAppUi;
    }


void CbasenameTestAppUi::ConstructL(void)
    {
    BaseConstructL();

    // Create new instance of Cbasename object to test basename.dll
    ibasenameObject = Cbasename::NewL();
    }


CbasenameTestAppUi::~CbasenameTestAppUi()
    {
    delete ibasenameObject;
    }


void CbasenameTestAppUi::ShowInfoL(const TDesC& aDes1, const TDesC& aDes2)
    {
    TBuf<256> buffer;
    const TInt KHalfSecond = 500000;

    buffer.Copy(aDes1);
    buffer.Append(aDes2);
    iEikonEnv->InfoMsg(buffer);
    User::After(KHalfSecond);
    }


void CbasenameTestAppUi::HandleCommandL(TInt aCommand)
    {
    _LIT(KTest1, "Test1: ");
    _LIT(KTest2, "Test2: ");
    TInt ch;

    switch (aCommand)
        {
        case EEikCmdFileOpen:           // Test 1
            ShowInfoL(KTest1, ibasenameObject->ExampleFuncString());
            for(ch = 'A'; ch <= 'O'; ch++)
                {
                ibasenameObject->ExampleFuncAddCharL(ch);
                ShowInfoL(KTest1, ibasenameObject->ExampleFuncString());
                }
            ShowInfoL(KTest1, ibasenameObject->ExampleFuncString());
            break;

        case EEikCmdFileOpenAnother:    // Test 2
            ShowInfoL(KTest2, ibasenameObject->ExampleFuncString());
            for(ch = 1; ch <= 20; ch++)
                {
                ibasenameObject->ExampleFuncRemoveLast();
                ShowInfoL(KTest2, ibasenameObject->ExampleFuncString());
                }
            ShowInfoL(KTest2, ibasenameObject->ExampleFuncString());
            break;

        case EEikCmdExit:
            Exit();
            break;

        default:
            break;
        }
    }


//  Global Functions

#ifdef __WINS__
GLDEF_C TInt E32Dll(TDllReason /*aReason*/)
    {
    return KErrNone;
    }
#endif


//  Exported Functions

EXPORT_C CApaApplication* NewApplication()
    {
    return new CbasenameTestApplication;
    }



