/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Target
extends BuildObject
implements ITarget {
    private String artifactName;
    private String binaryParserId;
    private String cleanCommand;
    private Map configMap;
    private List configurations;
    private String defaultExtension;
    private boolean isAbstract = false;
    private boolean isTest = false;
    private String makeCommand;
    private IResource owner;
    private ITarget parent;
    private List targetOSList;
    private Map toolMap;
    private List toolList;
    private static final IConfiguration[] emptyConfigs = new IConfiguration[0];
    private static final String EMPTY_STRING = new String();

    public Target(IResource owner) {
        this.owner = owner;
    }

    public Target(IResource owner, ITarget parent) {
        this(owner);
        this.parent = parent;
        Random r = new Random();
        r.setSeed(System.currentTimeMillis());
        int id = r.nextInt();
        if (id < 0) {
            id *= -1;
        }
        this.setId(String.valueOf(owner.getName()) + "." + parent.getId() + "." + id);
        this.setName(parent.getName());
        this.artifactName = parent.getArtifactName();
        this.binaryParserId = parent.getBinaryParserId();
        this.defaultExtension = parent.getDefaultExtension();
        this.isTest = parent.isTestTarget();
        this.cleanCommand = parent.getCleanCommand();
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo(owner, true);
        buildInfo.addTarget(this);
    }

    public Target(IConfigurationElement element) {
        IConfigurationElement targetElement;
        String os;
        this.setId(element.getAttribute("id"));
        ManagedBuildManager.addExtensionTarget(this);
        this.setName(element.getAttribute("name"));
        this.artifactName = element.getAttribute("artifactName");
        this.binaryParserId = element.getAttribute("binaryParser");
        this.defaultExtension = element.getAttribute("defaultExtension");
        String parentId = element.getAttribute("parent");
        if (parentId != null) {
            this.parent = ManagedBuildManager.getTarget(null, parentId);
            IConfiguration[] parentConfigs = this.parent.getConfigurations();
            int i = 0;
            while (i < parentConfigs.length) {
                this.addConfiguration(parentConfigs[i]);
                ++i;
            }
        }
        this.isAbstract = "true".equals(element.getAttribute("isAbstract"));
        this.isTest = "true".equals(element.getAttribute("isTest"));
        this.cleanCommand = element.getAttribute("cleanCommand");
        if (this.cleanCommand == null) {
            this.cleanCommand = this.parent.getCleanCommand();
        }
        this.makeCommand = element.getAttribute("makeCommand");
        if (this.makeCommand == null) {
            this.makeCommand = this.parent.getMakeCommand();
        }
        if ((os = element.getAttribute("osList")) != null) {
            this.targetOSList = new ArrayList();
            StringTokenizer tokens = new StringTokenizer(os, ",");
            while (tokens.hasMoreTokens()) {
                this.targetOSList.add(tokens.nextToken().trim());
            }
        }
        IConfigurationElement[] targetElements = element.getChildren();
        int k = 0;
        while (k < targetElements.length) {
            targetElement = targetElements[k];
            if (targetElement.getName().equals("tool")) {
                new Tool(this, targetElement);
            }
            ++k;
        }
        k = 0;
        while (k < targetElements.length) {
            targetElement = targetElements[k];
            if (targetElement.getName().equals("configuration")) {
                new Configuration(this, targetElement);
            }
            ++k;
        }
    }

    public Target(ManagedBuildInfo buildInfo, Element element) {
        this(buildInfo.getOwner());
        this.setId(element.getAttribute("id"));
        buildInfo.addTarget(this);
        this.setName(element.getAttribute("name"));
        this.artifactName = element.getAttribute("artifactName");
        this.defaultExtension = element.getAttribute("defaultExtension");
        String parentId = element.getAttribute("parent");
        if (parentId != null) {
            this.parent = ManagedBuildManager.getTarget(null, parentId);
        }
        if ("true".equals(element.getAttribute("isAbstract"))) {
            this.isAbstract = true;
        }
        this.isTest = "true".equals(element.getAttribute("isTest"));
        this.cleanCommand = element.getAttribute("cleanCommand");
        if (element.hasAttribute("makeCommand")) {
            this.makeCommand = element.getAttribute("makeCommand");
        }
        Node child = element.getFirstChild();
        while (child != null) {
            if (child.getNodeName().equals("configuration")) {
                new Configuration(this, (Element)child);
            }
            child = child.getNextSibling();
        }
    }

    public void removeConfiguration(String id) {
        ListIterator iter = this.configurations.listIterator();
        while (iter.hasNext()) {
            IConfiguration config = (IConfiguration)iter.next();
            if (!config.getId().equals(id)) continue;
            this.configurations.remove(config);
            this.configMap.remove(id);
            break;
        }
    }

    public void resetMakeCommand() {
        this.makeCommand = null;
    }

    public void serialize(Document doc, Element element) {
        element.setAttribute("id", this.getId());
        element.setAttribute("name", this.getName());
        if (this.parent != null) {
            element.setAttribute("parent", this.parent.getId());
        }
        element.setAttribute("isAbstract", this.isAbstract ? "true" : "false");
        element.setAttribute("artifactName", this.getArtifactName());
        element.setAttribute("defaultExtension", this.getDefaultExtension());
        element.setAttribute("isTest", this.isTest ? "true" : "false");
        element.setAttribute("cleanCommand", this.getCleanCommand());
        if (this.makeCommand != null) {
            element.setAttribute("makeCommand", this.makeCommand);
        }
        if (this.configurations != null) {
            int i = 0;
            while (i < this.configurations.size()) {
                Configuration config = (Configuration)this.configurations.get(i);
                Element configElement = doc.createElement("configuration");
                element.appendChild(configElement);
                config.serialize(doc, configElement);
                ++i;
            }
        }
    }

    public String getMakeCommand() {
        return this.makeCommand == null ? this.parent.getMakeCommand() : this.makeCommand;
    }

    public String getName() {
        return this.name == null && this.parent != null ? this.parent.getName() : this.name;
    }

    public ITarget getParent() {
        return this.parent;
    }

    public String[] getTargetOSList() {
        if (this.targetOSList == null) {
            if (this.parent != null) {
                return this.parent.getTargetOSList();
            }
            return new String[0];
        }
        return this.targetOSList.toArray(new String[this.targetOSList.size()]);
    }

    public IResource getOwner() {
        return this.owner;
    }

    private int getNumTools() {
        int n = this.getToolList().size();
        if (this.parent != null) {
            n += ((Target)this.parent).getNumTools();
        }
        return n;
    }

    private int addToolsToArray(ITool[] toolArray, int start) {
        int n = start;
        if (this.parent != null) {
            n = ((Target)this.parent).addToolsToArray(toolArray, start);
        }
        int i = 0;
        while (i < this.getToolList().size()) {
            toolArray[n++] = (ITool)this.getToolList().get(i);
            ++i;
        }
        return n;
    }

    private List getToolList() {
        if (this.toolList == null) {
            this.toolList = new ArrayList();
            this.toolList.clear();
        }
        return this.toolList;
    }

    private Map getToolMap() {
        if (this.toolMap == null) {
            this.toolMap = new HashMap();
            this.toolMap.clear();
        }
        return this.toolMap;
    }

    public ITool[] getTools() {
        ITool[] toolArray = new ITool[this.getNumTools()];
        this.addToolsToArray(toolArray, 0);
        return toolArray;
    }

    public boolean hasOverridenMakeCommand() {
        return this.makeCommand != null && !this.makeCommand.equals(this.parent.getMakeCommand());
    }

    public ITool getTool(String id) {
        ITool result = null;
        result = (ITool)this.getToolMap().get(id);
        if (result == null && this.parent != null) {
            result = ((Target)this.parent).getTool(id);
        }
        return result;
    }

    public void addTool(ITool tool) {
        this.getToolList().add(tool);
        this.getToolMap().put(tool.getId(), tool);
    }

    public IConfiguration[] getConfigurations() {
        if (this.configurations != null) {
            return this.configurations.toArray(new IConfiguration[this.configurations.size()]);
        }
        return emptyConfigs;
    }

    public String getDefaultExtension() {
        return this.defaultExtension == null ? EMPTY_STRING : this.defaultExtension;
    }

    public String getCleanCommand() {
        return this.cleanCommand == null ? EMPTY_STRING : this.cleanCommand;
    }

    public String getArtifactName() {
        if (this.artifactName == null) {
            if (this.parent != null) {
                return this.parent.getArtifactName();
            }
            return EMPTY_STRING;
        }
        return this.artifactName;
    }

    public String getBinaryParserId() {
        if (this.binaryParserId == null) {
            if (this.parent != null) {
                return this.parent.getBinaryParserId();
            }
            return EMPTY_STRING;
        }
        return this.binaryParserId;
    }

    public IConfiguration getConfiguration(String id) {
        return (IConfiguration)this.configMap.get(id);
    }

    public void addConfiguration(IConfiguration configuration) {
        if (this.configurations == null) {
            this.configurations = new ArrayList();
            this.configMap = new HashMap();
        }
        this.configurations.add(configuration);
        this.configMap.put(configuration.getId(), configuration);
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isTestTarget() {
        return this.isTest;
    }

    public IConfiguration createConfiguration(String id) {
        return new Configuration(this, id);
    }

    public IConfiguration createConfiguration(IConfiguration parent, String id) {
        return new Configuration(this, parent, id);
    }

    public void setBuildArtifact(String name) {
        if (name != null) {
            this.artifactName = name;
        }
    }

    public void setMakeCommand(String command) {
        if (command != null && !this.getMakeCommand().equals(command)) {
            this.makeCommand = command;
        }
    }
}

