/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.internal.ui.CDebugImages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddWatchpointDialog
extends Dialog {
    private Button fBtnOk = null;
    private Text fTextExpression;
    private Button fChkBtnWrite;
    private Button fChkBtnRead;
    private boolean fWrite = true;
    private boolean fRead = false;
    private String fExpression = "";

    public AddWatchpointDialog(Shell parentShell, boolean write, boolean read, String expression) {
        super(parentShell);
        this.fWrite = write;
        this.fRead = read;
        if (expression != null) {
            this.fExpression = expression;
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Add C/C++ Watchpoint");
        shell.setImage(CDebugImages.get("org.eclipse.cdt.debug.ui.readwrite_obj.gif"));
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setOkButtonState();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        ((GridLayout)composite.getLayout()).marginWidth = 10;
        composite.setLayoutData((Object)new GridData(1808));
        this.createDataWidgets(composite);
        this.initializeDataWidgets();
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.fBtnOk = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private void createDataWidgets(Composite parent) {
        this.fTextExpression = this.createExpressionText(parent);
        this.createAccessWidgets(parent);
    }

    private void initializeDataWidgets() {
        this.fTextExpression.setText(this.fExpression);
        this.fChkBtnRead.setSelection(this.fRead);
        this.fChkBtnWrite.setSelection(this.fWrite);
        this.setOkButtonState();
    }

    private Text createExpressionText(Composite parent) {
        Label label = new Label(parent, 131072);
        label.setText("Expression to watch:");
        Text text = new Text(parent, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 300;
        text.setLayoutData((Object)gridData);
        this.addModifyListener(text);
        return text;
    }

    private void createAccessWidgets(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setText("Access");
        this.fChkBtnWrite = new Button((Composite)group, 32);
        this.fChkBtnWrite.setText("Write");
        this.addSelectionListener(this.fChkBtnWrite);
        this.fChkBtnRead = new Button((Composite)group, 32);
        this.fChkBtnRead.setText("Read");
        this.addSelectionListener(this.fChkBtnRead);
    }

    private void addSelectionListener(Button button) {
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddWatchpointDialog.this.setOkButtonState();
            }
        });
    }

    protected void setOkButtonState() {
        if (this.fBtnOk == null) {
            return;
        }
        this.fBtnOk.setEnabled((this.fChkBtnRead.getSelection() || this.fChkBtnWrite.getSelection()) && this.fTextExpression.getText().trim().length() > 0);
    }

    private void storeData() {
        this.fExpression = this.fTextExpression.getText().trim();
        this.fRead = this.fChkBtnRead.getSelection();
        this.fWrite = this.fChkBtnWrite.getSelection();
    }

    private void addModifyListener(Text text) {
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddWatchpointDialog.this.setOkButtonState();
            }
        });
    }

    public String getExpression() {
        return this.fExpression;
    }

    public boolean getWriteAccess() {
        return this.fWrite;
    }

    public boolean getReadAccess() {
        return this.fRead;
    }

    protected void okPressed() {
        this.storeData();
        super.okPressed();
    }
}

