/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.impl;

import java.io.IOException;
import org.eclipse.cdt.internal.core.index.IDocument;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.IQueryResult;
import org.eclipse.cdt.internal.core.index.impl.IncludeEntry;
import org.eclipse.cdt.internal.core.index.impl.IndexedFile;
import org.eclipse.cdt.internal.core.index.impl.WordEntry;

public abstract class IndexInput {
    protected int filePosition = 1;
    protected WordEntry currentWordEntry;
    protected int wordPosition = 1;
    protected IncludeEntry currentIncludeEntry;
    protected int includePosition = 1;

    public abstract void clearCache();

    public abstract void close() throws IOException;

    public abstract IndexedFile getCurrentFile() throws IOException;

    public WordEntry getCurrentWordEntry() throws IOException {
        if (!this.hasMoreWords()) {
            return null;
        }
        return this.currentWordEntry;
    }

    public IncludeEntry getCurrentIncludeEntry() throws IOException {
        if (!this.hasMoreIncludes()) {
            return null;
        }
        return this.currentIncludeEntry;
    }

    public int getFilePosition() {
        return this.filePosition;
    }

    public abstract IndexedFile getIndexedFile(int var1) throws IOException;

    public abstract IndexedFile getIndexedFile(IDocument var1) throws IOException;

    public abstract int getNumFiles();

    public abstract int getNumWords();

    public abstract int getNumIncludes();

    public abstract Object getSource();

    public boolean hasMoreFiles() {
        return this.getFilePosition() <= this.getNumFiles();
    }

    public boolean hasMoreWords() {
        return this.wordPosition <= this.getNumWords();
    }

    public boolean hasMoreIncludes() {
        return this.includePosition <= this.getNumIncludes();
    }

    public abstract void moveToNextFile() throws IOException;

    public abstract void moveToNextWordEntry() throws IOException;

    public abstract void moveToNextIncludeEntry() throws IOException;

    public abstract void open() throws IOException;

    public abstract IQueryResult[] query(String var1) throws IOException;

    public abstract IEntryResult[] queryEntriesPrefixedBy(char[] var1) throws IOException;

    public abstract IQueryResult[] queryFilesReferringToPrefix(char[] var1) throws IOException;

    public abstract IQueryResult[] queryInDocumentNames(String var1) throws IOException;

    public abstract IncludeEntry[] queryIncludeEntries();

    public abstract IncludeEntry[] queryIncludeEntries(int var1) throws IOException;

    protected abstract void setFirstFile() throws IOException;

    protected abstract void setFirstWord() throws IOException;

    protected abstract void setFirstInclude() throws IOException;
}

