/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.IArchive;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.internal.core.model.Archive;
import org.eclipse.cdt.internal.core.model.ArchiveContainer;
import org.eclipse.cdt.internal.core.model.Binary;
import org.eclipse.cdt.internal.core.model.BinaryContainer;
import org.eclipse.cdt.internal.core.model.BinaryRunner;
import org.eclipse.cdt.internal.core.model.CContainer;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModel;
import org.eclipse.cdt.internal.core.model.CModelCache;
import org.eclipse.cdt.internal.core.model.CModelOperation;
import org.eclipse.cdt.internal.core.model.CProject;
import org.eclipse.cdt.internal.core.model.CProjectInfo;
import org.eclipse.cdt.internal.core.model.DeltaProcessor;
import org.eclipse.cdt.internal.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.NullBinaryParser;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.cdt.internal.core.model.SourceMapper;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class CModelManager
implements IResourceChangeListener {
    final CModel cModel = new CModel();
    public static HashSet OptionNames = new HashSet(20);
    protected DeltaProcessor fDeltaProcessor = new DeltaProcessor();
    private ArrayList fCModelDeltas = new ArrayList();
    protected boolean fFire = true;
    protected ArrayList fElementChangedListeners = new ArrayList();
    public Map sharedWorkingCopies = new HashMap();
    protected Map elementsOutOfSynchWithBuffers = new HashMap(11);
    protected CModelCache cache = new CModelCache();
    public ICProject[] cProjectsCache;
    private HashMap binaryRunners = new HashMap();
    private HashMap binaryParsersMap = new HashMap();
    private HashMap sourceMappers = new HashMap();
    public static final String[] sourceExtensions = new String[]{"c", "cxx", "cc", "C", "cpp"};
    public static final String[] headerExtensions = new String[]{"h", "hh", "hpp", "H"};
    public static final IWorkingCopy[] NoWorkingCopy = new IWorkingCopy[0];
    static CModelManager factory = null;

    private CModelManager() {
    }

    public static CModelManager getDefault() {
        if (factory == null) {
            factory = new CModelManager();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)factory, 15);
        }
        return factory;
    }

    public ICModel getCModel(IWorkspaceRoot root) {
        return this.getCModel();
    }

    public ICModel getCModel() {
        return this.cModel;
    }

    public ICElement create(IPath path) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource res = root.findMember(path);
        if (res == null) {
            IPath rootPath = root.getLocation();
            if (path.equals((Object)rootPath)) {
                return this.getCModel(root);
            }
            res = root.getContainerForLocation(path);
            if (res == null || !res.exists()) {
                res = root.getFileForLocation(path);
            }
            if (res != null && !res.exists()) {
                res = null;
            }
        }
        return this.create(res);
    }

    public ICElement create(IResource resource) {
        if (resource == null) {
            return null;
        }
        int type = resource.getType();
        switch (type) {
            case 4: {
                return this.create((IProject)resource);
            }
            case 1: {
                return this.create((IFile)resource);
            }
            case 2: {
                return this.create((IFolder)resource);
            }
            case 8: {
                return this.create((IWorkspaceRoot)resource);
            }
        }
        return null;
    }

    public ICElement create(ICElement parent, IResource resource) {
        int type = resource.getType();
        switch (type) {
            case 4: {
                return this.create(parent, (IProject)resource);
            }
            case 1: {
                return this.create(parent, (IFile)resource);
            }
            case 2: {
                return this.create(parent, (IFolder)resource);
            }
            case 8: {
                return this.create((IWorkspaceRoot)resource);
            }
        }
        return null;
    }

    public ICElement create(IFile file) {
        IContainer parent = file.getParent();
        ICContainer cparent = null;
        if (parent instanceof IFolder) {
            cparent = this.create((IFolder)parent);
        } else if (parent instanceof IProject) {
            cparent = this.create((IProject)parent);
        }
        if (cparent != null) {
            return this.create((ICElement)cparent, file);
        }
        return null;
    }

    public ICElement create(ICElement parent, IFile file) {
        return this.create(parent, file, null);
    }

    public synchronized ICElement create(ICElement parent, IFile file, IBinaryParser.IBinaryFile bin) {
        Openable cfile = null;
        if (this.isTranslationUnit(file)) {
            cfile = new TranslationUnit(parent, file);
        } else if (file.exists()) {
            if (bin == null) {
                bin = this.createBinaryFile(file);
            }
            if (bin != null) {
                cfile = bin.getType() == 8 ? new Archive(parent, file) : new Binary(parent, file, bin);
            }
        }
        if (cfile != null && (cfile instanceof IBinary || cfile instanceof IArchive)) {
            if (bin == null) {
                bin = this.createBinaryFile(file);
            }
            if (bin != null) {
                if (bin.getType() == 8) {
                    CProject cproj = (CProject)cfile.getCProject();
                    ArchiveContainer container = (ArchiveContainer)cproj.getArchiveContainer();
                    container.addChild(cfile);
                } else if (bin.getType() == 2 || bin.getType() == 4) {
                    CProject cproj = (CProject)cfile.getCProject();
                    BinaryContainer container = (BinaryContainer)cproj.getBinaryContainer();
                    container.addChild(cfile);
                }
            }
        }
        return cfile;
    }

    public ICContainer create(IFolder folder) {
        IContainer parent = folder.getParent();
        ICContainer cparent = null;
        if (parent instanceof IFolder) {
            cparent = this.create((IFolder)parent);
        } else if (parent instanceof IProject) {
            cparent = this.create((IProject)parent);
        }
        if (cparent != null) {
            return this.create((ICElement)cparent, folder);
        }
        return null;
    }

    public ICContainer create(ICElement parent, IFolder folder) {
        return new CContainer(parent, (IResource)folder);
    }

    public ICProject create(IProject project) {
        IContainer parent = project.getParent();
        ICModel celement = null;
        if (parent instanceof IWorkspaceRoot) {
            celement = this.create((IWorkspaceRoot)parent);
        }
        return this.create(celement, project);
    }

    public ICProject create(ICElement parent, IProject project) {
        if (this.hasCNature(project)) {
            return new CProject(parent, project);
        }
        return null;
    }

    public ICModel create(IWorkspaceRoot root) {
        return this.getCModel();
    }

    public void releaseCElement(ICElement celement) {
        Parent parent;
        CElementInfo info;
        Openable container;
        CProject cproj;
        if (celement == null) {
            return;
        }
        int type = celement.getElementType();
        if (type == 18) {
            cproj = (CProject)celement.getCProject();
            container = (ArchiveContainer)cproj.getArchiveContainer();
            container.removeChild(celement);
        } else if (type == 14 && !((IBinary)celement).isObject()) {
            cproj = (CProject)celement.getCProject();
            container = (BinaryContainer)cproj.getBinaryContainer();
            container.removeChild(celement);
        }
        if (celement instanceof IParent && this.peekAtInfo(celement) != null && (info = ((CElement)celement).getElementInfo()) != null) {
            ICElement[] children = info.getChildren();
            int i = 0;
            while (i < children.length) {
                this.releaseCElement(children[i]);
                ++i;
            }
            if (info instanceof CProjectInfo) {
                CProjectInfo pinfo = (CProjectInfo)info;
                if (pinfo.vBin != null) {
                    this.releaseCElement(pinfo.vBin);
                }
                if (pinfo.vLib != null) {
                    this.releaseCElement(pinfo.vLib);
                }
            }
        }
        if ((parent = (Parent)celement.getParent()) != null) {
            parent.removeChild(celement);
        }
        this.removeInfo(celement);
    }

    public IBinaryParser getBinaryParser(IProject project) {
        try {
            IBinaryParser parser = (IBinaryParser)this.binaryParsersMap.get(project);
            if (parser == null) {
                parser = CCorePlugin.getDefault().getBinaryParser(project);
            }
            if (parser != null) {
                this.binaryParsersMap.put(project, parser);
                return parser;
            }
        }
        catch (CoreException coreException) {}
        return new NullBinaryParser();
    }

    public IBinaryParser.IBinaryFile createBinaryFile(IFile file) {
        try {
            IPath location;
            IBinaryParser parser = this.getBinaryParser(file.getProject());
            InputStream is = file.getContents();
            byte[] bytes = new byte[128];
            int count = is.read(bytes);
            is.close();
            if (count > 0 && count < bytes.length) {
                byte[] array = new byte[count];
                System.arraycopy(bytes, 0, array, 0, count);
                bytes = array;
            }
            if (parser.isBinary(bytes, location = file.getLocation())) {
                return parser.getBinary(location);
            }
        }
        catch (IOException iOException) {
        }
        catch (CoreException coreException) {}
        return null;
    }

    public void resetBinaryParser(IProject project) {
        ICProject celement;
        if (project != null && (celement = this.create(project)) != null) {
            this.releaseCElement(celement);
            this.binaryParsersMap.remove(project);
            celement = this.create(project);
            Parent parent = (Parent)celement.getParent();
            CElementInfo info = parent.getElementInfo();
            info.addChild(celement);
            CElementDelta delta = new CElementDelta(this.getCModel());
            delta.binaryParserChanged(celement);
            this.registerCModelDelta(delta);
            this.fire();
        }
    }

    public boolean isSharedLib(IFile file) {
        try {
            IBinaryParser parser = this.getBinaryParser(file.getProject());
            IBinaryParser.IBinaryFile bin = parser.getBinary(file.getLocation());
            return bin.getType() == 4;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean isObject(IFile file) {
        try {
            IBinaryParser parser = this.getBinaryParser(file.getProject());
            IBinaryParser.IBinaryFile bin = parser.getBinary(file.getLocation());
            return bin.getType() == 1;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean isExecutable(IFile file) {
        try {
            IBinaryParser parser = this.getBinaryParser(file.getProject());
            IBinaryParser.IBinaryFile bin = parser.getBinary(file.getLocation());
            return bin.getType() == 2;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean isBinary(IFile file) {
        try {
            IBinaryParser parser = this.getBinaryParser(file.getProject());
            IBinaryParser.IBinaryFile bin = parser.getBinary(file.getLocation());
            return bin.getType() == 2 || bin.getType() == 1 || bin.getType() == 4 || bin.getType() == 16;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean isArchive(IFile file) {
        try {
            IBinaryParser parser = this.getBinaryParser(file.getProject());
            IBinaryParser.IBinaryFile bin = parser.getBinary(file.getLocation());
            return bin.getType() == 8;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean isTranslationUnit(IFile file) {
        return this.isValidTranslationUnitName(file.getName());
    }

    public boolean isValidTranslationUnitName(String name) {
        if (name == null) {
            return false;
        }
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return false;
        }
        String ext = name.substring(index + 1);
        String[] cexts = this.getTranslationUnitExtensions();
        int i = 0;
        while (i < cexts.length) {
            if (ext.equals(cexts[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String[] getHeaderExtensions() {
        return headerExtensions;
    }

    public String[] getSourceExtensions() {
        return sourceExtensions;
    }

    public String[] getTranslationUnitExtensions() {
        String[] headers = this.getHeaderExtensions();
        String[] sources = this.getSourceExtensions();
        String[] cexts = new String[headers.length + sources.length];
        System.arraycopy(sources, 0, cexts, 0, sources.length);
        System.arraycopy(headers, 0, cexts, sources.length, headers.length);
        return cexts;
    }

    public boolean hasCNature(IProject p) {
        boolean ok = false;
        try {
            ok = p.isOpen() && p.hasNature("org.eclipse.cdt.core.cnature");
        }
        catch (CoreException coreException) {}
        return ok;
    }

    public boolean hasCCNature(IProject p) {
        boolean ok = false;
        try {
            ok = p.isOpen() && p.hasNature("org.eclipse.cdt.core.ccnature");
        }
        catch (CoreException coreException) {}
        return ok;
    }

    public BinaryRunner getBinaryRunner(ICProject project) {
        BinaryRunner runner = null;
        HashMap hashMap = this.binaryRunners;
        synchronized (hashMap) {
            runner = (BinaryRunner)this.binaryRunners.get(project.getProject());
            if (runner == null) {
                runner = new BinaryRunner(project.getProject());
                this.binaryRunners.put(project.getProject(), runner);
                runner.start();
            }
        }
        return runner;
    }

    public SourceMapper getSourceMapper(ICProject cProject) {
        SourceMapper mapper = null;
        HashMap hashMap = this.sourceMappers;
        synchronized (hashMap) {
            mapper = (SourceMapper)this.sourceMappers.get(cProject);
            if (mapper == null) {
                mapper = new SourceMapper(cProject);
                this.sourceMappers.put(cProject, mapper);
            }
        }
        return mapper;
    }

    public synchronized void addElementChangedListener(IElementChangedListener listener) {
        if (this.fElementChangedListeners.indexOf(listener) < 0) {
            this.fElementChangedListeners.add(listener);
        }
    }

    public synchronized void removeElementChangedListener(IElementChangedListener listener) {
        int i = this.fElementChangedListeners.indexOf(listener);
        if (i != -1) {
            this.fElementChangedListeners.remove(i);
        }
    }

    public synchronized void registerCModelDelta(ICElementDelta delta) {
        this.fCModelDeltas.add(delta);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getSource() instanceof IWorkspace) {
            IResourceDelta delta = event.getDelta();
            IResource resource = event.getResource();
            switch (event.getType()) {
                case 4: {
                    try {
                        if (resource.getType() != 4 || !((IProject)resource).hasNature("org.eclipse.cdt.core.cnature") && !((IProject)resource).hasNature("org.eclipse.cdt.core.ccnature")) break;
                        this.deleting((IProject)resource);
                    }
                    catch (CoreException coreException) {}
                    break;
                }
                case 8: {
                    if (delta == null) break;
                    this.checkProjectsBeingAddedOrRemoved(delta);
                    break;
                }
                case 1: {
                    try {
                        if (delta == null) break;
                        ICElementDelta[] translatedDeltas = this.fDeltaProcessor.processResourceDelta(delta);
                        if (translatedDeltas.length > 0) {
                            int i = 0;
                            while (i < translatedDeltas.length) {
                                this.registerCModelDelta(translatedDeltas[i]);
                                ++i;
                            }
                        }
                        this.fire();
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void fire() {
        if (!this.fFire) return;
        this.mergeDeltas();
        try {
            Iterator iterator = ((AbstractList)this.fCModelDeltas).iterator();
            while (iterator.hasNext()) {
                ICElementDelta delta = (ICElementDelta)iterator.next();
                ElementChangedEvent event = new ElementChangedEvent(delta);
                ArrayList listeners = (ArrayList)this.fElementChangedListeners.clone();
                int i = 0;
                while (i < listeners.size()) {
                    IElementChangedListener listener = (IElementChangedListener)listeners.get(i);
                    listener.elementChanged(event);
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.flush();
            throw throwable;
        }
        {
            Object var7_9 = null;
            this.flush();
            return;
        }
    }

    protected synchronized void flush() {
        this.fCModelDeltas = new ArrayList();
    }

    private void mergeDeltas() {
        if (this.fCModelDeltas.size() <= 1) {
            return;
        }
        Iterator deltas = ((AbstractList)this.fCModelDeltas).iterator();
        ICModel cRoot = this.getCModel();
        CElementDelta rootDelta = new CElementDelta(cRoot);
        boolean insertedTree = false;
        while (deltas.hasNext()) {
            CElementDelta delta = (CElementDelta)deltas.next();
            ICElement element = delta.getElement();
            if (cRoot.equals(element)) {
                ICElementDelta[] children = delta.getAffectedChildren();
                int j = 0;
                while (j < children.length) {
                    CElementDelta projectDelta = (CElementDelta)children[j];
                    rootDelta.insertDeltaTree(projectDelta.getElement(), projectDelta);
                    insertedTree = true;
                    ++j;
                }
                continue;
            }
            rootDelta.insertDeltaTree(element, delta);
            insertedTree = true;
        }
        if (insertedTree) {
            this.fCModelDeltas = new ArrayList(1);
            this.fCModelDeltas.add(rootDelta);
        } else {
            this.fCModelDeltas = new ArrayList(0);
        }
    }

    /*
     * Exception decompiling
     */
    public void runOperation(CModelOperation operation, IProgressMonitor monitor) throws CModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 149->153)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void checkProjectsBeingAddedOrRemoved(IResourceDelta delta) {
        IResource resource = delta.getResource();
        switch (resource.getType()) {
            case 8: {
                if (this.cProjectsCache == null) {
                    this.cProjectsCache = this.getCModel().getCProjects();
                }
                IResourceDelta[] children = delta.getAffectedChildren();
                int i = 0;
                int length = children.length;
                while (i < length) {
                    this.checkProjectsBeingAddedOrRemoved(children[i]);
                    ++i;
                }
                break;
            }
            case 4: {
                if ((delta.getFlags() & 0x4000) == 0) break;
                IProject project = (IProject)resource;
                if (!project.isOpen()) {
                    BinaryRunner runner = (BinaryRunner)this.binaryRunners.get(project);
                    if (runner == null) break;
                    runner.stop();
                    break;
                }
                if (this.binaryRunners.get(project) != null) break;
                this.binaryRunners.put(project, new BinaryRunner(project));
            }
        }
    }

    protected Map getElementsOutOfSynchWithBuffers() {
        return this.elementsOutOfSynchWithBuffers;
    }

    public Object getInfo(ICElement element) {
        return this.cache.getInfo(element);
    }

    protected Object peekAtInfo(ICElement element) {
        return this.cache.peekAtInfo(element);
    }

    protected void putInfo(ICElement element, Object info) {
        this.cache.putInfo(element, info);
    }

    protected void removeInfo(ICElement element) {
        this.cache.removeInfo(element);
    }

    public void startup() {
    }

    public void shutdown() {
        if (this.fDeltaProcessor.indexManager != null) {
            this.fDeltaProcessor.indexManager.shutdown();
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)factory);
        BinaryRunner[] runners = this.binaryRunners.values().toArray(new BinaryRunner[0]);
        int i = 0;
        while (i < runners.length) {
            runners[i].stop();
            ++i;
        }
    }

    public IndexManager getIndexManager() {
        return this.fDeltaProcessor.indexManager;
    }

    public void deleting(IProject project) {
        this.getIndexManager().discardJobs(project.getName());
        BinaryRunner runner = (BinaryRunner)this.binaryRunners.remove(project);
        if (runner != null) {
            runner.stop();
        }
        this.binaryParsersMap.remove(project);
    }
}

