/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.drag;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.internal.ui.drag.TransferDragSourceListener;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class FileTransferDragAdapter
implements TransferDragSourceListener {
    private final ISelectionProvider provider;
    static /* synthetic */ Class class$0;

    public FileTransferDragAdapter(ISelectionProvider provider) {
        this.provider = provider;
        Assert.isNotNull((Object)provider);
    }

    public Transfer getTransfer() {
        return FileTransfer.getInstance();
    }

    public void dragStart(DragSourceEvent event) {
        event.doit = !this.getResources().isEmpty();
    }

    public void dragSetData(DragSourceEvent event) {
        String[] locations = FileTransferDragAdapter.getResourceLocations(this.getResources());
        event.data = locations.length != 0 ? locations : null;
    }

    public void dragFinished(DragSourceEvent event) {
        if (event.doit && event.detail != 2 && (event.detail == 0 || event.detail == 8)) {
            FileTransferDragAdapter.runOperation((IRunnableWithProgress)new RefreshOperation(this.getResources()), true, false);
        }
    }

    private List getResources() {
        ArrayList<IResource> result = Collections.EMPTY_LIST;
        ISelection selection = this.provider.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structured = (IStructuredSelection)selection;
            result = new ArrayList<IResource>(structured.size());
            Iterator iterator = structured.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                IResource resource = null;
                if (object instanceof IResource) {
                    resource = (IResource)object;
                } else if (object instanceof IAdaptable) {
                    IAdaptable iAdaptable = (IAdaptable)object;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("[Lorg.eclipse.core.resources.IResource;").getComponentType();
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    resource = (IResource)iAdaptable.getAdapter((Class)clazz);
                }
                if (resource == null) continue;
                result.add(resource);
            }
        }
        return result;
    }

    private static String[] getResourceLocations(List resources) {
        int count = resources.size();
        ArrayList<String> locations = new ArrayList<String>(count);
        Iterator iterator = resources.iterator();
        while (iterator.hasNext()) {
            IResource resource = (IResource)iterator.next();
            IPath location = resource.getLocation();
            if (location == null) continue;
            locations.add(location.toOSString());
        }
        String[] result = new String[locations.size()];
        locations.toArray(result);
        return result;
    }

    private static void runOperation(IRunnableWithProgress operation, boolean fork, boolean cancelable) {
        try {
            IWorkbench workbench = CUIPlugin.getDefault().getWorkbench();
            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
            Shell parent = window.getShell();
            new ProgressMonitorDialog(parent).run(fork, cancelable, operation);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            String message = CUIMessages.getString("Problem while moving or copying files.");
            String title = CUIMessages.getString("Drag & Drop");
            ExceptionHandler.handle(e, title, message);
        }
    }

    private static class RefreshOperation
    extends WorkspaceModifyOperation {
        private final Set roots;

        public RefreshOperation(List resources) {
            this.roots = new HashSet(resources.size());
            Iterator iterator = resources.iterator();
            while (iterator.hasNext()) {
                IResource resource = (IResource)iterator.next();
                IContainer parent = resource.getParent();
                this.roots.add(parent != null ? parent : resource);
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void execute(IProgressMonitor monitor) throws CoreException {
            try {
                monitor.beginTask(CUIMessages.getString("DragAdapter.refreshing"), this.roots.size());
                MultiStatus status = new MultiStatus(CUIPlugin.getPluginId(), 0, CUIMessages.getString("DragAdapter.problem"), null);
                Iterator iterator = this.roots.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        if (status.isOK()) break;
                        throw new CoreException((IStatus)status);
                    }
                    IResource resource = (IResource)iterator.next();
                    try {
                        resource.refreshLocal(1, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    catch (CoreException e) {
                        status.add(e.getStatus());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                monitor.done();
                throw throwable;
            }
            {
                Object var6_8 = null;
            }
            monitor.done();
        }
    }
}

