/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class CWordFinder {
    public static IRegion findWord(IDocument document, int offset) {
        int start = -1;
        int end = -1;
        try {
            char c;
            int pos = offset;
            while (pos >= 0) {
                c = document.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                --pos;
            }
            start = pos;
            pos = offset;
            int length = document.getLength();
            while (pos < length) {
                c = document.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                ++pos;
            }
            end = pos;
        }
        catch (BadLocationException badLocationException) {}
        if (start > -1 && end > -1) {
            if (start == offset && end == offset) {
                return new Region(offset, 0);
            }
            if (start == offset) {
                return new Region(start, end - start);
            }
            return new Region(start + 1, end - start - 1);
        }
        return null;
    }

    public static IRegion findFunction(IDocument document, int offset) {
        int leftbracket = -1;
        int leftbracketcount = 0;
        int rightbracket = -1;
        int rightbracketcount = 0;
        int functionstart = -1;
        int functionend = -1;
        try {
            char c;
            int length = document.getLength();
            int pos = offset;
            leftbracketcount = 0;
            rightbracketcount = 0;
            while (pos < length) {
                c = document.getChar(pos);
                if (c == ')' && ++rightbracketcount >= leftbracketcount) {
                    rightbracket = pos;
                    break;
                }
                if (c == '(') {
                    ++leftbracketcount;
                }
                if (c == ';') break;
                ++pos;
            }
            if (rightbracket == -1) {
                return new Region(offset, 0);
            }
            pos = rightbracket;
            leftbracketcount = 0;
            rightbracketcount = 0;
            while (pos >= 0) {
                c = document.getChar(pos);
                if (c == ')') {
                    ++rightbracketcount;
                }
                if (c == '(' && ++leftbracketcount >= rightbracketcount) {
                    leftbracket = pos;
                    break;
                }
                if (c == ';') break;
                --pos;
            }
            if (leftbracket == -1) {
                return new Region(offset, 0);
            }
            pos = leftbracket - 1;
            while (pos >= 0) {
                c = document.getChar(pos);
                if (functionend == -1 && c == ' ') {
                    --pos;
                    continue;
                }
                if (Character.isJavaIdentifierPart(c)) {
                    functionstart = pos;
                    if (functionend == -1) {
                        functionend = pos;
                    }
                    --pos;
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException badLocationException) {}
        if (functionstart > -1 && functionend > -1) {
            return new Region(functionstart, functionend - functionstart + 1);
        }
        return null;
    }
}

