/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import java.io.File;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class GNUElfBinaryParserPage
extends AbstractCOptionPage {
    public static final String PREF_ADDR2LINE_PATH = "org.eclipse.cdt.ui.addr2line";
    public static final String PREF_CPPFILT_PATH = "org.eclipse.cdt.ui.cppfilt";
    protected Text fAddr2LineCommandText;
    protected Text fCPPFiltCommandText;

    public void performApply(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String addr2line = this.fAddr2LineCommandText.getText().trim();
        String cppfilt = this.fCPPFiltCommandText.getText().trim();
        monitor.beginTask("Saving Attributes", 1);
        IProject proj = this.getContainer().getProject();
        if (proj != null) {
            ICDescriptor cdesc = CCorePlugin.getDefault().getCProjectDescription(proj);
            ICExtensionReference[] cext = cdesc.get("org.eclipse.cdt.core.BinaryParser");
            if (cext.length == 0) {
                IPluginDescriptor descriptor = CUIPlugin.getDefault().getDescriptor();
                IExtensionPoint point = descriptor.getExtensionPoint("BinaryParserPage");
                IConfigurationElement[] infos = point.getConfigurationElements();
                int i = 0;
                while (i < infos.length) {
                    String id = infos[i].getAttribute("parserID");
                    String clazz = infos[i].getAttribute("class");
                    String ego = this.getClass().getName();
                    if (clazz != null && clazz.equals(ego)) {
                        cdesc.remove("org.eclipse.cdt.core.BinaryParser");
                        cdesc.create("org.eclipse.cdt.core.BinaryParser", id);
                    }
                    ++i;
                }
                cext = cdesc.get("org.eclipse.cdt.core.BinaryParser");
            }
            if (cext.length > 0) {
                String orig = cext[0].getExtensionData("addr2line");
                if (orig == null || !orig.equals(addr2line)) {
                    cext[0].setExtensionData("addr2line", addr2line);
                }
                if ((orig = cext[0].getExtensionData("c++filt")) == null || !orig.equals(cppfilt)) {
                    cext[0].setExtensionData("c++filt", cppfilt);
                }
            }
        } else {
            Preferences store = this.getContainer().getPreferences();
            if (store != null) {
                store.setValue(PREF_ADDR2LINE_PATH, addr2line);
                store.setValue(PREF_CPPFILT_PATH, cppfilt);
            }
        }
    }

    public void performDefaults() {
        String addr2line = null;
        String cppfilt = null;
        IProject proj = this.getContainer().getProject();
        if (proj != null) {
            try {
                ICDescriptor cdesc = CCorePlugin.getDefault().getCProjectDescription(proj);
                ICExtensionReference[] cext = cdesc.get("org.eclipse.cdt.core.BinaryParser");
                if (cext.length > 0) {
                    addr2line = cext[0].getExtensionData("addr2line");
                    cppfilt = cext[0].getExtensionData("c++filt");
                }
            }
            catch (CoreException coreException) {}
        } else {
            Preferences store = this.getContainer().getPreferences();
            if (store != null) {
                addr2line = store.getString(PREF_ADDR2LINE_PATH);
                cppfilt = store.getString(PREF_CPPFILT_PATH);
            }
        }
        this.fAddr2LineCommandText.setText(addr2line == null || addr2line.length() == 0 ? "addr2line" : addr2line);
        this.fCPPFiltCommandText.setText(cppfilt == null || cppfilt.length() == 0 ? "c++filt" : cppfilt);
    }

    public void createControl(Composite parent) {
        Composite comp = ControlFactory.createCompositeEx(parent, 2, 768);
        ((GridLayout)comp.getLayout()).makeColumnsEqualWidth = false;
        Label label = ControlFactory.createLabel(comp, "addr2line Command:");
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.fAddr2LineCommandText = ControlFactory.createTextField(comp, 2052);
        this.fAddr2LineCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
            }
        });
        Button button = ControlFactory.createPushButton(comp, "&Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                this.handleAddr2LineButtonSelected();
            }

            private void handleAddr2LineButtonSelected() {
                String res;
                FileDialog dialog = new FileDialog(GNUElfBinaryParserPage.this.getShell(), 0);
                dialog.setText("addr2line Command");
                String command = GNUElfBinaryParserPage.this.fAddr2LineCommandText.getText().trim();
                int lastSeparatorIndex = command.lastIndexOf(File.separator);
                if (lastSeparatorIndex != -1) {
                    dialog.setFilterPath(command.substring(0, lastSeparatorIndex));
                }
                if ((res = dialog.open()) == null) {
                    return;
                }
                GNUElfBinaryParserPage.this.fAddr2LineCommandText.setText(res);
            }
        });
        label = ControlFactory.createLabel(comp, "c++filt Command:");
        gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.fCPPFiltCommandText = ControlFactory.createTextField(comp, 2052);
        gd = new GridData(768);
        this.fCPPFiltCommandText.setLayoutData((Object)gd);
        this.fCPPFiltCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
            }
        });
        button = ControlFactory.createPushButton(comp, "&Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                this.handleCPPFiltButtonSelected();
            }

            private void handleCPPFiltButtonSelected() {
                String res;
                FileDialog dialog = new FileDialog(GNUElfBinaryParserPage.this.getShell(), 0);
                dialog.setText("c++filt Command");
                String command = GNUElfBinaryParserPage.this.fCPPFiltCommandText.getText().trim();
                int lastSeparatorIndex = command.lastIndexOf(File.separator);
                if (lastSeparatorIndex != -1) {
                    dialog.setFilterPath(command.substring(0, lastSeparatorIndex));
                }
                if ((res = dialog.open()) == null) {
                    return;
                }
                GNUElfBinaryParserPage.this.fCPPFiltCommandText.setText(res);
            }
        });
        this.setControl((Control)comp);
        this.performDefaults();
    }
}

