/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IFunction;
import org.eclipse.cdt.core.model.IMethod;
import org.eclipse.cdt.debug.core.CDebugModel;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionDelegate;

public class ManageFunctionBreakpointActionDelegate
extends ActionDelegate
implements IObjectActionDelegate {
    private ICElement fElement = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.getMethod() != null) {
            this.manageBreakpoint(this.getMethod());
        } else if (this.getFunction() != null) {
            this.manageBreakpoint(this.getFunction());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object element;
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof ICElement) {
            boolean enabled = this.enablesFor((ICElement)element);
            action.setEnabled(enabled);
            if (enabled) {
                this.setElement((ICElement)element);
                return;
            }
        }
        action.setEnabled(false);
        this.setElement(null);
    }

    public ICElement getElement() {
        return this.fElement;
    }

    public void setElement(ICElement element) {
        this.fElement = element;
    }

    private boolean enablesFor(ICElement element) {
        return true;
    }

    private void manageBreakpoint(IFunction function) {
        try {
            ICFunctionBreakpoint breakpoint = CDebugModel.functionBreakpointExists((IFunction)function);
            if (breakpoint != null) {
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)breakpoint, true);
            } else {
                CDebugModel.createFunctionBreakpoint((IFunction)function, (boolean)true, (int)0, (String)"", (boolean)true);
            }
        }
        catch (CoreException e) {
            CDebugUIPlugin.errorDialog("Cannot add breakpoint", e);
        }
    }

    private IFunction getFunction() {
        IFunction iFunction;
        if (this.getElement() != null) {
            ICElement iCElement = this.getElement();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.cdt.core.model.IFunction;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iFunction = (IFunction)iCElement.getAdapter((Class)clazz);
        } else {
            iFunction = null;
        }
        return iFunction;
    }

    private void manageBreakpoint(IMethod method) {
        try {
            ICFunctionBreakpoint breakpoint = CDebugModel.methodBreakpointExists((IMethod)method);
            if (breakpoint != null) {
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)breakpoint, true);
            } else {
                CDebugModel.createMethodBreakpoint((IMethod)method, (boolean)true, (int)0, (String)"", (boolean)true);
            }
        }
        catch (CoreException e) {
            CDebugUIPlugin.errorDialog("Cannot add breakpoint", e);
        }
    }

    private IMethod getMethod() {
        IMethod iMethod;
        if (this.getElement() != null) {
            ICElement iCElement = this.getElement();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("[Lorg.eclipse.cdt.core.model.IMethod;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iMethod = (IMethod)iCElement.getAdapter((Class)clazz);
        } else {
            iMethod = null;
        }
        return iMethod;
    }
}

