/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.preferences;

import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation;
import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.PixelConverter;
import org.eclipse.cdt.debug.internal.ui.dialogfields.DialogField;
import org.eclipse.cdt.debug.internal.ui.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.debug.internal.ui.dialogfields.IListAdapter;
import org.eclipse.cdt.debug.internal.ui.dialogfields.LayoutUtil;
import org.eclipse.cdt.debug.internal.ui.dialogfields.SelectionButtonDialogField;
import org.eclipse.cdt.debug.internal.ui.wizards.AddSourceLocationWizard;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.sourcelookup.SourceListDialogField;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class SourcePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
Observer {
    private SourceListDialogField fSourceListField;
    private SelectionButtonDialogField fSearchForDuplicateFiles;
    private boolean fChanged = false;

    public SourcePreferencePage() {
        this.setPreferenceStore(CDebugUIPlugin.getDefault().getPreferenceStore());
        this.setDescription("Common source lookup settings.");
    }

    protected Control createContents(Composite parent) {
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)ICDebugHelpContextIds.SOURCE_PREFERENCE_PAGE);
        this.fSourceListField = this.createSourceListField();
        this.fSearchForDuplicateFiles = this.createSearchForDuplicateFilesButton();
        Composite control = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        control.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        control.setLayoutData((Object)data);
        control.setFont(JFaceResources.getDialogFont());
        PixelConverter converter = new PixelConverter((Control)control);
        this.fSourceListField.doFillIntoGrid(control, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fSourceListField.getLabelControl(null), 2);
        LayoutUtil.setWidthHint((Control)this.fSourceListField.getLabelControl(null), converter.convertWidthInCharsToPixels(40));
        LayoutUtil.setHorizontalGrabbing(this.fSourceListField.getListControl(null));
        this.fSearchForDuplicateFiles.doFillIntoGrid(control, 3);
        this.setValues();
        return control;
    }

    public void init(IWorkbench workbench) {
    }

    public void update(Observable o, Object arg) {
        this.setChanged(true);
    }

    private SourceListDialogField createSourceListField() {
        SourceListDialogField field = new SourceListDialogField("Source Locations", new IListAdapter(){

            public void customButtonPressed(DialogField field, int index) {
                SourcePreferencePage.this.sourceButtonPressed(index);
            }

            public void selectionChanged(DialogField field) {
            }
        });
        field.addObserver(this);
        return field;
    }

    private SelectionButtonDialogField createSearchForDuplicateFilesButton() {
        SelectionButtonDialogField button = new SelectionButtonDialogField(32);
        button.setLabelText("Search for duplicate source files");
        button.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                SourcePreferencePage.this.setChanged(true);
            }
        });
        return button;
    }

    protected void sourceButtonPressed(int index) {
        switch (index) {
            case 0: {
                if (!this.addSourceLocation()) break;
                this.setChanged(true);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                this.setChanged(true);
            }
        }
    }

    protected boolean isChanged() {
        return this.fChanged;
    }

    protected void setChanged(boolean changed) {
        this.fChanged = changed;
    }

    private boolean addSourceLocation() {
        AddSourceLocationWizard wizard = new AddSourceLocationWizard(this.getSourceLocations());
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        if (dialog.open() == 0) {
            this.fSourceListField.addElement(wizard.getSourceLocation());
            return true;
        }
        return false;
    }

    public ICSourceLocation[] getSourceLocations() {
        return this.fSourceListField != null ? this.fSourceListField.getSourceLocations() : new ICSourceLocation[]{};
    }

    public void setSourceLocations(ICSourceLocation[] locations) {
        if (this.fSourceListField != null) {
            this.fSourceListField.setElements(Arrays.asList(locations));
        }
    }

    protected void performDefaults() {
        this.setSourceLocations(new ICSourceLocation[0]);
        this.setSearchForDuplicateFiles(false);
        super.performDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        CDebugCorePlugin.getDefault().savePluginPreferences();
        return true;
    }

    private boolean searchForDuplicateFiles() {
        return this.fSearchForDuplicateFiles != null ? this.fSearchForDuplicateFiles.isSelected() : false;
    }

    private void setSearchForDuplicateFiles(boolean search) {
        if (this.fSearchForDuplicateFiles != null) {
            this.fSearchForDuplicateFiles.setSelection(search);
        }
    }

    private void setValues() {
        this.setSourceLocations(CDebugCorePlugin.getDefault().getCommonSourceLocations());
        this.setSearchForDuplicateFiles(CDebugCorePlugin.getDefault().getPluginPreferences().getBoolean(ICDebugConstants.PREF_SEARCH_DUPLICATE_FILES));
    }

    private void storeValues() {
        CDebugCorePlugin.getDefault().saveCommonSourceLocations(this.getSourceLocations());
        CDebugCorePlugin.getDefault().getPluginPreferences().setValue(ICDebugConstants.PREF_SEARCH_DUPLICATE_FILES, this.searchForDuplicateFiles());
    }
}

