/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.sourcelookup;

import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.dom.DocumentImpl;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.model.IStackFrameInfo;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.core.sourcelookup.SourceLookupFactory;
import org.eclipse.cdt.debug.internal.ui.CDebugImageDescriptorRegistry;
import org.eclipse.cdt.debug.internal.ui.CDebugImages;
import org.eclipse.cdt.debug.internal.ui.dialogfields.SelectionButtonDialogField;
import org.eclipse.cdt.debug.internal.ui.editors.FileNotFoundElement;
import org.eclipse.cdt.debug.internal.ui.editors.NoSymbolOrSourceElement;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DefaultSourceLocator
implements IPersistableSourceLocator,
IAdaptable {
    public static final String ID_DEFAULT_SOURCE_LOCATOR = String.valueOf(CDebugUIPlugin.getUniqueIdentifier()) + ".DefaultSourceLocator";
    public static final String ID_OLD_DEFAULT_SOURCE_LOCATOR = "org.eclipse.cdt.launch.DefaultSourceLocator";
    private static final String ELEMENT_NAME = "PromptingSourceLocator";
    private static final String ATTR_PROJECT = "project";
    private static final String ATTR_MEMENTO = "memento";
    private IProject fProject = null;
    private ICSourceLocator fSourceLocator;
    private HashMap fFramesToSource = null;
    private HashMap fNamesToSource = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public String getMemento() throws CoreException {
        if (this.fSourceLocator != null) {
            DocumentImpl doc = new DocumentImpl();
            Element node = doc.createElement(ELEMENT_NAME);
            doc.appendChild(node);
            node.setAttribute(ATTR_PROJECT, this.fSourceLocator.getProject().getName());
            IPersistableSourceLocator psl = this.getPersistableSourceLocator();
            if (psl != null) {
                node.setAttribute(ATTR_MEMENTO, psl.getMemento());
            }
            try {
                return CDebugUtils.serializeDocument((Document)doc, (String)" ");
            }
            catch (IOException e) {
                this.abort("Unable to create memento for C/C++ source locator.", e);
            }
        }
        return null;
    }

    public void initializeFromMemento(String memento) throws CoreException {
        Exception ex = null;
        try {
            ICSourceLocator locator;
            IProject project;
            Element root = null;
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            StringReader reader = new StringReader(memento);
            InputSource source = new InputSource(reader);
            root = parser.parse(source).getDocumentElement();
            if (!root.getNodeName().equalsIgnoreCase(ELEMENT_NAME)) {
                this.abort("Unable to restore prompting source locator - invalid format.", null);
            }
            String projectName = root.getAttribute(ATTR_PROJECT);
            String data = root.getAttribute(ATTR_MEMENTO);
            if (this.isEmpty(projectName)) {
                this.abort("Unable to restore prompting source locator - invalid format.", null);
            }
            if ((project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) == null || !project.exists() || !project.isOpen()) {
                this.abort(MessageFormat.format("Unable to restore prompting source locator - project {0} not found.", projectName), null);
            }
            if ((locator = this.getCSourceLocator()) == null) {
                this.fSourceLocator = SourceLookupFactory.createSourceLocator((IProject)project);
            } else if (locator.getProject() != null && !project.equals((Object)locator.getProject())) {
                return;
            }
            IPersistableSourceLocator psl = this.getPersistableSourceLocator();
            if (psl != null) {
                psl.initializeFromMemento(data);
            } else {
                this.abort("Unable to restore C/C++ source locator - invalid format.", null);
            }
            return;
        }
        catch (ParserConfigurationException e) {
            ex = e;
        }
        catch (SAXException e) {
            ex = e;
        }
        catch (IOException e) {
            ex = e;
        }
        this.abort("Exception occurred initializing source locator.", ex);
    }

    public void initializeDefaults(ILaunchConfiguration configuration) throws CoreException {
        this.fSourceLocator = SourceLookupFactory.createSourceLocator((IProject)this.getProject(configuration));
        String memento = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, "");
        if (!this.isEmpty(memento)) {
            this.initializeFromMemento(memento);
        }
    }

    public Object getAdapter(Class adapter) {
        if (this.fSourceLocator instanceof IAdaptable) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter.equals(clazz)) {
                return ((IAdaptable)this.fSourceLocator).getAdapter(adapter);
            }
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("[Lorg.eclipse.core.resources.IResourceChangeListener;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter.equals(clazz2)) {
                return ((IAdaptable)this.fSourceLocator).getAdapter(adapter);
            }
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("[Lorg.eclipse.cdt.debug.core.sourcelookup.ISourceMode;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter.equals(clazz3)) {
                return ((IAdaptable)this.fSourceLocator).getAdapter(adapter);
            }
        }
        return null;
    }

    public Object getSourceElement(IStackFrame stackFrame) {
        Object res = this.cacheLookup(stackFrame);
        if (res == null && (res = this.fSourceLocator.getSourceElement(stackFrame)) instanceof List) {
            List list = (List)res;
            if (list.size() != 0) {
                SourceSelectionDialog dialog = this.createSourceSelectionDialog(list);
                dialog.open();
                Object[] objs = dialog.getResult();
                Object object = res = objs != null && objs.length > 0 ? objs[0] : null;
                if (res != null) {
                    this.cacheSourceElement(stackFrame, res, dialog.alwaysMapToSelection());
                }
            } else {
                res = null;
            }
        }
        if (res == null) {
            IStackFrameInfo frameInfo;
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("[Lorg.eclipse.cdt.debug.core.model.IStackFrameInfo;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            res = (frameInfo = (IStackFrameInfo)stackFrame.getAdapter((Class)clazz)) != null && frameInfo.getFile() != null && frameInfo.getFile().length() > 0 ? new FileNotFoundElement(stackFrame) : new NoSymbolOrSourceElement(stackFrame);
        }
        return res;
    }

    public IProject getProject() {
        return this.fProject;
    }

    protected void saveChanges(ILaunchConfiguration configuration, IPersistableSourceLocator locator) {
        try {
            ILaunchConfigurationWorkingCopy copy = configuration.copy(configuration.getName());
            copy.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, locator.getMemento());
            copy.doSave();
        }
        catch (CoreException e) {
            CDebugUIPlugin.errorDialog(e.getMessage(), null);
        }
    }

    private SourceSelectionDialog createSourceSelectionDialog(List list) {
        SourceSelectionDialog dialog = new SourceSelectionDialog(CDebugUIPlugin.getActiveWorkbenchShell());
        dialog.setInput(list.toArray());
        dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        dialog.setLabelProvider((ILabelProvider)new SourceElementLabelProvider());
        dialog.setTitle("Selection needed");
        dialog.setMessage("Debugger has found multiple files with the same name.\nPlease select one associated with the selected stack frame.");
        dialog.setInitialSelections(new Object[]{list.get(0)});
        return dialog;
    }

    private void cacheSourceElement(IStackFrame frame, Object sourceElement, boolean alwaysMapToSelection) {
        if (alwaysMapToSelection) {
            String name = this.getFileName(frame);
            if (name != null) {
                if (this.fNamesToSource == null) {
                    this.fNamesToSource = new HashMap();
                }
                this.fNamesToSource.put(name, sourceElement);
            }
        } else {
            if (this.fFramesToSource == null) {
                this.fFramesToSource = new HashMap();
            }
            this.fFramesToSource.put(frame, sourceElement);
        }
    }

    private Object cacheLookup(IStackFrame frame) {
        Object result;
        String name = this.getFileName(frame);
        if (name != null && this.fNamesToSource != null && (result = this.fNamesToSource.get(name)) != null) {
            return result;
        }
        return this.fFramesToSource != null ? this.fFramesToSource.get(frame) : null;
    }

    private String getFileName(IStackFrame frame) {
        String name;
        IStackFrameInfo frameInfo;
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("[Lorg.eclipse.cdt.debug.core.model.IStackFrameInfo;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((frameInfo = (IStackFrameInfo)frame.getAdapter((Class)clazz)) != null && (name = frameInfo.getFile()) != null && name.trim().length() > 0) {
            return name.trim();
        }
        return null;
    }

    private ICSourceLocator getCSourceLocator() {
        return this.fSourceLocator;
    }

    private IPersistableSourceLocator getPersistableSourceLocator() {
        ICSourceLocator sl = this.getCSourceLocator();
        return sl instanceof IPersistableSourceLocator ? (IPersistableSourceLocator)sl : null;
    }

    private void abort(String message, Throwable e) throws CoreException {
        Status s = new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 0, message, e);
        throw new CoreException((IStatus)s);
    }

    private boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    private IProject getProject(ILaunchConfiguration configuration) throws CoreException {
        IProject project;
        String projectName = configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", null);
        if (!this.isEmpty(projectName) && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)).exists()) {
            return project;
        }
        this.abort(MessageFormat.format("Project \"{0}\" does not exist.", projectName), null);
        return null;
    }

    public class SourceSelectionDialog
    extends ListDialog {
        private SelectionButtonDialogField fAlwaysUseThisFileButton = new SelectionButtonDialogField(32);

        public SourceSelectionDialog(Shell parent) {
            super(parent);
        }

        protected Control createDialogArea(Composite parent) {
            Composite comp = ControlFactory.createComposite((Composite)parent, (int)1);
            super.createDialogArea(comp);
            Composite comp1 = ControlFactory.createComposite((Composite)comp, (int)1);
            this.fAlwaysUseThisFileButton.setLabelText("Always map to the selection");
            this.fAlwaysUseThisFileButton.doFillIntoGrid(comp1, 1);
            return comp;
        }

        public boolean alwaysMapToSelection() {
            return this.fAlwaysUseThisFileButton.isSelected();
        }
    }

    public class SourceElementLabelProvider
    extends LabelProvider {
        protected CDebugImageDescriptorRegistry fDebugImageRegistry = CDebugUIPlugin.getImageDescriptorRegistry();

        public String getText(Object element) {
            if (element instanceof IFile) {
                return ((IFile)element).getFullPath().toString();
            }
            if (element instanceof FileStorage) {
                return ((FileStorage)element).getFullPath().toOSString();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof IFile) {
                return this.fDebugImageRegistry.get(CDebugImages.DESC_OBJS_WORKSPACE_SOURCE_FILE);
            }
            if (element instanceof FileStorage) {
                return this.fDebugImageRegistry.get(CDebugImages.DESC_OBJS_EXTERNAL_SOURCE_FILE);
            }
            return super.getImage(element);
        }
    }
}

