/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.template.c;

import org.eclipse.cdt.internal.corext.template.ContextType;
import org.eclipse.cdt.internal.corext.template.Template;
import org.eclipse.cdt.internal.corext.template.TemplateBuffer;
import org.eclipse.cdt.internal.corext.template.TemplateTranslator;
import org.eclipse.cdt.internal.corext.template.c.CFormatter;
import org.eclipse.cdt.internal.corext.template.c.CompilationUnitContext;
import org.eclipse.cdt.internal.corext.template.c.ICompilationUnit;
import org.eclipse.cdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.cdt.internal.corext.textmanipulation.TextUtil;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;

public class CContext
extends CompilationUnitContext {
    public CContext(ContextType type, String string, int completionPosition, ICompilationUnit compilationUnit) {
        super(type, string, completionPosition, compilationUnit);
    }

    public int getStart() {
        String string = this.getString();
        int start = this.getCompletionPosition();
        while (start != 0 && Character.isUnicodeIdentifierPart(string.charAt(start - 1))) {
            --start;
        }
        if (start != 0 && Character.isUnicodeIdentifierStart(string.charAt(start - 1))) {
            --start;
        }
        return start;
    }

    public int getIndentationLevel() {
        String string = this.getString();
        int start = this.getStart();
        try {
            TextBuffer textBuffer = TextBuffer.create(string);
            String lineContent = textBuffer.getLineContentOfOffset(start);
            return TextUtil.getIndent(lineContent, CUIPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.cdt.editor.tab.width"));
        }
        catch (CoreException coreException) {
            return 0;
        }
    }

    public boolean canEvaluate(Template template) {
        return template.matches(this.getKey(), this.getContextType().getName());
    }

    public TemplateBuffer evaluate(Template template) throws CoreException {
        if (!this.canEvaluate(template)) {
            return null;
        }
        TemplateTranslator translator = new TemplateTranslator();
        TemplateBuffer buffer = translator.translate(template.getPattern());
        this.getContextType().edit(buffer, this);
        CFormatter formatter = new CFormatter();
        formatter.edit(buffer, this);
        return buffer;
    }
}

