/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IMember;
import org.eclipse.cdt.core.model.IMethod;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.core.search.BasicSearchMatch;
import org.eclipse.cdt.core.search.BasicSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchPattern;
import org.eclipse.cdt.core.search.ICSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.matching.OrPattern;
import org.eclipse.cdt.internal.core.search.processing.IJob;
import org.eclipse.cdt.internal.core.sourcedependency.DependencyQueryJob;
import org.eclipse.cdt.internal.corext.template.ContextType;
import org.eclipse.cdt.internal.corext.template.ContextTypeRegistry;
import org.eclipse.cdt.internal.ui.CCompletionContributorManager;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.text.CCompletionProposal;
import org.eclipse.cdt.internal.ui.text.CCompletionProposalComparator;
import org.eclipse.cdt.internal.ui.text.CParameterListValidator;
import org.eclipse.cdt.internal.ui.text.CWordFinder;
import org.eclipse.cdt.internal.ui.text.ICCompletionProposal;
import org.eclipse.cdt.internal.ui.text.template.TemplateEngine;
import org.eclipse.cdt.ui.CSearchResultLabelProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.FunctionPrototypeSummary;
import org.eclipse.cdt.ui.IFunctionSummary;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;

public class CCompletionProcessor
implements IContentAssistProcessor {
    private CEditor fEditor;
    private char[] fProposalAutoActivationSet;
    private CCompletionProposalComparator fComparator;
    private IContextInformationValidator fValidator;
    private TemplateEngine[] fTemplateEngine;
    private boolean fRestrictToMatchingCase;
    private boolean fAllowAddIncludes;
    BasicSearchResultCollector resultCollector = null;
    SearchEngine searchEngine = null;
    CSearchResultLabelProvider labelProvider = null;

    public CCompletionProcessor(IEditorPart editor) {
        this.fEditor = (CEditor)editor;
        this.labelProvider = new CSearchResultLabelProvider();
        this.resultCollector = new BasicSearchResultCollector();
        this.searchEngine = new SearchEngine();
        String[] contextNames = new String[2];
        ArrayList<TemplateEngine> templateList = new ArrayList<TemplateEngine>(2);
        String filename = null;
        if (this.fEditor != null && this.fEditor.getEditorInput() != null) {
            filename = this.fEditor.getEditorInput().getName();
        }
        if (filename == null) {
            contextNames[0] = "C";
            contextNames[1] = "C++";
        } else if (filename.endsWith(".c")) {
            contextNames[0] = "C";
        } else if (filename.endsWith(".cpp") || filename.endsWith(".cc") || filename.endsWith(".cxx") || filename.endsWith(".C") || filename.endsWith(".hxx")) {
            contextNames[0] = "C++";
            contextNames[1] = "C";
        } else {
            IFile file = this.fEditor.getInputFile();
            if (file != null && CoreModel.getDefault().hasCCNature(file.getProject())) {
                contextNames[0] = "C++";
                contextNames[1] = "C";
            } else {
                contextNames[0] = "C";
            }
        }
        int i = 0;
        while (i < contextNames.length) {
            ContextType contextType = ContextTypeRegistry.getInstance().getContextType(contextNames[i]);
            if (contextType != null) {
                templateList.add(new TemplateEngine(contextType));
            }
            ++i;
        }
        this.fTemplateEngine = templateList.toArray(new TemplateEngine[templateList.size()]);
        this.fRestrictToMatchingCase = false;
        this.fAllowAddIncludes = true;
        this.fComparator = new CCompletionProposalComparator();
    }

    public void orderProposalsAlphabetically(boolean order) {
        this.fComparator.setOrderAlphabetically(order);
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        if (this.fValidator == null) {
            this.fValidator = new CParameterListValidator();
        }
        return this.fValidator;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.fProposalAutoActivationSet;
    }

    public void setCompletionProposalAutoActivationCharacters(char[] activationSet) {
        this.fProposalAutoActivationSet = activationSet;
    }

    public void restrictProposalsToMatchingCases(boolean restrict) {
    }

    public void allowAddingIncludes(boolean allowAddingIncludes) {
        this.fAllowAddIncludes = allowAddingIncludes;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        IWorkingCopyManager fManager = CUIPlugin.getDefault().getWorkingCopyManager();
        ITranslationUnit unit = fManager.getWorkingCopy(this.fEditor.getEditorInput());
        IDocument document = viewer.getDocument();
        ICompletionProposal[] results = null;
        try {
            if (document != null) {
                int offset = documentOffset;
                int length = 0;
                Point selection = viewer.getSelectedRange();
                if (selection.y > 0) {
                    offset = selection.x;
                    length = selection.y;
                }
                results = this.evalProposals(document, offset, length, unit);
            }
        }
        catch (Exception e) {
            CUIPlugin.getDefault().log(e);
        }
        if (results == null) {
            results = new ICCompletionProposal[]{};
        }
        int i = 0;
        while (i < this.fTemplateEngine.length) {
            if (this.fTemplateEngine[i] != null) {
                try {
                    this.fTemplateEngine[i].reset();
                    this.fTemplateEngine[i].complete(viewer, documentOffset, null);
                }
                catch (Exception x) {
                    CUIPlugin.getDefault().log(x);
                }
                ICCompletionProposal[] templateResults = this.fTemplateEngine[i].getResults();
                if (results.length == 0) {
                    results = templateResults;
                } else {
                    ICCompletionProposal[] total = new ICCompletionProposal[results.length + templateResults.length];
                    System.arraycopy(templateResults, 0, total, 0, templateResults.length);
                    System.arraycopy(results, 0, total, templateResults.length, results.length);
                    results = total;
                }
            }
            ++i;
        }
        this.order((ICCompletionProposal[])results);
        return results;
    }

    private ICElement getCurrentScope(ITranslationUnit unit, int documentOffset) {
        Map elements = unit.parse();
        ITranslationUnit currentScope = unit;
        Iterator i = elements.keySet().iterator();
        while (i.hasNext()) {
            CElement currentScopeElement;
            CElement element = (CElement)i.next();
            if (element.getStartPos() >= documentOffset || element.getStartPos() + element.getLength() <= documentOffset) continue;
            if (currentScope instanceof ITranslationUnit) {
                currentScope = element;
                continue;
            }
            if (!(currentScope instanceof CElement) || (currentScopeElement = (CElement)currentScope).getStartPos() >= element.getStartPos() || currentScopeElement.getStartPos() + currentScopeElement.getLength() <= element.getStartPos() + element.getLength()) continue;
            currentScope = element;
        }
        return currentScope;
    }

    private ICCompletionProposal[] order(ICCompletionProposal[] proposals) {
        if (proposals != null) {
            Arrays.sort(proposals, this.fComparator);
        }
        return proposals;
    }

    public ICCompletionProposal[] evalProposals(IDocument document, int pos, int length, ITranslationUnit unit) {
        return this.order(this.evalProposals(document, pos, length, this.getCurrentScope(unit, pos)));
    }

    private ICCompletionProposal[] evalProposals(IDocument document, int startPos, int length, ICElement currentScope) {
        IRegion region;
        boolean isDereference = false;
        String frag = "";
        int pos = startPos;
        if (pos > 0) {
            --pos;
        }
        if (pos > 1) {
            int struct_pos = pos;
            try {
                while (document.getChar(struct_pos) == ' ') {
                    --struct_pos;
                }
                if (document.getChar(struct_pos) == '.') {
                    isDereference = true;
                    pos -= struct_pos - 1;
                } else if (document.getChar(struct_pos) == '>' && document.getChar(struct_pos - 1) == '-') {
                    isDereference = true;
                    pos -= struct_pos - 2;
                } else {
                    isDereference = false;
                }
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        if ((region = CWordFinder.findWord(document, pos)) == null) {
            return null;
        }
        if (isDereference) {
            return null;
        }
        try {
            frag = document.get(region.getOffset(), startPos - region.getOffset());
            frag = frag.trim();
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        if (frag.length() == 0) {
            String funcfrag = "";
            IRegion funcregion = CWordFinder.findFunction(document, pos + 1);
            if (funcregion != null) {
                try {
                    funcfrag = document.get(funcregion.getOffset(), funcregion.getLength());
                    funcfrag = funcfrag.trim();
                }
                catch (Exception exception) {
                    funcfrag = "";
                }
                if (funcfrag.length() == 0) {
                    return null;
                }
                region = funcregion;
                frag = funcfrag;
            }
        }
        ArrayList completions = new ArrayList();
        this.addProposalsFromModel(region, frag, currentScope, completions);
        this.addProposalsFromCompletionContributors(region, frag, completions);
        return completions.toArray(new ICCompletionProposal[0]);
    }

    private void addProposalsFromCompletionContributors(IRegion region, String frag, ArrayList completions) {
        IFunctionSummary[] summary = CCompletionContributorManager.getDefault().getMatchingFunctions(frag);
        if (summary == null) {
            return;
        }
        int i = 0;
        while (i < summary.length) {
            String fname = String.valueOf(summary[i].getName()) + "()";
            String fdesc = summary[i].getDescription();
            IFunctionSummary.IFunctionPrototypeSummary fproto = summary[i].getPrototype();
            String fargs = fproto.getArguments();
            CCompletionProposal proposal = new CCompletionProposal(fname, region.getOffset(), region.getLength(), CPluginImages.get("org.eclipse.cdt.ui.function_obj.gif"), fproto.getPrototypeString(true), 2);
            if (fdesc != null) {
                proposal.setAdditionalProposalInfo(fdesc);
            }
            if (fargs != null && fargs.length() > 0) {
                proposal.setContextInformation((IContextInformation)new ContextInformation(fname, fargs));
            }
            completions.add(proposal);
            ++i;
        }
    }

    private FunctionPrototypeSummary getPrototype(BasicSearchMatch match) {
        switch (match.getElementType()) {
            case 67: 
            case 68: 
            case 70: 
            case 71: {
                return new FunctionPrototypeSummary(String.valueOf(match.getReturnType()) + " " + match.getName());
            }
        }
        return null;
    }

    private int calculateRelevance(BasicSearchMatch element) {
        int type = element.getElementType();
        switch (type) {
            case 69: {
                return 9;
            }
            case 74: 
            case 75: {
                return 8;
            }
            case 67: 
            case 68: {
                return 7;
            }
            case 70: 
            case 71: {
                return 6;
            }
            case 64: {
                return 5;
            }
            case 65: {
                return 4;
            }
            case 66: {
                return 3;
            }
            case 77: {
                return 2;
            }
            case 63: {
                return 1;
            }
        }
        return 0;
    }

    private void addProposalsFromModel(IRegion region, String frag, ICElement currentScope, ArrayList completions) {
        LinkedList<BasicSearchMatch> elementsFound = new LinkedList<BasicSearchMatch>();
        String prefix = String.valueOf(frag) + "*";
        if (currentScope == null) {
            return;
        }
        IPreferenceStore store = CUIPlugin.getDefault().getPreferenceStore();
        boolean projectScope = store.getBoolean("content_assist_project_scope_search");
        ICSearchScope scope = null;
        if (projectScope) {
            ICElement[] projectScopeElement = new ICElement[]{(ICElement)currentScope.getCProject()};
            scope = SearchEngine.createCSearchScope((ICElement[])projectScopeElement, (boolean)true);
        } else {
            IResource actualFile = currentScope.getUnderlyingResource();
            IProject project = currentScope.getCProject().getProject();
            ArrayList dependencies = new ArrayList();
            if (actualFile != null) {
                try {
                    IndexManager indexMan = CCorePlugin.getDefault().getCoreModel().getIndexManager();
                    indexMan.performConcurrentJob((IJob)new DependencyQueryJob(project, (IFile)actualFile, indexMan, dependencies), 3, null, null);
                }
                catch (Exception exception) {}
            }
            scope = SearchEngine.createCFileSearchScope((IFile)((IFile)actualFile), dependencies);
        }
        OrPattern orPattern = new OrPattern();
        orPattern.addPattern(SearchEngine.createSearchPattern((String)prefix, (ICSearchConstants.SearchFor)ICSearchConstants.VAR, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
        orPattern.addPattern(SearchEngine.createSearchPattern((String)prefix, (ICSearchConstants.SearchFor)ICSearchConstants.FUNCTION, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
        orPattern.addPattern(SearchEngine.createSearchPattern((String)prefix, (ICSearchConstants.SearchFor)ICSearchConstants.FUNCTION, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)false));
        orPattern.addPattern(SearchEngine.createSearchPattern((String)prefix, (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
        orPattern.addPattern(SearchEngine.createSearchPattern((String)prefix, (ICSearchConstants.SearchFor)ICSearchConstants.ENUM, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
        orPattern.addPattern(SearchEngine.createSearchPattern((String)prefix, (ICSearchConstants.SearchFor)ICSearchConstants.MACRO, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
        this.searchEngine.search(CUIPlugin.getWorkspace(), (ICSearchPattern)orPattern, scope, (ICSearchResultCollector)this.resultCollector, true);
        elementsFound.addAll(this.resultCollector.getSearchResults());
        if (currentScope instanceof IMethod || currentScope instanceof IMethodDeclaration) {
            IStructure parentClass = (IStructure)currentScope.getParent();
            ArrayList children = new ArrayList();
            children.addAll(parentClass.getChildrenOfType(67));
            children.addAll(parentClass.getChildrenOfType(68));
            children.addAll(parentClass.getChildrenOfType(69));
            Iterator c = ((AbstractList)children).iterator();
            while (c.hasNext()) {
                IMember child = (IMember)c.next();
                if (!child.getElementName().startsWith(frag)) continue;
                BasicSearchMatch childMatch = new BasicSearchMatch();
                childMatch.setType(child.getElementType());
                childMatch.setParentName(parentClass.getElementName());
                if (child.getVisibility() == ASTAccessVisibility.PUBLIC) {
                    childMatch.setVisibility(8192);
                } else if (child.getVisibility() == ASTAccessVisibility.PROTECTED) {
                    childMatch.setVisibility(16384);
                } else if (child.getVisibility() == ASTAccessVisibility.PRIVATE) {
                    childMatch.setVisibility(4096);
                }
                childMatch.setConst(child.isConst());
                childMatch.setVolatile(child.isVolatile());
                childMatch.setStatic(child.isStatic());
                if (child instanceof IMethodDeclaration) {
                    childMatch.setName(((IMethodDeclaration)child).getSignature());
                    childMatch.setReturnType(((IMethodDeclaration)child).getReturnType());
                } else {
                    childMatch.setName(child.getElementName());
                }
                elementsFound.add(childMatch);
            }
        }
        Iterator i = elementsFound.iterator();
        while (i.hasNext()) {
            String fargs;
            String replaceString = "";
            String displayString = "";
            Image image = null;
            StringBuffer infoString = new StringBuffer();
            BasicSearchMatch match = (BasicSearchMatch)i.next();
            FunctionPrototypeSummary fproto = this.getPrototype(match);
            if (fproto != null) {
                replaceString = String.valueOf(fproto.getName()) + "()";
                displayString = fproto.getPrototypeString(true);
            } else {
                replaceString = displayString = match.getName();
            }
            image = this.labelProvider.getImage(match);
            infoString.append(displayString);
            if (match.getParentName().length() > 0) {
                infoString.append(" - Parent: ");
                infoString.append(match.getParentName());
            }
            CCompletionProposal proposal = new CCompletionProposal(replaceString, region.getOffset(), region.getLength(), image, displayString, this.calculateRelevance(match));
            completions.add(proposal);
            if (fproto != null && (fargs = fproto.getArguments()) != null && fargs.length() > 0) {
                proposal.setContextInformation((IContextInformation)new ContextInformation(replaceString, fargs));
            }
            if (displayString.equals(infoString.toString())) continue;
            proposal.setAdditionalProposalInfo(infoString.toString());
        }
    }
}

