/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.CConventions;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IOpenable;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.search.BasicSearchMatch;
import org.eclipse.cdt.core.search.BasicSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchPattern;
import org.eclipse.cdt.core.search.ICSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.internal.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.cdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LinkToFileGroup;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.Separator;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.cdt.ui.CSearchResultLabelProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.CodeGeneration;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ContainerGenerator;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class NewClassWizardPage
extends WizardPage
implements Listener {
    private static final String PAGE_NAME = "NewClassWizardPage";
    private final String HEADER_EXT = ".h";
    private final String BODY_EXT = ".cpp";
    private IStructuredSelection currentSelection;
    private ICElement eSelection = null;
    private ITranslationUnit parentHeaderTU = null;
    private ITranslationUnit parentBodyTU = null;
    private ICElement createdClass = null;
    private List elementsOfTypeClassInProject = null;
    private StringDialogField fClassNameDialogField;
    private StringButtonDialogField fBaseClassDialogField;
    private SelectionButtonDialogFieldGroup fAccessButtons;
    private SelectionButtonDialogFieldGroup fConstDestButtons;
    private LinkToFileGroup linkedResourceGroupForHeader;
    private LinkToFileGroup linkedResourceGroupForBody;
    private final int PUBLIC_INDEX = 0;
    private final int PROTECTED_INDEX = 1;
    private final int PRIVATE_INDEX = 2;
    private final int DEFAULT_INDEX = 3;
    private IStatus fCurrStatus;
    protected IStatus fClassNameStatus;
    protected IStatus fBaseClassStatus;
    private boolean hasCppNature = false;
    BasicSearchResultCollector resultCollector;
    SearchEngine searchEngine;

    public NewClassWizardPage(IStructuredSelection selection) {
        super(PAGE_NAME);
        this.currentSelection = selection;
        this.hasCppNature = this.isSelectionCPP(this.currentSelection);
        if (this.hasCppNature) {
            this.initializePageControls();
        }
    }

    protected void initializePageControls() {
        TypeFieldsAdapter adapter = new TypeFieldsAdapter();
        this.fClassNameDialogField = new StringDialogField();
        this.fClassNameDialogField.setDialogFieldListener(adapter);
        this.fClassNameDialogField.setLabelText(NewWizardMessages.getString("NewClassWizardPage.classname.label"));
        this.fBaseClassDialogField = new StringButtonDialogField(adapter);
        this.fBaseClassDialogField.setDialogFieldListener(adapter);
        this.fBaseClassDialogField.setLabelText(NewWizardMessages.getString("NewClassWizardPage.baseclass.label"));
        this.fBaseClassDialogField.setButtonLabel(NewWizardMessages.getString("NewClassWizardPage.baseclass.button"));
        String[] buttonNames1 = new String[]{NewWizardMessages.getString("NewClassWizardPage.baseclass.access.public"), NewWizardMessages.getString("NewClassWizardPage.baseclass.access.protected"), NewWizardMessages.getString("NewClassWizardPage.baseclass.access.private"), NewWizardMessages.getString("NewClassWizardPage.baseclass.access.access")};
        this.fAccessButtons = new SelectionButtonDialogFieldGroup(16, buttonNames1, 4);
        this.fAccessButtons.setDialogFieldListener(adapter);
        this.fAccessButtons.setLabelText(NewWizardMessages.getString("NewClassWizardPage.baseclass.access.label"));
        this.fAccessButtons.setSelection(0, true);
        String[] buttonNames2 = new String[]{NewWizardMessages.getString("NewClassWizardPage.constdest.inline"), NewWizardMessages.getString("NewClassWizardPage.constdest.virtualdestructor"), NewWizardMessages.getString("NewClassWizardPage.constdest.includeguard")};
        this.fConstDestButtons = new SelectionButtonDialogFieldGroup(32, buttonNames2, 3);
        this.fConstDestButtons.setDialogFieldListener(adapter);
        this.linkedResourceGroupForHeader = new LinkToFileGroup(adapter, this);
        this.linkedResourceGroupForHeader.setLabelText(NewWizardMessages.getString("NewClassWizardPage.files.header"));
        this.linkedResourceGroupForBody = new LinkToFileGroup(adapter, this);
        this.linkedResourceGroupForBody.setLabelText(NewWizardMessages.getString("NewClassWizardPage.files.body"));
        this.fClassNameStatus = new StatusInfo();
        this.fBaseClassStatus = new StatusInfo();
        this.resultCollector = new BasicSearchResultCollector();
        this.searchEngine = new SearchEngine();
    }

    public void init() {
        if (this.hasCppNature) {
            this.fAccessButtons.setEnabled(false);
            this.setPageComplete(false);
            this.eSelection = this.getSelectionCElement(this.currentSelection);
        } else {
            StatusInfo status = new StatusInfo();
            status.setError(NewWizardMessages.getString("NewClassWizardPage.error.NotAvailableForNonCppProjects"));
            this.updateStatus(status);
        }
    }

    public void createControl(Composite parent) {
        if (!this.hasCppNature) {
            this.setControl((Control)new Composite(parent, 0));
            return;
        }
        int nColumns = 5;
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(nColumns, false));
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        this.createClassNameControls(composite, nColumns);
        this.createBaseClassControls(composite, nColumns);
        this.createModifierControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createFilesControls(composite, nColumns);
        composite.layout();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    protected void createClassNameControls(Composite composite, int nColumns) {
        this.fClassNameDialogField.doFillIntoGrid(composite, nColumns - 1);
        DialogField.createEmptySpace(composite);
        LayoutUtil.setWidthHint((Control)this.fClassNameDialogField.getTextControl(null), this.getMaxFieldWidth());
    }

    protected void createBaseClassControls(Composite composite, int nColumns) {
        this.fBaseClassDialogField.doFillIntoGrid(composite, nColumns);
        LayoutUtil.setWidthHint((Control)this.fBaseClassDialogField.getTextControl(null), this.getMaxFieldWidth());
        this.createAccessControls(composite, nColumns);
    }

    protected void createAccessControls(Composite composite, int nColumns) {
        LayoutUtil.setHorizontalSpan((Control)this.fAccessButtons.getLabelControl(composite), 1);
        Composite control = this.fAccessButtons.getSelectionButtonsGroup(composite);
        GridData gd = new GridData(256);
        gd.horizontalSpan = nColumns - 2;
        control.setLayoutData((Object)gd);
        DialogField.createEmptySpace(composite);
    }

    protected void createModifierControls(Composite composite, int nColumns) {
        LayoutUtil.setHorizontalSpan((Control)this.fConstDestButtons.getLabelControl(composite), 1);
        Composite control = this.fConstDestButtons.getSelectionButtonsGroup(composite);
        GridData gd = new GridData(256);
        gd.horizontalSpan = nColumns - 1;
        control.setLayoutData((Object)gd);
        DialogField.createEmptySpace(composite);
    }

    protected void createFilesControls(Composite composite, int nColumns) {
        this.linkedResourceGroupForHeader.doFillIntoGrid(composite, nColumns);
        this.linkedResourceGroupForBody.doFillIntoGrid(composite, nColumns);
    }

    protected void createSeparator(Composite composite, int nColumns) {
        new Separator(258).doFillIntoGrid(composite, nColumns, this.convertHeightInCharsToPixels(1));
    }

    protected int getMaxFieldWidth() {
        return this.convertWidthInCharsToPixels(40);
    }

    public void handleEvent(Event event) {
    }

    private void classPageChangeControlPressed(DialogField field) {
        BasicSearchMatch element;
        if (field == this.fBaseClassDialogField && (element = (BasicSearchMatch)this.chooseBaseClass()) != null) {
            this.fBaseClassDialogField.setText(element.getName());
        }
    }

    private void classPageCustomButtonPressed(DialogField field, int index) {
    }

    private void classPageDialogFieldChanged(DialogField field) {
        if (field == this.fClassNameDialogField) {
            String text = this.fClassNameDialogField.getText();
            if (!this.linkedResourceGroupForHeader.linkCreated()) {
                if (text.length() > 0) {
                    this.linkedResourceGroupForHeader.setText(String.valueOf(text) + ".h");
                } else {
                    this.linkedResourceGroupForHeader.setText(text);
                }
            }
            if (!this.linkedResourceGroupForBody.linkCreated()) {
                if (text.length() > 0) {
                    this.linkedResourceGroupForBody.setText(String.valueOf(text) + ".cpp");
                } else {
                    this.linkedResourceGroupForBody.setText(text);
                }
            }
            this.fClassNameStatus = this.classNameChanged();
        }
        if (field == this.fBaseClassDialogField) {
            if (this.fBaseClassDialogField.getText().length() >= 0) {
                this.fAccessButtons.setEnabled(true);
                this.fBaseClassStatus = this.baseClassNameChanged();
            } else {
                this.fAccessButtons.setEnabled(false);
            }
        }
        this.doStatusUpdate();
    }

    public boolean selectionIsCpp() {
        return this.hasCppNature;
    }

    private boolean isSelectionCPP(IStructuredSelection sel) {
        IProject project = null;
        ICElement element = this.getSelectionCElement(sel);
        if (element == null) {
            IResource resource = this.getSelectionResourceElement(sel);
            project = resource.getProject();
        } else {
            project = element.getCProject().getProject();
        }
        if (project != null) {
            return CoreModel.getDefault().hasCCNature(project);
        }
        return false;
    }

    private ICElement getSelectionCElement(IStructuredSelection sel) {
        Object element;
        List list;
        if (!sel.isEmpty() && sel instanceof IStructuredSelection && (list = sel.toList()).size() == 1 && (element = list.get(0)) instanceof ICElement) {
            return (ICElement)element;
        }
        return null;
    }

    private IResource getSelectionResourceElement(IStructuredSelection sel) {
        Object element;
        List list;
        if (!sel.isEmpty() && sel instanceof IStructuredSelection && (list = sel.toList()).size() == 1 && (element = list.get(0)) instanceof IResource) {
            if (element instanceof IFile) {
                IFile file = (IFile)element;
                return (IResource)file.getParent();
            }
            return (IResource)element;
        }
        return null;
    }

    private void getChildrenOfTypeClass(IParent parent, List elementsFound, IProgressMonitor monitor, int worked) {
        ICElement[] elements = parent.getChildren();
        monitor.worked(worked);
        int i = 0;
        while (i < elements.length) {
            ICElement element = elements[i];
            if (element.getElementType() == 64) {
                elementsFound.add(element);
            }
            if (element instanceof IParent) {
                this.getChildrenOfTypeClass((IParent)element, elementsFound, monitor, worked + 1);
            }
            ++i;
        }
    }

    private void searchForClasses(ICProject cProject, List elementsFound, IProgressMonitor monitor, int worked) {
        ICSearchPattern pattern = SearchEngine.createSearchPattern((String)"*", (ICSearchConstants.SearchFor)ICSearchConstants.CLASS, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false);
        ICElement[] elements = new ICElement[]{cProject};
        ICSearchScope scope = SearchEngine.createCSearchScope((ICElement[])elements, (boolean)true);
        this.searchEngine.search(CUIPlugin.getWorkspace(), pattern, scope, (ICSearchResultCollector)this.resultCollector, false);
        elementsFound.addAll(this.resultCollector.getSearchResults());
    }

    private List getClassElementsInProject() {
        return this.elementsOfTypeClassInProject;
    }

    private List findClassElementsInProject() {
        if (this.eSelection == null) {
            return new LinkedList();
        }
        if (this.elementsOfTypeClassInProject != null) {
            return this.elementsOfTypeClassInProject;
        }
        this.elementsOfTypeClassInProject = new LinkedList();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask(NewWizardMessages.getString("NewClassWizardPage.operations.getProjectClasses"), 5);
                try {
                    ICProject cProject = NewClassWizardPage.this.eSelection.getCProject();
                    NewClassWizardPage.this.searchForClasses(cProject, NewClassWizardPage.this.elementsOfTypeClassInProject, monitor, 1);
                    monitor.worked(5);
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                monitor.done();
            }
        };
        try {
            this.getWizard().getContainer().run(false, true, runnable);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        return this.elementsOfTypeClassInProject;
    }

    protected Object chooseBaseClass() {
        List elementsFound = this.findClassElementsInProject();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new CSearchResultLabelProvider());
        dialog.setTitle(NewWizardMessages.getString("BaseClassSelectionDialog.title"));
        dialog.setMessage(NewWizardMessages.getString("BaseClassSelectionDialog.message"));
        dialog.setElements(elementsFound.toArray());
        dialog.setFilter("*");
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            return element;
        }
        return null;
    }

    public String getNewClassName() {
        return this.fClassNameDialogField.getText();
    }

    public String getBaseClassName() {
        return this.fBaseClassDialogField.getText();
    }

    public boolean isIncludeGuard() {
        return this.fConstDestButtons.isSelected(2);
    }

    public boolean isVirtualDestructor() {
        return this.fConstDestButtons.isSelected(1);
    }

    public boolean isInline() {
        return this.fConstDestButtons.isSelected(0);
    }

    public String getAccess() {
        if (this.fAccessButtons.isSelected(0)) {
            return "public";
        }
        if (this.fAccessButtons.isSelected(1)) {
            return "protected";
        }
        if (this.fAccessButtons.isSelected(2)) {
            return "private";
        }
        return "";
    }

    public ITranslationUnit getCreatedClassHeaderFile() {
        return this.parentHeaderTU;
    }

    public ITranslationUnit getCreatedClassBodyFile() {
        return this.parentBodyTU;
    }

    public ICElement getCreatedClassElement() {
        return this.createdClass;
    }

    public IStructure getBaseClassElement() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean createClass(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(NewWizardMessages.getString("NewTypeWizardPage.operationdesc"), 10);
        try {
            try {
                IWorkingCopy iWorkingCopy;
                String lineDelimiter = null;
                lineDelimiter = System.getProperty("line.separator", "\n");
                this.parentHeaderTU = this.createTranslationUnit(this.linkedResourceGroupForHeader);
                this.parentBodyTU = this.createTranslationUnit(this.linkedResourceGroupForBody);
                monitor.worked(1);
                if (this.parentHeaderTU != null) {
                    String header = this.constructHeaderFileContent(lineDelimiter);
                    IWorkingCopy headerWC = this.parentHeaderTU.getSharedWorkingCopy(null, CUIPlugin.getDefault().getDocumentProvider().getBufferFactory());
                    headerWC.getBuffer().append(header);
                    iWorkingCopy = headerWC;
                    synchronized (iWorkingCopy) {
                        headerWC.reconcile();
                        headerWC.commit(true, monitor);
                    }
                    this.createdClass = headerWC.getElement(this.getNewClassName());
                }
                if (this.parentBodyTU != null) {
                    String body = this.constructBodyFileContent(lineDelimiter);
                    IWorkingCopy bodyWC = this.parentBodyTU.getSharedWorkingCopy(null, CUIPlugin.getDefault().getDocumentProvider().getBufferFactory());
                    bodyWC.getBuffer().append(body);
                    iWorkingCopy = bodyWC;
                    synchronized (iWorkingCopy) {
                        bodyWC.reconcile();
                        bodyWC.commit(true, monitor);
                    }
                }
                Object var6_7 = null;
            }
            catch (CModelException e) {
                MessageDialog.openError((Shell)this.getContainer().getShell(), (String)WorkbenchMessages.getString((String)"WizardNewFileCreationPage.internalErrorTitle"), (String)WorkbenchMessages.format((String)"WizardNewFileCreationPage.internalErrorMessage", (Object[])new Object[]{e.getMessage()}));
                Object var6_8 = null;
                monitor.done();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return true;
    }

    protected ITranslationUnit createTranslationUnit(LinkToFileGroup linkedGroup) {
        ICElement element;
        ITranslationUnit createdUnit = null;
        IFile createdFile = null;
        createdFile = this.createNewFile(linkedGroup);
        if (createdFile != null && (element = CoreModel.getDefault().create(createdFile)) instanceof ITranslationUnit) {
            createdUnit = (ITranslationUnit)element;
        }
        return createdUnit;
    }

    protected IFile createNewFile(LinkToFileGroup linkedGroup) {
        final IPath newFilePath = this.getContainerFullPath(linkedGroup);
        final IFile newFileHandle = this.createFileHandle(newFilePath);
        if (newFileHandle.exists()) {
            return newFileHandle;
        }
        final boolean linkedFile = linkedGroup.linkCreated();
        final IPath containerPath = this.getContainerPath(linkedGroup);
        final InputStream initialContents = this.getInitialContents();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                try {
                    monitor.beginTask(WorkbenchMessages.getString((String)"WizardNewFileCreationPage.progress"), 2000);
                    if (!NewClassWizardPage.this.containerExists(containerPath)) {
                        ContainerGenerator generator = new ContainerGenerator(containerPath);
                        generator.generateContainer((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                    }
                    NewClassWizardPage.this.createFile(newFileHandle, initialContents, newFilePath, linkedFile, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)WorkbenchMessages.getString((String)"WizardNewFileCreationPage.errorTitle"), null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                WorkbenchPlugin.log((String)MessageFormat.format("Exception in {0}.getNewFile(): {1}", ((Object)((Object)this)).getClass().getName(), e.getTargetException()));
                MessageDialog.openError((Shell)this.getContainer().getShell(), (String)WorkbenchMessages.getString((String)"WizardNewFileCreationPage.internalErrorTitle"), (String)WorkbenchMessages.format((String)"WizardNewFileCreationPage.internalErrorMessage", (Object[])new Object[]{e.getTargetException().getMessage()}));
            }
            return null;
        }
        return newFileHandle;
    }

    protected IFile createFileHandle(IPath filePath) {
        IFile newFile = null;
        IWorkspaceRoot root = CUIPlugin.getWorkspace().getRoot();
        newFile = root.getFileForLocation(filePath);
        if (newFile == null) {
            newFile = root.getFile(filePath);
        }
        return newFile;
    }

    protected void createFile(IFile fileHandle, InputStream contents, IPath targetPath, boolean linkedFile, IProgressMonitor monitor) throws CoreException {
        if (contents == null) {
            contents = new ByteArrayInputStream(new byte[0]);
        }
        try {
            fileHandle.create(contents, false, monitor);
        }
        catch (CoreException e) {
            e.getStatus().getCode();
            if (e.getStatus().getCode() == 374) {
                fileHandle.refreshLocal(0, null);
            }
            throw e;
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected IPath getSelectionPath() {
        if (this.eSelection == null) {
            IResource resourceSelection = this.getSelectionResourceElement(this.currentSelection);
            if (resourceSelection != null) {
                return resourceSelection.getLocation().makeAbsolute();
            }
            return null;
        }
        if (this.eSelection instanceof ITranslationUnit) {
            return this.eSelection.getParent().getPath();
        }
        if (this.eSelection instanceof IOpenable) {
            return this.eSelection.getPath();
        }
        ICElement current = this.eSelection.getParent();
        while (current != null) {
            if (current instanceof IOpenable && !(current instanceof ITranslationUnit)) {
                return current.getPath();
            }
            current = current.getParent();
        }
        return null;
    }

    protected IPath getContainerPath(LinkToFileGroup linkedGroup) {
        if (linkedGroup.linkCreated()) {
            String pathName = linkedGroup.getResolvedPath();
            if (pathName == null || pathName.length() < 1) {
                return null;
            }
            Path containerPath = new Path(pathName);
            return containerPath.removeLastSegments(1).removeTrailingSeparator().makeAbsolute();
        }
        return this.getSelectionPath();
    }

    protected IPath getContainerFullPath(LinkToFileGroup linkedGroup) {
        if (linkedGroup.linkCreated()) {
            String pathName = linkedGroup.getResolvedPath();
            if (pathName == null || pathName.length() < 1) {
                return null;
            }
            return new Path(pathName).makeAbsolute();
        }
        String pathName = linkedGroup.getText();
        IPath containerPath = this.getSelectionPath();
        containerPath.addTrailingSeparator();
        return containerPath.append(pathName).makeAbsolute();
    }

    protected boolean containerExists(IPath containerPath) {
        IContainer container = null;
        IWorkspaceRoot root = CUIPlugin.getWorkspace().getRoot();
        container = root.getContainerForLocation(containerPath);
        return container != null;
    }

    protected InputStream getInitialContents() {
        return null;
    }

    protected String getClassComment(ITranslationUnit parentTU) {
        if (PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.cdt.ui.javadoc")) {
            try {
                StringBuffer className = new StringBuffer();
                className.append(this.getNewClassName());
                String comment = CodeGeneration.getClassComment(parentTU, className.toString(), String.valueOf('\n'));
                if (comment != null && this.isValidComment(comment)) {
                    return comment;
                }
            }
            catch (CoreException e) {
                CUIPlugin.getDefault().log(e);
            }
        }
        return null;
    }

    protected String constructHeaderFileContent(String lineDelimiter) {
        StringBuffer text = new StringBuffer();
        boolean extendingBase = false;
        String baseClassName = this.getBaseClassName();
        String baseClassFileName = "";
        if (baseClassName != null && baseClassName.length() > 0) {
            extendingBase = true;
            List classElements = this.findClassElementsInProject();
            BasicSearchMatch cfr_ignored_0 = (BasicSearchMatch)this.findInList(baseClassName, null, classElements);
            baseClassFileName = String.valueOf(baseClassName) + ".h";
        }
        if (this.isIncludeGuard()) {
            text.append("#ifndef ");
            text.append(this.getNewClassName().toUpperCase());
            text.append("_H");
            text.append(lineDelimiter);
            text.append("#define ");
            text.append(this.getNewClassName().toUpperCase());
            text.append("_H");
            text.append(lineDelimiter);
            text.append(lineDelimiter);
        }
        if (extendingBase) {
            text.append("#include \"");
            text.append(baseClassFileName);
            text.append('\"');
            text.append(lineDelimiter);
            text.append(lineDelimiter);
        }
        text.append("class ");
        text.append(this.getNewClassName());
        if (extendingBase) {
            text.append(" : ");
            text.append(this.getAccess());
            text.append(" ");
            text.append(baseClassName);
        }
        text.append("{");
        text.append(lineDelimiter);
        text.append("public:");
        text.append(lineDelimiter);
        text.append(lineDelimiter);
        text.append('\t');
        text.append(this.getNewClassName());
        text.append("()");
        if (this.isInline()) {
            text.append(" {}");
            text.append(lineDelimiter);
        } else {
            text.append(";");
            text.append(lineDelimiter);
        }
        text.append('\t');
        if (this.isVirtualDestructor()) {
            text.append("virtual ");
        }
        text.append("~");
        text.append(this.getNewClassName());
        text.append("()");
        if (this.isInline()) {
            text.append(" {}");
            text.append(lineDelimiter);
        } else {
            text.append(";");
            text.append(lineDelimiter);
        }
        text.append("};");
        text.append(lineDelimiter);
        if (this.isIncludeGuard()) {
            text.append(lineDelimiter);
            text.append("#endif // ");
            text.append(this.getNewClassName().toUpperCase());
            text.append("_H");
            text.append(lineDelimiter);
        }
        return text.toString();
    }

    protected String constructBodyFileContent(String lineDelimiter) {
        StringBuffer text = new StringBuffer();
        text.append("#include \"");
        text.append(this.getCreatedClassHeaderFile().getElementName());
        text.append("\"");
        text.append(lineDelimiter);
        text.append(lineDelimiter);
        if (this.isInline()) {
            return text.toString();
        }
        text.append(this.getNewClassName());
        text.append("::");
        text.append(this.getNewClassName());
        text.append("()");
        text.append(lineDelimiter);
        text.append("{}");
        text.append(lineDelimiter);
        text.append(this.getNewClassName());
        text.append("::~");
        text.append(this.getNewClassName());
        text.append("()");
        text.append(lineDelimiter);
        text.append("{}");
        text.append(lineDelimiter);
        return text.toString();
    }

    protected void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fClassNameStatus, this.fBaseClassStatus};
        this.updateStatus(status);
    }

    protected void updateStatus(IStatus[] status) {
        this.updateStatus(StatusUtil.getMostSevere(status));
    }

    protected void updateStatus(IStatus status) {
        this.fCurrStatus = status;
        this.setPageComplete(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }

    protected boolean isValidComment(String template) {
        return true;
    }

    protected IStatus classNameChanged() {
        StatusInfo status = new StatusInfo();
        String className = this.getNewClassName();
        if (className.length() == 0) {
            status.setError(NewWizardMessages.getString("NewClassWizardPage.error.EnterClassName"));
            return status;
        }
        if (className.indexOf("::") != -1) {
            status.setError(NewWizardMessages.getString("NewClassWizardPage.error.QualifiedName"));
            return status;
        }
        IStatus val = CConventions.validateClassName((String)className);
        if (val.getSeverity() == 4) {
            status.setError(NewWizardMessages.getFormattedString("NewClassWizardPage.error.InvalidClassName", val.getMessage()));
            return status;
        }
        if (val.getSeverity() == 2) {
            status.setWarning(NewWizardMessages.getFormattedString("NewClassWizardPage.warning.ClassNameDiscouraged", val.getMessage()));
        }
        List elementsFound = this.findClassElementsInProject();
        if (this.foundInList(this.getNewClassName(), this.getContainerPath(this.linkedResourceGroupForHeader), elementsFound)) {
            status.setWarning(NewWizardMessages.getString("NewClassWizardPage.error.ClassNameExists"));
        }
        return status;
    }

    protected IStatus baseClassNameChanged() {
        String baseClassName = this.getBaseClassName();
        StatusInfo status = new StatusInfo();
        if (baseClassName.length() == 0) {
            return status;
        }
        IStatus val = CConventions.validateClassName((String)baseClassName);
        if (val.getSeverity() == 4) {
            status.setError(NewWizardMessages.getString("NewClassWizardPage.error.InvalidBaseClassName"));
            return status;
        }
        List elementsFound = this.findClassElementsInProject();
        if (!this.foundInList(baseClassName, null, elementsFound)) {
            status.setWarning(NewWizardMessages.getString("NewClassWizardPage.warning.BaseClassNotExists"));
        }
        return status;
    }

    private Object findInList(String name, IPath path, List elements) {
        Iterator i = elements.iterator();
        while (i.hasNext()) {
            BasicSearchMatch element = (BasicSearchMatch)i.next();
            if (!(path != null ? name.equals(element.getName()) && path.makeAbsolute().equals((Object)element.getLocation()) : name.equals(element.getName()))) continue;
            return element;
        }
        return null;
    }

    private boolean foundInList(String name, IPath path, List elements) {
        return this.findInList(name, path, elements) != null;
    }

    private class TypeFieldsAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener,
    IListAdapter {
        TypeFieldsAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            NewClassWizardPage.this.classPageChangeControlPressed(field);
        }

        public void customButtonPressed(ListDialogField field, int index) {
            NewClassWizardPage.this.classPageCustomButtonPressed(field, index);
        }

        public void selectionChanged(ListDialogField field) {
        }

        public void dialogFieldChanged(DialogField field) {
            NewClassWizardPage.this.classPageDialogFieldChanged(field);
        }

        public void doubleClicked(ListDialogField field) {
        }
    }
}

