/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIPlugin;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildToolSettingsPage;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildToolsSettingsStore;
import org.eclipse.cdt.managedbuilder.ui.properties.ManageConfigDialog;
import org.eclipse.cdt.managedbuilder.ui.properties.ToolListContentProvider;
import org.eclipse.cdt.managedbuilder.ui.properties.ToolListLabelProvider;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class BuildPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage,
IPreferencePageContainer {
    private static final String PREFIX = "BuildPropertyPage";
    private static final String LABEL = "BuildPropertyPage.label";
    private static final String NAME_LABEL = "BuildPropertyPage.label.NameText";
    private static final String BUILD_TOOLS_LABEL = "BuildPropertyPage.label.BuildToolTree";
    private static final String PLATFORM_LABEL = "BuildPropertyPage.label.Platform";
    private static final String CONFIG_LABEL = "BuildPropertyPage.label.Configuration";
    private static final String ACTIVE_LABEL = "BuildPropertyPage.label.Active";
    private static final String SETTINGS_LABEL = "BuildPropertyPage.label.Settings";
    private static final String TREE_LABEL = "BuildPropertyPage.label.ToolTree";
    private static final String OPTIONS_LABEL = "BuildPropertyPage.label.ToolOptions";
    private static final String ADD_CONF = "BuildPropertyPage.label.AddConfButton";
    private static final String TIP = "BuildPropertyPage.tip";
    private static final String PLAT_TIP = "BuildPropertyPage.tip.platform";
    private static final String CONF_TIP = "BuildPropertyPage.tip.config";
    private static final String ADD_TIP = "BuildPropertyPage.tip.addconf";
    private static final String MANAGE_TITLE = "BuildPropertyPage.manage.title";
    private static final int[] DEFAULT_SASH_WEIGHTS = new int[]{20, 30};
    private Combo targetSelector;
    private Combo configSelector;
    private Button manageConfigs;
    private TreeViewer optionList;
    private SashForm sashForm;
    private Group sashGroup;
    private Composite settingsPageContainer;
    private ScrolledComposite containerSC;
    private ITarget[] targets;
    private ITarget selectedTarget;
    private IConfiguration[] configurations;
    private IConfiguration selectedConfiguration;
    private BuildToolSettingsPage currentSettingsPage;
    private Map configToPageListMap;
    private BuildToolsSettingsStore settingsStore;
    private IOptionCategory selectedCategory;
    private Point lastShellSize;
    private Point minimumPageSize = new Point(200, 200);

    public BuildPropertyPage() {
        this.configToPageListMap = new HashMap();
    }

    protected Control createContents(Composite parent) {
        this.targets = ManagedBuildManager.getTargets((IResource)this.getProject());
        Composite composite = ControlFactory.createComposite((Composite)parent, (int)1);
        Group configGroup = ControlFactory.createGroup((Composite)composite, (String)ManagedBuilderUIPlugin.getResourceString(ACTIVE_LABEL), (int)1);
        GridData gd = new GridData(256);
        gd.grabExcessHorizontalSpace = true;
        configGroup.setLayoutData((Object)gd);
        FormLayout form = new FormLayout();
        form.marginHeight = 5;
        form.marginWidth = 5;
        configGroup.setLayout((Layout)form);
        Label platformLabel = ControlFactory.createLabel((Composite)configGroup, (String)ManagedBuilderUIPlugin.getResourceString(PLATFORM_LABEL));
        this.targetSelector = ControlFactory.createSelectCombo((Composite)configGroup, (String[])this.getPlatformNames(), null);
        this.targetSelector.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                BuildPropertyPage.this.handleTargetSelection();
            }
        });
        this.targetSelector.setToolTipText(ManagedBuilderUIPlugin.getResourceString(PLAT_TIP));
        Label configLabel = ControlFactory.createLabel((Composite)configGroup, (String)ManagedBuilderUIPlugin.getResourceString(CONFIG_LABEL));
        this.configSelector = new Combo((Composite)configGroup, 12);
        this.configSelector.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                BuildPropertyPage.this.handleConfigSelection();
            }
        });
        this.configSelector.setToolTipText(ManagedBuilderUIPlugin.getResourceString(CONF_TIP));
        this.manageConfigs = ControlFactory.createPushButton((Composite)configGroup, (String)ManagedBuilderUIPlugin.getResourceString(ADD_CONF));
        this.manageConfigs.setToolTipText(ManagedBuilderUIPlugin.getResourceString(ADD_TIP));
        this.manageConfigs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildPropertyPage.this.handleManageConfig();
            }
        });
        FormData fd = new FormData();
        fd.top = new FormAttachment((Control)this.targetSelector, 0, 0x1000000);
        platformLabel.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.configSelector, 0, 0x1000000);
        configLabel.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.configSelector, 0, 16384);
        fd.right = new FormAttachment(100, 0);
        this.targetSelector.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.configSelector, 0, 0x1000000);
        fd.right = new FormAttachment(100, 0);
        this.manageConfigs.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment((Control)configLabel, 5);
        fd.top = new FormAttachment(55, 0);
        fd.right = new FormAttachment((Control)this.manageConfigs, -5, 16384);
        this.configSelector.setLayoutData((Object)fd);
        this.sashGroup = ControlFactory.createGroup((Composite)composite, (String)ManagedBuilderUIPlugin.getResourceString(SETTINGS_LABEL), (int)1);
        this.sashGroup.setLayoutData((Object)new GridData(1808));
        this.sashForm = new SashForm((Composite)this.sashGroup, 0);
        this.sashForm.setOrientation(256);
        this.sashForm.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        this.sashForm.setLayout((Layout)layout);
        this.createSelectionArea((Composite)this.sashForm);
        this.createEditArea((Composite)this.sashForm);
        this.initializeSashForm();
        this.handleTargetSelection();
        return composite;
    }

    protected void createEditArea(Composite parent) {
        this.containerSC = new ScrolledComposite(parent, 768);
        this.containerSC.setExpandHorizontal(true);
        this.containerSC.setExpandVertical(true);
        this.settingsPageContainer = new Composite((Composite)this.containerSC, 0);
        this.settingsPageContainer.setLayout((Layout)new PageLayout());
        this.containerSC.setContent((Control)this.settingsPageContainer);
        this.containerSC.setMinSize(this.settingsPageContainer.computeSize(-1, -1));
        this.settingsPageContainer.layout();
    }

    protected void createSelectionArea(Composite parent) {
        Composite composite = ControlFactory.createComposite((Composite)parent, (int)1);
        this.optionList = new TreeViewer(composite, 2820);
        this.optionList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BuildPropertyPage.this.handleOptionSelection();
            }
        });
        this.optionList.getControl().setLayoutData((Object)new GridData(1808));
        this.optionList.setLabelProvider((IBaseLabelProvider)new ToolListLabelProvider());
    }

    private void displayOptionsForCategory(IOptionCategory category) {
        if (category == this.selectedCategory) {
            return;
        }
        this.selectedCategory = category;
        BuildToolSettingsPage oldPage = this.currentSettingsPage;
        this.currentSettingsPage = null;
        List pages = this.getPagesForConfig();
        ListIterator iter = pages.listIterator();
        while (iter.hasNext()) {
            BuildToolSettingsPage page = (BuildToolSettingsPage)((Object)iter.next());
            if (!page.getCategory().equals(category)) continue;
            this.currentSettingsPage = page;
            break;
        }
        if (this.currentSettingsPage == null) {
            this.currentSettingsPage = new BuildToolSettingsPage(this.selectedConfiguration, category);
            pages.add(this.currentSettingsPage);
            this.currentSettingsPage.setContainer(this);
            if (this.currentSettingsPage.getControl() == null) {
                this.currentSettingsPage.createControl(this.settingsPageContainer);
            }
        }
        Control[] children = this.settingsPageContainer.getChildren();
        Control currentControl = this.currentSettingsPage.getControl();
        int i = 0;
        while (i < children.length) {
            if (children[i] != currentControl) {
                children[i].setVisible(false);
            }
            ++i;
        }
        this.currentSettingsPage.setVisible(true);
        if (oldPage != null) {
            oldPage.setVisible(false);
        }
        this.containerSC.setMinSize(this.currentSettingsPage.computeSize());
        this.settingsPageContainer.layout();
    }

    private String[] getConfigurationNames() {
        String[] names = new String[this.configurations.length];
        int index = 0;
        while (index < this.configurations.length) {
            names[index] = this.configurations[index].getName();
            ++index;
        }
        return names;
    }

    protected Point getLastShellSize() {
        Shell shell;
        if (this.lastShellSize == null && (shell = this.getShell()) != null) {
            this.lastShellSize = shell.getSize();
        }
        return this.lastShellSize;
    }

    private List getPagesForConfig() {
        ArrayList pages = (ArrayList)this.configToPageListMap.get(this.selectedConfiguration.getId());
        if (pages == null) {
            pages = new ArrayList();
            this.configToPageListMap.put(this.selectedConfiguration.getId(), pages);
        }
        return pages;
    }

    private String[] getPlatformNames() {
        String[] names = new String[this.targets.length];
        int index = 0;
        while (index < this.targets.length) {
            names[index] = this.targets[index].getName();
            ++index;
        }
        return names;
    }

    public IPreferenceStore getPreferenceStore() {
        return this.settingsStore;
    }

    private IProject getProject() {
        IAdaptable element = this.getElement();
        if (element != null && element instanceof IProject) {
            return (IProject)element;
        }
        return null;
    }

    public IConfiguration getSelectedConfiguration() {
        return this.selectedConfiguration;
    }

    private void handleConfigSelection() {
        ITool tool;
        IOptionCategory top;
        IOption[] topOpts;
        Object primary;
        if (this.configSelector.getItemCount() == 0) {
            return;
        }
        this.selectedConfiguration = this.configurations[this.configSelector.getSelectionIndex()];
        ToolListContentProvider provider = new ToolListContentProvider();
        this.optionList.setContentProvider((IContentProvider)provider);
        this.optionList.setInput((Object)this.selectedConfiguration);
        this.optionList.expandAll();
        this.settingsStore = new BuildToolsSettingsStore(this.selectedConfiguration);
        Object[] elements = provider.getElements(this.selectedConfiguration);
        Object object = primary = elements.length > 0 ? elements[0] : null;
        if (primary != null && primary instanceof ITool && (topOpts = (top = (tool = (ITool)primary).getTopOptionCategory()).getOptions(this.selectedConfiguration)) != null && topOpts.length == 0) {
            IOptionCategory[] children = top.getChildCategories();
            int i = 0;
            while (i < children.length) {
                IOptionCategory category = children[i];
                IOption[] catOpts = category.getOptions(this.selectedConfiguration);
                if (catOpts != null && catOpts.length > 0) {
                    primary = category;
                    break;
                }
                ++i;
            }
        }
        if (primary != null) {
            this.optionList.setSelection((ISelection)new StructuredSelection(primary));
        }
    }

    private void handleManageConfig() {
        ManageConfigDialog manageDialog = new ManageConfigDialog(this.getShell(), ManagedBuilderUIPlugin.getResourceString(MANAGE_TITLE), this.selectedTarget);
        if (manageDialog.open() == 0) {
            boolean updateConfigs = false;
            String newBuildOutput = manageDialog.getBuildArtifactName();
            if (!this.selectedTarget.getArtifactName().equals(newBuildOutput)) {
                this.selectedTarget.setBuildArtifact(newBuildOutput);
            }
            if (manageDialog.useDefaultMakeCommand()) {
                this.selectedTarget.resetMakeCommand();
            } else {
                String makeCommand = manageDialog.getMakeCommand();
                this.selectedTarget.setMakeCommand(makeCommand);
            }
            ArrayList deletedConfigs = manageDialog.getDeletedConfigIds();
            ListIterator iter = deletedConfigs.listIterator();
            while (iter.hasNext()) {
                String id = (String)iter.next();
                this.selectedTarget.removeConfiguration(id);
                this.configurations = this.selectedTarget.getConfigurations();
                this.configSelector.removeAll();
                this.configSelector.setItems(this.getConfigurationNames());
                this.configSelector.select(0);
                updateConfigs = true;
            }
            SortedMap newConfigs = manageDialog.getNewConfigs();
            Set keys = newConfigs.keySet();
            Iterator keyIter = keys.iterator();
            Random r = new Random();
            r.setSeed(System.currentTimeMillis());
            while (keyIter.hasNext()) {
                String name = (String)keyIter.next();
                IConfiguration parent = (IConfiguration)newConfigs.get(name);
                if (parent == null) continue;
                int id = r.nextInt();
                if (id < 0) {
                    id *= -1;
                }
                String newId = String.valueOf(parent.getId()) + "." + id;
                IConfiguration newConfig = this.selectedTarget.createConfiguration(parent, newId);
                newConfig.setName(name);
                this.configurations = this.selectedTarget.getConfigurations();
                this.configSelector.removeAll();
                this.configSelector.setItems(this.getConfigurationNames());
                this.configSelector.select(this.configSelector.indexOf(name));
                updateConfigs = true;
            }
            if (updateConfigs) {
                this.handleConfigSelection();
            }
        }
    }

    private void handleOptionSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.optionList.getSelection();
        Object element = selection.getFirstElement();
        if (element instanceof IOptionCategory) {
            this.displayOptionsForCategory((IOptionCategory)element);
        }
    }

    private void handleTargetSelection() {
        if (this.targetSelector.getItemCount() == 0) {
            this.manageConfigs.setEnabled(false);
            return;
        }
        this.manageConfigs.setEnabled(true);
        this.selectedTarget = this.targets[this.targetSelector.getSelectionIndex()];
        this.populateConfigurations();
    }

    protected void initializeSashForm() {
        this.sashForm.setWeights(DEFAULT_SASH_WEIGHTS);
    }

    protected void performDefaults() {
        List pages = this.getPagesForConfig();
        pages.clear();
        ManagedBuildManager.resetConfiguration((IProject)this.getProject(), (IConfiguration)this.getSelectedConfiguration());
        this.settingsStore = new BuildToolsSettingsStore(this.getSelectedConfiguration());
        this.selectedCategory = null;
        this.handleOptionSelection();
    }

    public boolean performOk() {
        List pages = this.getPagesForConfig();
        ListIterator iter = pages.listIterator();
        while (iter.hasNext()) {
            BuildToolSettingsPage page = (BuildToolSettingsPage)((Object)iter.next());
            page.performOk();
        }
        ManagedBuildManager.setDefaultConfiguration((IProject)this.getProject(), (IConfiguration)this.getSelectedConfiguration());
        ManagedBuildManager.saveBuildInfo((IProject)this.getProject());
        return true;
    }

    private void populateConfigurations() {
        if (this.configSelector == null) {
            return;
        }
        this.configurations = this.selectedTarget.getConfigurations();
        this.configSelector.removeAll();
        this.configSelector.setItems(this.getConfigurationNames());
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)this.getProject());
        IConfiguration defaultConfig = info.getDefaultConfiguration(this.selectedTarget);
        int index = this.configSelector.indexOf(defaultConfig.getName());
        this.configSelector.select(index == -1 ? 0 : index);
        this.handleConfigSelection();
    }

    public void updateButtons() {
    }

    public void updateMessage() {
    }

    public void updateTitle() {
    }

    private class PageLayout
    extends Layout {
        PageLayout() {
        }

        public void layout(Composite composite, boolean force) {
            Rectangle rect = composite.getClientArea();
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].setSize(rect.width, rect.height);
                ++i;
            }
        }

        public Point computeSize(Composite composite, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            int x = ((BuildPropertyPage)BuildPropertyPage.this).minimumPageSize.x;
            int y = ((BuildPropertyPage)BuildPropertyPage.this).minimumPageSize.y;
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                Point size = children[i].computeSize(-1, -1, force);
                x = Math.max(x, size.x);
                y = Math.max(y, size.y);
                ++i;
            }
            if (wHint != -1) {
                x = wHint;
            }
            if (hHint != -1) {
                y = hHint;
            }
            return new Point(x, y);
        }
    }
}

