/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.model.BufferChangedEvent;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.IBufferChangedListener;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IOpenable;
import org.eclipse.cdt.internal.core.model.BufferManager;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.IBufferFactory;
import org.eclipse.cdt.internal.core.model.OpenableInfo;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class Openable
extends Parent
implements IOpenable,
IBufferChangedListener {
    protected IResource resource;

    public Openable(ICElement parent, IPath path, int type) {
        this(parent, (IResource)ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path), path.lastSegment(), type);
    }

    public Openable(ICElement parent, IResource resource, int type) {
        this(parent, resource, resource.getName(), type);
    }

    public Openable(ICElement parent, IResource res, String name, int type) {
        super(parent, name, type);
        this.resource = res;
    }

    public IResource getResource() {
        return this.resource;
    }

    public void bufferChanged(BufferChangedEvent event) {
        if (event.getBuffer().isClosed()) {
            CModelManager.getDefault().getElementsOutOfSynchWithBuffers().remove(this);
            this.getBufferManager().removeBuffer(event.getBuffer());
        } else {
            CModelManager.getDefault().getElementsOutOfSynchWithBuffers().put(this, this);
        }
    }

    protected void buildStructure(OpenableInfo info, IProgressMonitor monitor) throws CModelException {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        this.removeInfo();
        HashMap newElements = new HashMap(11);
        info.setIsStructureKnown(this.generateInfos(info, monitor, newElements, this.getResource()));
        CModelManager.getDefault().getElementsOutOfSynchWithBuffers().remove(this);
        Iterator iter = newElements.keySet().iterator();
        while (iter.hasNext()) {
            ICElement key = (ICElement)iter.next();
            Object value = newElements.get(key);
            CModelManager.getDefault().putInfo(key, value);
        }
        CModelManager.getDefault().putInfo(this, info);
    }

    protected void closeBuffer(OpenableInfo info) {
        if (!this.hasBuffer()) {
            return;
        }
        IBuffer buffer = null;
        buffer = this.getBufferManager().getBuffer(this);
        if (buffer != null) {
            buffer.close();
            buffer.removeBufferChangedListener(this);
        }
    }

    protected abstract boolean generateInfos(OpenableInfo var1, IProgressMonitor var2, Map var3, IResource var4) throws CModelException;

    public IBuffer getBuffer() throws CModelException {
        if (this.hasBuffer()) {
            IBuffer buffer;
            if (!this.isOpen()) {
                this.getElementInfo();
            }
            if ((buffer = this.getBufferManager().getBuffer(this)) == null) {
                buffer = this.openBuffer(null);
            }
            return buffer;
        }
        return null;
    }

    public IBufferFactory getBufferFactory() {
        return this.getBufferManager().getDefaultBufferFactory();
    }

    protected BufferManager getBufferManager() {
        return BufferManager.getDefaultBufferManager();
    }

    protected boolean hasBuffer() {
        return false;
    }

    public boolean hasUnsavedChanges() throws CModelException {
        if (this.isReadOnly() || !this.isOpen()) {
            return false;
        }
        IBuffer buf = this.getBuffer();
        if (buf != null && buf.hasUnsavedChanges()) {
            return true;
        }
        if (this.fType == 10 || this.fType == 11) {
            Enumeration openBuffers = this.getBufferManager().getOpenBuffers();
            while (openBuffers.hasMoreElements()) {
                ICElement owner;
                IBuffer buffer = (IBuffer)openBuffers.nextElement();
                if (!buffer.hasUnsavedChanges() || !this.isAncestorOf(owner = (ICElement)((Object)buffer.getOwner()))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isConsistent() throws CModelException {
        return true;
    }

    public boolean isOpen() {
        CModelManager cModelManager = CModelManager.getDefault();
        synchronized (cModelManager) {
            return CModelManager.getDefault().getInfo(this) != null;
        }
    }

    protected boolean isSourceElement() {
        return false;
    }

    public void makeConsistent(IProgressMonitor pm) throws CModelException {
        this.makeConsistent(pm, false);
    }

    public void makeConsistent(IProgressMonitor pm, boolean forced) throws CModelException {
        if (!this.isConsistent() || forced) {
            this.buildStructure((OpenableInfo)this.getElementInfo(), pm);
        }
    }

    public void open(IProgressMonitor pm) throws CModelException {
        if (!this.isOpen()) {
            this.openWhenClosed(pm);
        }
    }

    protected IBuffer openBuffer(IProgressMonitor pm) throws CModelException {
        return null;
    }

    protected void openParent(IProgressMonitor pm) throws CModelException {
        Openable openableParent = (Openable)this.getOpenableParent();
        if (openableParent != null && !openableParent.isOpen()) {
            openableParent.openWhenClosed(pm);
        }
    }

    protected void openWhenClosed(IProgressMonitor pm) throws CModelException {
        try {
            this.openParent(pm);
            OpenableInfo info = (OpenableInfo)this.createElementInfo();
            IResource resource = this.getResource();
            if (resource != null && this.isSourceElement()) {
                this.openBuffer(pm);
            }
            this.buildStructure(info, pm);
        }
        catch (CModelException e) {
            CModelManager.getDefault().removeInfo(this);
            throw e;
        }
    }

    public void save(IProgressMonitor pm, boolean force) throws CModelException {
        if (this.isReadOnly() || this.getResource().isReadOnly()) {
            throw new CModelException(new CModelStatus(976, this));
        }
        IBuffer buf = this.getBuffer();
        if (buf != null) {
            buf.save(pm, force);
            this.makeConsistent(pm);
        }
    }
}

