/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.elf.parser;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.Addr2line;
import org.eclipse.cdt.utils.CPPFilt;
import org.eclipse.cdt.utils.IToolsProvider;
import org.eclipse.cdt.utils.elf.Elf;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PlatformObject;

public abstract class BinaryFile
extends PlatformObject
implements IBinaryParser.IBinaryFile {
    protected IPath path;
    protected IToolsProvider toolsProvider;
    protected long timestamp;

    public BinaryFile(IPath p) {
        this.path = p;
    }

    public void setToolsProvider(IToolsProvider p) {
        this.toolsProvider = p;
    }

    public Addr2line getAddr2Line() {
        if (this.toolsProvider != null) {
            return this.toolsProvider.getAddr2Line(this.path);
        }
        return null;
    }

    public CPPFilt getCPPFilt() {
        if (this.toolsProvider != null) {
            return this.toolsProvider.getCPPFilt();
        }
        return null;
    }

    public IPath getPath() {
        return this.path;
    }

    public abstract int getType();

    public InputStream getContents() {
        InputStream stream = null;
        if (this.path != null) {
            try {
                stream = new FileInputStream(this.path.toFile());
            }
            catch (IOException iOException) {}
        }
        if (stream == null) {
            stream = new ByteArrayInputStream(new byte[0]);
        }
        return stream;
    }

    protected abstract Elf.Attribute getAttribute();

    protected boolean hasChanged() {
        long modification = this.getPath().toFile().lastModified();
        boolean changed = modification != this.timestamp;
        this.timestamp = modification;
        return changed;
    }
}

