/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.elf.parser;

import java.io.IOException;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.utils.Addr2line;
import org.eclipse.cdt.utils.CPPFilt;
import org.eclipse.cdt.utils.IToolsProvider;
import org.eclipse.cdt.utils.elf.parser.BinaryFile;
import org.eclipse.cdt.utils.elf.parser.ElfParser;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class GNUElfParser
extends ElfParser
implements IBinaryParser,
IToolsProvider {
    public IBinaryParser.IBinaryFile getBinary(IPath path) throws IOException {
        IBinaryParser.IBinaryFile binary = super.getBinary(path);
        if (binary instanceof BinaryFile) {
            ((BinaryFile)binary).setToolsProvider(this);
        }
        return binary;
    }

    public String getFormat() {
        return "GNU ELF";
    }

    public IPath getAddr2LinePath() {
        ICExtensionReference ref = this.getExtensionReference();
        String value = ref.getExtensionData("addr2line");
        if (value == null || value.length() == 0) {
            value = "addr2line";
        }
        return new Path(value);
    }

    public IPath getCPPFiltPath() {
        ICExtensionReference ref = this.getExtensionReference();
        String value = ref.getExtensionData("c++filt");
        if (value == null || value.length() == 0) {
            value = "c++filt";
        }
        return new Path(value);
    }

    public Addr2line getAddr2Line(IPath path) {
        IPath addr2LinePath = this.getAddr2LinePath();
        Addr2line addr2line = null;
        if (addr2LinePath != null && !addr2LinePath.isEmpty()) {
            try {
                addr2line = new Addr2line(addr2LinePath.toOSString(), path.toOSString());
            }
            catch (IOException iOException) {}
        }
        return addr2line;
    }

    public CPPFilt getCPPFilt() {
        IPath cppFiltPath = this.getCPPFiltPath();
        CPPFilt cppfilt = null;
        if (cppFiltPath != null && !cppFiltPath.isEmpty()) {
            try {
                cppfilt = new CPPFilt(cppFiltPath.toOSString());
            }
            catch (IOException iOException) {}
        }
        return cppfilt;
    }
}

