/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.breakpoints;

import java.util.Map;
import org.eclipse.cdt.debug.core.CDebugModel;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.debug.core.model.IBreakpoint;

public abstract class CBreakpoint
extends Breakpoint
implements ICBreakpoint,
IDebugEventSetListener {
    public CBreakpoint() {
    }

    public CBreakpoint(final IResource resource, final String markerType, final Map attributes, final boolean add) throws DebugException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                CBreakpoint.this.setMarker(resource.createMarker(markerType));
                CBreakpoint.this.ensureMarker().setAttributes(attributes);
                CBreakpoint.this.setAttribute("message", CBreakpoint.this.getMarkerMessage());
                CBreakpoint.this.register(add);
            }
        };
        this.run(wr);
    }

    public void createMarker(final IResource resource, final String markerType, final Map attributes, final boolean add) throws DebugException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                CBreakpoint.this.setMarker(resource.createMarker(markerType));
                CBreakpoint.this.ensureMarker().setAttributes(attributes);
                CBreakpoint.this.setAttribute("message", CBreakpoint.this.getMarkerMessage());
                CBreakpoint.this.register(add);
            }
        };
        this.run(wr);
    }

    public String getModelIdentifier() {
        return CDebugModel.getPluginIdentifier();
    }

    public boolean isInstalled() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.installCount", 0) > 0;
    }

    public String getCondition() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.condition", "");
    }

    public void setCondition(String condition) throws CoreException {
        this.setAttribute("org.eclipse.cdt.debug.core.condition", condition);
        this.setAttribute("message", this.getMarkerMessage());
    }

    public int getIgnoreCount() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.ignoreCount", 0);
    }

    public void setIgnoreCount(int ignoreCount) throws CoreException {
        this.setAttribute("org.eclipse.cdt.debug.core.ignoreCount", ignoreCount);
        this.setAttribute("message", this.getMarkerMessage());
    }

    public String getThreadId() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.threadId", null);
    }

    public void setThreadId(String threadId) throws CoreException {
        this.setAttribute("org.eclipse.cdt.debug.core.threadId", threadId);
    }

    public void handleDebugEvents(DebugEvent[] events) {
    }

    protected void run(IWorkspaceRunnable wr) throws DebugException {
        try {
            ResourcesPlugin.getWorkspace().run(wr, null);
        }
        catch (CoreException e) {
            throw new DebugException(e.getStatus());
        }
    }

    public void register(boolean register) throws CoreException {
        if (register) {
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)this);
        }
    }

    protected String getMarkerMessage() throws CoreException {
        return null;
    }

    public synchronized void resetInstallCount() throws CoreException {
        this.setAttribute("org.eclipse.cdt.debug.core.installCount", 0);
    }

    public synchronized void incrementInstallCount() throws CoreException {
        int count = this.getInstallCount();
        this.setAttribute("org.eclipse.cdt.debug.core.installCount", count + 1);
    }

    public int getInstallCount() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.installCount", 0);
    }

    public synchronized void decrementInstallCount() throws CoreException {
        int count = this.getInstallCount();
        if (count > 0) {
            this.setAttribute("org.eclipse.cdt.debug.core.installCount", count - 1);
        }
    }

    protected IMarker ensureMarker() throws DebugException {
        return super.ensureMarker();
    }

    protected void setAttribute(String attributeName, Object value) throws CoreException {
        super.setAttribute(attributeName, value);
    }

    public boolean isConditional() throws CoreException {
        return this.getCondition() != null && this.getCondition().trim().length() > 0 || this.getIgnoreCount() > 0;
    }

    protected String getConditionText() throws CoreException {
        String condition;
        StringBuffer sb = new StringBuffer();
        int ignoreCount = this.getIgnoreCount();
        if (ignoreCount > 0) {
            sb.append(" [");
            sb.append("ignore count:");
            sb.append(' ');
            sb.append(ignoreCount);
            sb.append(']');
        }
        if ((condition = this.getCondition()) != null && condition.length() > 0) {
            sb.append(" if ");
            sb.append(condition);
        }
        return sb.toString();
    }
}

