/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.breakpoints;

import java.util.Map;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CBreakpoint;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;

public class CLineBreakpoint
extends CBreakpoint
implements ICLineBreakpoint {
    private static final String C_LINE_BREAKPOINT = "org.eclipse.cdt.debug.core.cLineBreakpointMarker";

    public CLineBreakpoint() {
    }

    public CLineBreakpoint(IResource resource, Map attributes, boolean add) throws DebugException {
        super(resource, CLineBreakpoint.getMarkerType(), attributes, add);
    }

    public int getLineNumber() throws CoreException {
        return this.ensureMarker().getAttribute("lineNumber", -1);
    }

    public int getCharStart() throws CoreException {
        return this.ensureMarker().getAttribute("charStart", -1);
    }

    public int getCharEnd() throws CoreException {
        return this.ensureMarker().getAttribute("charEnd", -1);
    }

    public static String getMarkerType() {
        return C_LINE_BREAKPOINT;
    }

    protected String getMarkerMessage() throws CoreException {
        int lineNumber;
        StringBuffer sb = new StringBuffer("Line breakpoint:");
        String fileName = this.ensureMarker().getResource().getName();
        if (fileName != null && fileName.length() > 0) {
            sb.append(' ');
            sb.append(fileName);
        }
        if ((lineNumber = this.getLineNumber()) > 0) {
            sb.append(" [");
            sb.append("line:");
            sb.append(' ');
            sb.append(lineNumber);
            sb.append(']');
        }
        sb.append(this.getConditionText());
        return sb.toString();
    }
}

