/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.model.ICExpressionEvaluator;
import org.eclipse.cdt.debug.core.model.ICValue;
import org.eclipse.cdt.debug.internal.core.model.CArrayPartition;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CVariable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IVariable;

public class CArrayPartitionValue
extends CDebugElement
implements ICValue {
    private ICDIVariable fCDIVariable;
    private CVariable fParent = null;
    private List fVariables = Collections.EMPTY_LIST;
    private int fStart;
    private int fEnd;
    static /* synthetic */ Class class$0;

    public CArrayPartitionValue(CVariable parent, ICDIVariable cdiVariable, int start, int end) {
        super((CDebugTarget)parent.getDebugTarget());
        this.fCDIVariable = cdiVariable;
        this.fParent = parent;
        this.fStart = start;
        this.fEnd = end;
    }

    public String getReferenceTypeName() throws DebugException {
        return null;
    }

    public String getValueString() throws DebugException {
        return null;
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public IVariable[] getVariables() throws DebugException {
        List list = this.getVariables0();
        return list.toArray(new IVariable[list.size()]);
    }

    protected synchronized List getVariables0() throws DebugException {
        if (!this.isAllocated() || !this.hasVariables()) {
            return Collections.EMPTY_LIST;
        }
        if (this.fVariables.size() == 0) {
            this.fVariables = CArrayPartition.splitArray(this, this.getCDIVariable(), this.getStart(), this.getEnd());
        }
        return this.fVariables;
    }

    public boolean hasVariables() throws DebugException {
        return true;
    }

    protected int getStart() {
        return this.fStart;
    }

    protected int getEnd() {
        return this.fEnd;
    }

    public void setChanged(boolean changed) throws DebugException {
        Iterator it = this.fVariables.iterator();
        while (it.hasNext()) {
            ((CVariable)it.next()).setChanged(changed);
        }
    }

    public String evaluateAsExpression() {
        IDebugTarget iDebugTarget = this.getDebugTarget();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.cdt.debug.core.model.ICExpressionEvaluator;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICExpressionEvaluator ee = (ICExpressionEvaluator)iDebugTarget.getAdapter((Class)clazz);
        String valueString = null;
        if (ee != null && ee.canEvaluate()) {
            try {
                if (this.getParentVariable() != null) {
                    valueString = ee.evaluateExpressionToString(this.getParentVariable().getQualifiedName());
                }
            }
            catch (DebugException e) {
                valueString = e.getMessage();
            }
        }
        return valueString;
    }

    public CVariable getParentVariable() {
        return this.fParent;
    }

    protected ICDIVariable getCDIVariable() {
        return this.fCDIVariable;
    }

    public void dispose() {
        Iterator it = this.fVariables.iterator();
        while (it.hasNext()) {
            ((CVariable)it.next()).dispose();
        }
    }
}

