/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.search.BasicSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchPattern;
import org.eclipse.cdt.core.search.ICSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.IMatch;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.internal.core.search.matching.OrPattern;
import org.eclipse.cdt.internal.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CSearchResultLabelProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class OpenDeclarationsAction
extends Action {
    private String fDialogTitle;
    private String fDialogMessage;
    protected CEditor fEditor;
    BasicSearchResultCollector resultCollector = null;
    SearchEngine searchEngine = null;

    protected OpenDeclarationsAction() {
        this.setText(CEditorMessages.getString("OpenDeclarations.label"));
        this.setToolTipText(CEditorMessages.getString("OpenDeclarations.tooltip"));
        this.setDescription(CEditorMessages.getString("OpenDeclarations.description"));
        this.setDialogTitle(CEditorMessages.getString("OpenDeclarations.dialog.title"));
        this.setDialogMessage(CEditorMessages.getString("OpenDeclarations.dialog.message"));
        this.searchEngine = new SearchEngine();
        this.resultCollector = new BasicSearchResultCollector();
    }

    public OpenDeclarationsAction(ImageDescriptor image) {
        this();
        this.setImageDescriptor(image);
    }

    public OpenDeclarationsAction(CEditor editor) {
        this();
        this.fEditor = editor;
    }

    protected void setDialogTitle(String title) {
        this.fDialogTitle = title;
    }

    protected void setDialogMessage(String message) {
        this.fDialogMessage = message;
    }

    public void setContentEditor(CEditor editor) {
        this.fEditor = editor;
    }

    public void run() {
        IWorkingCopyManager fManager = CUIPlugin.getDefault().getWorkingCopyManager();
        ITranslationUnit unit = fManager.getWorkingCopy(this.fEditor.getEditorInput());
        if (this.fEditor.getSelectionProvider() != null) {
            ITextSelection selection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
            try {
                IMatch selected;
                IFile file;
                ArrayList elementsFound = new ArrayList();
                String sel = selection.getText();
                if (sel.equals("")) {
                    int selStart = selection.getOffset();
                    IDocumentProvider prov = this.fEditor.getDocumentProvider();
                    IDocument doc = prov.getDocument((Object)this.fEditor.getEditorInput());
                    sel = this.getSelection(doc, selStart);
                }
                if ((file = this.fEditor.getInputFile()) == null) {
                    return;
                }
                IProject project = file.getProject();
                if (project == null) {
                    return;
                }
                ICElement[] projectScopeElement = new ICElement[]{unit.getCProject()};
                ICSearchScope scope = SearchEngine.createCSearchScope((ICElement[])projectScopeElement, (boolean)true);
                OrPattern orPattern = new OrPattern();
                orPattern.addPattern(SearchEngine.createSearchPattern((String)sel, (ICSearchConstants.SearchFor)ICSearchConstants.VAR, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true));
                orPattern.addPattern(SearchEngine.createSearchPattern((String)sel, (ICSearchConstants.SearchFor)ICSearchConstants.FUNCTION, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true));
                orPattern.addPattern(SearchEngine.createSearchPattern((String)sel, (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true));
                orPattern.addPattern(SearchEngine.createSearchPattern((String)sel, (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true));
                orPattern.addPattern(SearchEngine.createSearchPattern((String)sel, (ICSearchConstants.SearchFor)ICSearchConstants.ENUM, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true));
                orPattern.addPattern(SearchEngine.createSearchPattern((String)sel, (ICSearchConstants.SearchFor)ICSearchConstants.FIELD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true));
                orPattern.addPattern(SearchEngine.createSearchPattern((String)sel, (ICSearchConstants.SearchFor)ICSearchConstants.NAMESPACE, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true));
                orPattern.addPattern(SearchEngine.createSearchPattern((String)sel, (ICSearchConstants.SearchFor)ICSearchConstants.MACRO, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true));
                orPattern.addPattern(SearchEngine.createSearchPattern((String)sel, (ICSearchConstants.SearchFor)ICSearchConstants.TYPEDEF, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true));
                this.searchEngine.search(CUIPlugin.getWorkspace(), (ICSearchPattern)orPattern, scope, (ICSearchResultCollector)this.resultCollector, true);
                elementsFound.addAll(this.resultCollector.getSearchResults());
                if (!elementsFound.isEmpty() && (selected = this.selectCElement(elementsFound, this.getShell(), this.fDialogTitle, this.fDialogMessage)) != null) {
                    this.open(selected);
                    return;
                }
            }
            catch (Exception x) {
                CUIPlugin.getDefault().log(x);
            }
        }
        this.getShell().getDisplay().beep();
    }

    protected Shell getShell() {
        return this.fEditor.getSite().getShell();
    }

    protected void open(IMatch element) throws CModelException, PartInitException {
        IEditorPart part = EditorUtility.openInEditor(element.getResource());
        if (part instanceof CEditor) {
            CEditor ed = (CEditor)part;
            try {
                ed.getDocumentProvider().getDocument((Object)ed.getEditorInput());
                ed.selectAndReveal(element.getStartOffset(), 0);
            }
            catch (Exception exception) {}
        }
    }

    protected IMatch selectCElement(List elements, Shell shell, String title, String message) {
        Object[] selection;
        int nResults = elements.size();
        if (nResults == 0) {
            return null;
        }
        if (nResults == 1) {
            return (IMatch)elements.get(0);
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new CSearchResultLabelProvider(), false, false);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setElements(elements);
        if (dialog.open() == 0 && (selection = dialog.getResult()) != null && selection.length > 0) {
            nResults = selection.length;
            int i = 0;
            while (i < nResults) {
                Object current = selection[i];
                if (current instanceof IMatch) {
                    return (IMatch)current;
                }
                ++i;
            }
        }
        return null;
    }

    public String getSelection(IDocument doc, int fPos) {
        int pos = fPos;
        int fStartPos = 0;
        int fEndPos = 0;
        String selectedWord = null;
        try {
            char c;
            while (pos >= 0) {
                c = doc.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                --pos;
            }
            fStartPos = pos + 1;
            pos = fPos;
            int length = doc.getLength();
            while (pos < length) {
                c = doc.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                ++pos;
            }
            fEndPos = pos;
            selectedWord = doc.get(fStartPos, fEndPos - fStartPos);
        }
        catch (BadLocationException badLocationException) {}
        return selectedWord;
    }
}

