/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import org.eclipse.cdt.internal.ui.text.ICCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class CCompletionProposal
implements ICCompletionProposal,
ICompletionProposalExtension {
    private String fDisplayString;
    private String fReplacementString;
    private String fAdditionalInfoString;
    private int fReplacementOffset;
    private int fReplacementLength;
    private int fCursorPosition;
    private Image fImage;
    private IContextInformation fContextInformation;
    private int fContextInformationPosition;
    private char[] fTriggerCharacters;
    private int fRelevance;

    public CCompletionProposal(String replacementString, int replacementOffset, int replacementLength, Image image, String displayString, int relevance) {
        Assert.isNotNull((Object)replacementString);
        Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        this.fReplacementString = replacementString;
        this.fReplacementOffset = replacementOffset;
        this.fReplacementLength = replacementLength;
        this.fImage = image;
        this.fDisplayString = displayString != null ? displayString : replacementString;
        this.fRelevance = relevance;
        this.fCursorPosition = replacementString.indexOf("()") == -1 ? replacementString.length() : (displayString.indexOf("()") == -1 ? replacementString.length() - 1 : replacementString.length());
        this.fAdditionalInfoString = null;
        this.fContextInformation = null;
        this.fContextInformationPosition = -1;
        this.fTriggerCharacters = null;
    }

    public void setContextInformation(IContextInformation contextInformation) {
        this.fContextInformation = contextInformation;
        this.fContextInformationPosition = this.fContextInformation != null ? this.fCursorPosition : -1;
    }

    public void setTriggerCharacters(char[] triggerCharacters) {
        this.fTriggerCharacters = triggerCharacters;
    }

    public void setCursorPosition(int cursorPosition) {
        Assert.isTrue((cursorPosition >= 0 ? 1 : 0) != 0);
        this.fCursorPosition = cursorPosition;
        this.fContextInformationPosition = this.fContextInformation != null ? this.fCursorPosition : -1;
    }

    protected void applyIncludes(IDocument document) {
    }

    public void apply(IDocument document) {
        this.apply(document, '\u0000', this.fReplacementOffset + this.fReplacementLength);
    }

    public void apply(IDocument document, char trigger, int offset) {
        String replacementStringCopy = this.fReplacementString;
        this.fReplacementLength = offset - this.fReplacementOffset;
        try {
            boolean isBeforeBracket;
            int functionBracketIndex = this.fReplacementString.indexOf("()");
            boolean bl = isBeforeBracket = document.getChar(this.fReplacementOffset + this.fReplacementLength) == '(';
            if (functionBracketIndex != -1 && isBeforeBracket) {
                replacementStringCopy = this.fReplacementString.substring(0, functionBracketIndex);
            }
        }
        catch (Exception exception) {}
        try {
            if (trigger == '\u0000') {
                this.replace(document, this.fReplacementOffset, this.fReplacementLength, replacementStringCopy);
            } else {
                StringBuffer buffer = new StringBuffer(replacementStringCopy);
                if (this.fCursorPosition > 0 && this.fCursorPosition <= buffer.length() && buffer.charAt(this.fCursorPosition - 1) != trigger) {
                    buffer.insert(this.fCursorPosition, trigger);
                    ++this.fCursorPosition;
                }
                this.replace(document, this.fReplacementOffset, this.fReplacementLength, buffer.toString());
            }
            int oldLen = document.getLength();
            this.applyIncludes(document);
            this.fReplacementOffset += document.getLength() - oldLen;
        }
        catch (BadLocationException badLocationException) {}
    }

    private void replace(IDocument document, int offset, int length, String string) throws BadLocationException {
        if (!document.get(offset, length).equals(string)) {
            document.replace(offset, length, string);
        }
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fReplacementOffset + this.fCursorPosition, 0);
    }

    public IContextInformation getContextInformation() {
        return this.fContextInformation;
    }

    public Image getImage() {
        return this.fImage;
    }

    public String getDisplayString() {
        return this.fDisplayString;
    }

    public void setAdditionalProposalInfo(String infoString) {
        this.fAdditionalInfoString = infoString;
    }

    public String getAdditionalProposalInfo() {
        return this.fAdditionalInfoString;
    }

    public char[] getTriggerCharacters() {
        return this.fTriggerCharacters;
    }

    public int getContextInformationPosition() {
        return this.fReplacementOffset + this.fContextInformationPosition;
    }

    public boolean isValidFor(IDocument document, int offset) {
        int replacementLength;
        if (offset < this.fReplacementOffset) {
            return false;
        }
        int n = replacementLength = this.fReplacementString == null ? 0 : this.fReplacementString.length();
        if (offset >= this.fReplacementOffset + replacementLength) {
            return false;
        }
        try {
            int length = offset - this.fReplacementOffset;
            String start = document.get(this.fReplacementOffset, length);
            return this.fReplacementString.substring(0, length).equalsIgnoreCase(start);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public int getReplacementOffset() {
        return this.fReplacementOffset;
    }

    public void setReplacementOffset(int replacementOffset) {
        Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
        this.fReplacementOffset = replacementOffset;
    }

    public int getReplacementLength() {
        return this.fReplacementLength;
    }

    public void setReplacementLength(int replacementLength) {
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        this.fReplacementLength = replacementLength;
    }

    public String getReplacementString() {
        return this.fReplacementString;
    }

    public void setReplacementString(String replacementString) {
        this.fReplacementString = replacementString;
    }

    public void setImage(Image image) {
        this.fImage = image;
    }

    public int getRelevance() {
        return this.fRelevance;
    }

    public void setRelevance(int relevance) {
        this.fRelevance = relevance;
    }
}

