/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.makefile.gnu;

import org.eclipse.cdt.make.core.makefile.gnu.IVariableDefinition;
import org.eclipse.cdt.make.internal.core.makefile.Directive;
import org.eclipse.cdt.make.internal.core.makefile.MacroDefinition;

public class VariableDefinition
extends MacroDefinition
implements IVariableDefinition {
    static final int TYPE_RECURSIVE_EXPAND = 0;
    static final int TYPE_SIMPLE_EXPAND = 58;
    static final int TYPE_CONDITIONAL = 63;
    static final int TYPE_APPEND = 43;
    int type;
    String varTarget;

    public VariableDefinition(Directive parent, String name, StringBuffer value) {
        this(parent, name, value, 0);
    }

    public VariableDefinition(Directive parent, String name, StringBuffer value, int type) {
        this(parent, "", name, value, type);
    }

    public VariableDefinition(Directive parent, String target, String name, StringBuffer value, int type) {
        super(parent, name, value);
        this.varTarget = target;
        this.type = type;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.isTargetSpecific()) {
            sb.append(this.getTarget()).append(": ");
        }
        if (this.isOverride()) {
            sb.append("override ");
        }
        if (this.isMultiLine()) {
            sb.append("define ");
            sb.append(this.getName()).append('\n');
            sb.append(this.getValue()).append('\n');
            sb.append("endef\n");
        } else {
            if (this.isExport()) {
                sb.append("export ");
            }
            sb.append(this.getName());
            if (this.isRecursivelyExpanded()) {
                sb.append(" = ");
            } else if (this.isSimplyExpanded()) {
                sb.append(" := ");
            } else if (this.isConditional()) {
                sb.append(" ?= ");
            } else if (this.isAppend()) {
                sb.append(" += ");
            }
            sb.append(this.getValue()).append('\n');
        }
        return sb.toString();
    }

    public boolean isRecursivelyExpanded() {
        return this.type == 0;
    }

    public boolean isSimplyExpanded() {
        return this.type == 58;
    }

    public boolean isConditional() {
        return this.type == 63;
    }

    public boolean isAppend() {
        return this.type == 43;
    }

    public boolean isTargetSpecific() {
        String t = this.getTarget();
        return t != null && t.length() > 0;
    }

    public boolean isExport() {
        return false;
    }

    public boolean isMultiLine() {
        return false;
    }

    public boolean isOverride() {
        return false;
    }

    public boolean isAutomatic() {
        return false;
    }

    public String getTarget() {
        return this.varTarget;
    }
}

