/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui;

import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.cdi.ICDIBreakpointHit;
import org.eclipse.cdt.debug.core.cdi.ICDIExitInfo;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.ICDISharedLibraryEvent;
import org.eclipse.cdt.debug.core.cdi.ICDISignalExitInfo;
import org.eclipse.cdt.debug.core.cdi.ICDISignalReceived;
import org.eclipse.cdt.debug.core.cdi.ICDIWatchpointScope;
import org.eclipse.cdt.debug.core.cdi.ICDIWatchpointTrigger;
import org.eclipse.cdt.debug.core.cdi.model.ICDISignal;
import org.eclipse.cdt.debug.core.model.ICAddressBreakpoint;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICDebugElementErrorStatus;
import org.eclipse.cdt.debug.core.model.ICDebugTargetType;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICSharedLibrary;
import org.eclipse.cdt.debug.core.model.ICType;
import org.eclipse.cdt.debug.core.model.ICValue;
import org.eclipse.cdt.debug.core.model.ICVariable;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.debug.core.model.IExecFileInfo;
import org.eclipse.cdt.debug.core.model.IStackFrameInfo;
import org.eclipse.cdt.debug.core.model.IState;
import org.eclipse.cdt.debug.core.sourcelookup.IDisassemblyStorage;
import org.eclipse.cdt.debug.internal.core.sourcelookup.DisassemblyManager;
import org.eclipse.cdt.debug.internal.ui.CDTValueDetailProvider;
import org.eclipse.cdt.debug.internal.ui.CDebugImageDescriptorRegistry;
import org.eclipse.cdt.debug.internal.ui.CDebugImages;
import org.eclipse.cdt.debug.internal.ui.OverlayImageCache;
import org.eclipse.cdt.debug.internal.ui.OverlayImageDescriptor;
import org.eclipse.cdt.debug.internal.ui.editors.CDebugEditor;
import org.eclipse.cdt.debug.internal.ui.editors.DisassemblyEditorInput;
import org.eclipse.cdt.debug.internal.ui.editors.EditorInputDelegate;
import org.eclipse.cdt.debug.internal.ui.editors.FileNotFoundElement;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.internal.ui.util.ExternalEditorInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IRegister;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class CDTDebugModelPresentation
extends LabelProvider
implements IDebugModelPresentation {
    public static final String DISPLAY_FULL_PATHS = "DISPLAY_FULL_PATHS";
    private static final String DUMMY_STACKFRAME_LABEL = "...";
    protected HashMap fAttributes = new HashMap(3);
    protected CDebugImageDescriptorRegistry fDebugImageRegistry = CDebugUIPlugin.getImageDescriptorRegistry();
    private static CDTDebugModelPresentation fInstance = null;
    private OverlayImageCache fImageCache = new OverlayImageCache();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public CDTDebugModelPresentation() {
        fInstance = this;
    }

    public static CDTDebugModelPresentation getDefault() {
        return fInstance;
    }

    public void setAttribute(String attribute, Object value) {
        if (value != null) {
            this.fAttributes.put(attribute, value);
        }
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        CDTValueDetailProvider.getDefault().computeDetail(value, listener);
    }

    public IEditorInput getEditorInput(Object element) {
        IResource resource;
        if (element instanceof IMarker && (resource = ((IMarker)element).getResource()) instanceof IFile) {
            return new FileEditorInput((IFile)resource);
        }
        if (element instanceof IFile) {
            return new FileEditorInput((IFile)element);
        }
        if (element instanceof ICAddressBreakpoint) {
            return this.getDisassemblyEditorInput((ICAddressBreakpoint)element);
        }
        if (element instanceof ICLineBreakpoint) {
            IFile file;
            IResource iResource = ((ICLineBreakpoint)element).getMarker().getResource();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.core.resources.IFile;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((file = (IFile)iResource.getAdapter((Class)clazz)) != null) {
                return new FileEditorInput(file);
            }
        }
        if (element instanceof FileStorage) {
            return new ExternalEditorInput((IStorage)element);
        }
        if (element instanceof IDisassemblyStorage) {
            return new DisassemblyEditorInput((IStorage)element);
        }
        if (element instanceof FileNotFoundElement) {
            return new EditorInputDelegate((FileNotFoundElement)element);
        }
        return null;
    }

    public String getEditorId(IEditorInput input, Object element) {
        if (input instanceof EditorInputDelegate) {
            if (((EditorInputDelegate)input).getDelegate() == null) {
                return CDebugEditor.EDITOR_ID;
            }
            return this.getEditorId(((EditorInputDelegate)input).getDelegate(), element);
        }
        String id = null;
        if (input != null) {
            IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
            IEditorDescriptor descriptor = registry.getDefaultEditor(input.getName());
            String string = id = descriptor != null ? descriptor.getId() : "org.eclipse.cdt.ui.editor.CEditor";
        }
        if ("org.eclipse.cdt.ui.editor.CEditor".equals(id)) {
            return CDebugEditor.EDITOR_ID;
        }
        return id;
    }

    public Image getImage(Object element) {
        Image baseImage = this.getBaseImage(element);
        if (baseImage != null) {
            ImageDescriptor[] overlays = new ImageDescriptor[4];
            if (element instanceof ICDebugElementErrorStatus && !((ICDebugElementErrorStatus)element).isOK()) {
                switch (((ICDebugElementErrorStatus)element).getSeverity()) {
                    case 1: {
                        overlays[2] = CDebugImages.DESC_OVRS_WARNING;
                        break;
                    }
                    case 2: {
                        overlays[2] = CDebugImages.DESC_OVRS_ERROR;
                    }
                }
            }
            if (element instanceof ICVariable && ((ICVariable)element).isArgument()) {
                overlays[1] = CDebugImages.DESC_OVRS_ARGUMENT;
            }
            return this.fImageCache.getImageFor(new OverlayImageDescriptor(baseImage, overlays));
        }
        return null;
    }

    private Image getBaseImage(Object element) {
        if (element instanceof IDebugTarget) {
            ICDebugTargetType targetType;
            int type;
            IDebugTarget iDebugTarget = (IDebugTarget)element;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("[Lorg.eclipse.cdt.debug.core.model.ICDebugTargetType;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            int n = type = (targetType = (ICDebugTargetType)iDebugTarget.getAdapter((Class)clazz)) != null ? targetType.getTargetType() : 0;
            if (type == 3) {
                return this.fDebugImageRegistry.get(DebugUITools.getImageDescriptor((String)"IMG_OBJS_DEBUG_TARGET_TERMINATED"));
            }
            IDebugTarget target = (IDebugTarget)element;
            if (target.isTerminated() || target.isDisconnected()) {
                return this.fDebugImageRegistry.get(DebugUITools.getImageDescriptor((String)"IMG_OBJS_DEBUG_TARGET_TERMINATED"));
            }
            return this.fDebugImageRegistry.get(DebugUITools.getImageDescriptor((String)"IMG_OBJS_DEBUG_TARGET"));
        }
        if (element instanceof IThread) {
            ICDebugTargetType targetType;
            int type;
            IDebugTarget iDebugTarget = ((IThread)element).getDebugTarget();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("[Lorg.eclipse.cdt.debug.core.model.ICDebugTargetType;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            int n = type = (targetType = (ICDebugTargetType)iDebugTarget.getAdapter((Class)clazz)) != null ? targetType.getTargetType() : 0;
            if (type == 3) {
                return this.fDebugImageRegistry.get(DebugUITools.getImageDescriptor((String)"IMG_OBJS_THREAD_TERMINATED"));
            }
            IThread thread = (IThread)element;
            if (thread.isSuspended()) {
                return this.fDebugImageRegistry.get(DebugUITools.getImageDescriptor((String)"IMG_OBJS_THREAD_SUSPENDED"));
            }
            if (thread.isTerminated()) {
                return this.fDebugImageRegistry.get(DebugUITools.getImageDescriptor((String)"IMG_OBJS_THREAD_TERMINATED"));
            }
            return this.fDebugImageRegistry.get(DebugUITools.getImageDescriptor((String)"IMG_OBJS_THREAD_RUNNING"));
        }
        try {
            IBreakpoint bp;
            if (element instanceof IMarker && (bp = this.getBreakpoint((IMarker)element)) != null && bp instanceof ICBreakpoint) {
                return this.getBreakpointImage((ICBreakpoint)bp);
            }
            if (element instanceof ICBreakpoint) {
                return this.getBreakpointImage((ICBreakpoint)element);
            }
            if (element instanceof IRegisterGroup) {
                return this.getRegisterGroupImage((IRegisterGroup)element);
            }
            if (element instanceof IExpression) {
                return this.getExpressionImage((IExpression)element);
            }
            if (element instanceof IRegister) {
                return this.getRegisterImage((IRegister)element);
            }
            if (element instanceof IVariable) {
                return this.getVariableImage((IVariable)element);
            }
            if (element instanceof ICSharedLibrary) {
                return this.getSharedLibraryImage((ICSharedLibrary)element);
            }
        }
        catch (CoreException coreException) {}
        return super.getImage(element);
    }

    public String getText(Object element) {
        StringBuffer baseText = new StringBuffer(this.getBaseText(element));
        if (element instanceof ICDebugElementErrorStatus && !((ICDebugElementErrorStatus)element).isOK()) {
            baseText.append(CDTDebugModelPresentation.getFormattedString(" <{0}>", ((ICDebugElementErrorStatus)element).getMessage()));
        }
        return baseText.toString();
    }

    private String getBaseText(Object element) {
        boolean showQualified = this.isShowQualifiedNames();
        StringBuffer label = new StringBuffer();
        try {
            if (element instanceof ICSharedLibrary) {
                label.append(this.getSharedLibraryText((ICSharedLibrary)element, showQualified));
                return label.toString();
            }
            if (element instanceof IRegisterGroup) {
                label.append(((IRegisterGroup)element).getName());
                return label.toString();
            }
            if (element instanceof IVariable) {
                label.append(this.getVariableText((IVariable)element));
                return label.toString();
            }
            if (element instanceof IStackFrame) {
                label.append(this.getStackFrameText((IStackFrame)element, showQualified));
                return label.toString();
            }
            if (element instanceof IMarker) {
                IBreakpoint breakpoint = this.getBreakpoint((IMarker)element);
                if (breakpoint != null) {
                    return this.getBreakpointText(breakpoint, showQualified);
                }
                return null;
            }
            if (element instanceof IBreakpoint) {
                return this.getBreakpointText((IBreakpoint)element, showQualified);
            }
            if (element instanceof IDebugTarget) {
                label.append(this.getTargetText((IDebugTarget)element, showQualified));
            } else if (element instanceof IThread) {
                label.append(this.getThreadText((IThread)element, showQualified));
            }
            if (element instanceof ITerminate && ((ITerminate)element).isTerminated()) {
                label.insert(0, "<terminated>");
                return label.toString();
            }
            if (element instanceof IDisconnect && ((IDisconnect)element).isDisconnected()) {
                label.insert(0, "<disconnected>");
                return label.toString();
            }
            if (label.length() > 0) {
                return label.toString();
            }
        }
        catch (DebugException debugException) {
            return "<not_responding>";
        }
        catch (CoreException e) {
            CDebugUIPlugin.log(e);
        }
        return null;
    }

    protected boolean isShowQualifiedNames() {
        Boolean showQualified = (Boolean)this.fAttributes.get(DISPLAY_FULL_PATHS);
        showQualified = showQualified == null ? Boolean.FALSE : showQualified;
        return showQualified;
    }

    protected boolean isShowVariableTypeNames() {
        Boolean show = (Boolean)this.fAttributes.get(IDebugModelPresentation.DISPLAY_VARIABLE_TYPE_NAMES);
        show = show == null ? Boolean.FALSE : show;
        return show;
    }

    protected String getTargetText(IDebugTarget target, boolean qualified) throws DebugException {
        if (target instanceof IState) {
            IState state = (IState)target;
            switch (state.getCurrentStateId()) {
                case 8: {
                    Object info = state.getCurrentStateInfo();
                    String label = String.valueOf(target.getName()) + " (Exited";
                    if (info != null && info instanceof ICDISignalExitInfo) {
                        ICDISignalExitInfo sigInfo = (ICDISignalExitInfo)info;
                        label = String.valueOf(label) + MessageFormat.format(": Signal ''{0}'' received. Description: {1}.", sigInfo.getName(), sigInfo.getDescription());
                    } else if (info != null && info instanceof ICDIExitInfo) {
                        label = String.valueOf(label) + ". Exit code = " + ((ICDIExitInfo)info).getCode();
                    }
                    return String.valueOf(label) + ")";
                }
                case 7: {
                    Object info = state.getCurrentStateInfo();
                    if (info != null && info instanceof ICDISignalReceived) {
                        ICDISignal signal = ((ICDISignalReceived)info).getSignal();
                        String label = String.valueOf(target.getName()) + MessageFormat.format(" (Signal ''{0}'' received. Description: {1})", signal.getName(), signal.getDescription());
                        return label;
                    }
                    if (info != null && info instanceof ICDIWatchpointTrigger) {
                        String label = String.valueOf(target.getName()) + MessageFormat.format(" (Watchpoint triggered. Old value: ''{0}''. New value: ''{1}'')", ((ICDIWatchpointTrigger)info).getOldValue(), ((ICDIWatchpointTrigger)info).getNewValue());
                        return label;
                    }
                    if (info != null && info instanceof ICDIWatchpointScope) {
                        return String.valueOf(target.getName()) + " (Watchpoint is out of scope)";
                    }
                    if (info != null && info instanceof ICDIBreakpointHit) {
                        return String.valueOf(target.getName()) + " (Breakpoint hit)";
                    }
                    if (info != null && info instanceof ICDISharedLibraryEvent) {
                        return String.valueOf(target.getName()) + " (Stopped on shared library event)";
                    }
                    if (info == null || !(info instanceof ICDISession)) break;
                    return String.valueOf(target.getName()) + " (Suspended)";
                }
            }
        }
        return target.getName();
    }

    protected String getThreadText(IThread thread, boolean qualified) throws DebugException {
        ICDebugTargetType targetType;
        int type;
        IDebugTarget iDebugTarget = thread.getDebugTarget();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("[Lorg.eclipse.cdt.debug.core.model.ICDebugTargetType;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        int n = type = (targetType = (ICDebugTargetType)iDebugTarget.getAdapter((Class)clazz)) != null ? targetType.getTargetType() : 0;
        if (type == 3) {
            return CDTDebugModelPresentation.getFormattedString("Thread [{0}]", thread.getName());
        }
        if (thread.isTerminated()) {
            return CDTDebugModelPresentation.getFormattedString("Thread [{0}] (Terminated)", thread.getName());
        }
        if (thread.isStepping()) {
            return CDTDebugModelPresentation.getFormattedString("Thread [{0}] (Stepping)", thread.getName());
        }
        if (!thread.isSuspended()) {
            return CDTDebugModelPresentation.getFormattedString("Thread [{0}] (Running)", thread.getName());
        }
        return CDTDebugModelPresentation.getFormattedString("Thread [{0}] (Suspended)", thread.getName());
    }

    protected String getStackFrameText(IStackFrame stackFrame, boolean qualified) throws DebugException {
        IStackFrameInfo info;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("[Lorg.eclipse.cdt.debug.core.model.IStackFrameInfo;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((info = (IStackFrameInfo)stackFrame.getAdapter((Class)clazz)) != null) {
            StringBuffer label = new StringBuffer();
            label.append(info.getLevel());
            label.append(' ');
            String function = info.getFunction();
            if (function != null && (function = function.trim()).length() > 0) {
                Path path;
                label.append(function);
                label.append("() ");
                if (info.getFile() != null && !(path = new Path(info.getFile())).isEmpty()) {
                    label.append("at ");
                    label.append(qualified ? path.toOSString() : path.lastSegment());
                    label.append(":");
                    if (info.getFrameLineNumber() != 0) {
                        label.append(info.getFrameLineNumber());
                    }
                }
            }
            if (this.isEmpty(function)) {
                label.append("<symbol is not available>");
            }
            return label.toString();
        }
        Class<?> clazz2 = class$3;
        if (clazz2 == null) {
            try {
                clazz2 = class$3 = Class.forName("[Lorg.eclipse.cdt.debug.core.model.IDummyStackFrame;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return stackFrame.getAdapter((Class)clazz2) != null ? this.getDummyStackFrameLabel(stackFrame) : stackFrame.getName();
    }

    private String getDummyStackFrameLabel(IStackFrame stackFrame) {
        return DUMMY_STACKFRAME_LABEL;
    }

    protected String getVariableText(IVariable var) throws DebugException {
        StringBuffer label = new StringBuffer();
        if (var instanceof ICVariable) {
            IValue value;
            String name;
            String typeName;
            ICType type = null;
            try {
                type = ((ICVariable)var).getType();
            }
            catch (DebugException debugException) {}
            if (type != null && this.isShowVariableTypeNames() && (typeName = this.getVariableTypeName(type)) != null && typeName.length() > 0) {
                label.append(typeName);
                if (type.isArray()) {
                    int[] dims = type.getArrayDimensions();
                    int i = 0;
                    while (i < dims.length) {
                        label.append('[');
                        label.append(dims[i]);
                        label.append(']');
                        ++i;
                    }
                }
                label.append(' ');
            }
            if (!((ICVariable)var).isEnabled()) {
                label.append("<disabled> ");
            }
            if ((name = var.getName()) != null) {
                label.append(name.trim());
            }
            if ((value = var.getValue()) instanceof ICValue && value.getValueString() != null) {
                String valueString = value.getValueString().trim();
                if (type != null && type.isCharacter()) {
                    if (valueString.length() == 0) {
                        valueString = ".";
                    }
                    label.append("= ");
                    label.append(valueString);
                } else if (type != null && type.isFloatingPointType()) {
                    Number floatingPointValue = CDebugUtils.getFloatingPointValue((ICValue)((ICValue)value));
                    if (CDebugUtils.isNaN((Number)floatingPointValue)) {
                        valueString = "NAN";
                    }
                    if (CDebugUtils.isPositiveInfinity((Number)floatingPointValue)) {
                        valueString = "Infinity";
                    }
                    if (CDebugUtils.isNegativeInfinity((Number)floatingPointValue)) {
                        valueString = "-Infinity";
                    }
                    label.append("= ");
                    label.append(valueString);
                } else if ((type == null || !type.isArray() && !type.isStructure()) && valueString.length() > 0) {
                    label.append("= ");
                    label.append(valueString);
                }
            }
        }
        return label.toString();
    }

    protected String getSharedLibraryText(ICSharedLibrary library, boolean qualified) throws DebugException {
        String label = new String();
        Path path = new Path(library.getFileName());
        if (!path.isEmpty()) {
            label = String.valueOf(label) + (qualified ? path.toOSString() : path.lastSegment());
        }
        return label;
    }

    public static String getFormattedString(String key, String arg) {
        return CDTDebugModelPresentation.getFormattedString(key, new String[]{arg});
    }

    public static String getFormattedString(String string, String[] args) {
        return MessageFormat.format(string, args);
    }

    protected Image getBreakpointImage(ICBreakpoint breakpoint) throws CoreException {
        if (breakpoint instanceof ICLineBreakpoint) {
            return this.getLineBreakpointImage((ICLineBreakpoint)breakpoint);
        }
        if (breakpoint instanceof ICWatchpoint) {
            return this.getWatchpointImage((ICWatchpoint)breakpoint);
        }
        return null;
    }

    protected Image getLineBreakpointImage(ICLineBreakpoint breakpoint) throws CoreException {
        ImageDescriptor descriptor = null;
        descriptor = breakpoint.isEnabled() ? DebugUITools.getImageDescriptor((String)"IMG_OBJS_BREAKPOINT") : DebugUITools.getImageDescriptor((String)"IMG_OBJS_BREAKPOINT_DISABLED");
        return this.fImageCache.getImageFor(new OverlayImageDescriptor(this.fDebugImageRegistry.get(descriptor), this.computeBreakpointOverlays((ICBreakpoint)breakpoint)));
    }

    protected Image getWatchpointImage(ICWatchpoint watchpoint) throws CoreException {
        ImageDescriptor descriptor = null;
        descriptor = watchpoint.isEnabled() ? (watchpoint.isReadType() && !watchpoint.isWriteType() ? CDebugImages.DESC_OBJS_READ_WATCHPOINT_ENABLED : (!watchpoint.isReadType() && watchpoint.isWriteType() ? CDebugImages.DESC_OBJS_WRITE_WATCHPOINT_ENABLED : CDebugImages.DESC_OBJS_WATCHPOINT_ENABLED)) : (watchpoint.isReadType() && !watchpoint.isWriteType() ? CDebugImages.DESC_OBJS_READ_WATCHPOINT_DISABLED : (!watchpoint.isReadType() && watchpoint.isWriteType() ? CDebugImages.DESC_OBJS_WRITE_WATCHPOINT_DISABLED : CDebugImages.DESC_OBJS_WATCHPOINT_DISABLED));
        return this.fImageCache.getImageFor(new OverlayImageDescriptor(this.fDebugImageRegistry.get(descriptor), this.computeBreakpointOverlays((ICBreakpoint)watchpoint)));
    }

    protected IBreakpoint getBreakpoint(IMarker marker) {
        return DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker);
    }

    protected String getBreakpointText(IBreakpoint breakpoint, boolean qualified) throws CoreException {
        if (breakpoint instanceof ICAddressBreakpoint) {
            return this.getAddressBreakpointText((ICAddressBreakpoint)breakpoint, qualified);
        }
        if (breakpoint instanceof ICFunctionBreakpoint) {
            return this.getFunctionBreakpointText((ICFunctionBreakpoint)breakpoint, qualified);
        }
        if (breakpoint instanceof ICLineBreakpoint) {
            return this.getLineBreakpointText((ICLineBreakpoint)breakpoint, qualified);
        }
        if (breakpoint instanceof ICWatchpoint) {
            return this.getWatchpointText((ICWatchpoint)breakpoint, qualified);
        }
        return "";
    }

    protected String getLineBreakpointText(ICLineBreakpoint breakpoint, boolean qualified) throws CoreException {
        StringBuffer label = new StringBuffer();
        this.appendResourceName((ICBreakpoint)breakpoint, label, qualified);
        this.appendLineNumber(breakpoint, label);
        this.appendIgnoreCount((ICBreakpoint)breakpoint, label);
        this.appendCondition((ICBreakpoint)breakpoint, label);
        return label.toString();
    }

    protected String getWatchpointText(ICWatchpoint watchpoint, boolean qualified) throws CoreException {
        StringBuffer label = new StringBuffer();
        this.appendResourceName((ICBreakpoint)watchpoint, label, qualified);
        this.appendWatchExpression(watchpoint, label);
        this.appendIgnoreCount((ICBreakpoint)watchpoint, label);
        this.appendCondition((ICBreakpoint)watchpoint, label);
        return label.toString();
    }

    protected String getAddressBreakpointText(ICAddressBreakpoint breakpoint, boolean qualified) throws CoreException {
        StringBuffer label = new StringBuffer();
        this.appendResourceName((ICBreakpoint)breakpoint, label, qualified);
        this.appendAddress(breakpoint, label);
        this.appendIgnoreCount((ICBreakpoint)breakpoint, label);
        this.appendCondition((ICBreakpoint)breakpoint, label);
        return label.toString();
    }

    protected String getFunctionBreakpointText(ICFunctionBreakpoint breakpoint, boolean qualified) throws CoreException {
        StringBuffer label = new StringBuffer();
        this.appendResourceName((ICBreakpoint)breakpoint, label, qualified);
        this.appendFunction(breakpoint, label);
        this.appendIgnoreCount((ICBreakpoint)breakpoint, label);
        this.appendCondition((ICBreakpoint)breakpoint, label);
        return label.toString();
    }

    protected StringBuffer appendResourceName(ICBreakpoint breakpoint, StringBuffer label, boolean qualified) throws CoreException {
        IPath path = breakpoint.getMarker().getResource().getLocation();
        if (!path.isEmpty()) {
            label.append(qualified ? path.toOSString() : path.lastSegment());
        }
        return label;
    }

    protected StringBuffer appendLineNumber(ICLineBreakpoint breakpoint, StringBuffer label) throws CoreException {
        int lineNumber = breakpoint.getLineNumber();
        if (lineNumber > 0) {
            label.append(" [");
            label.append("line:");
            label.append(' ');
            label.append(lineNumber);
            label.append(']');
        }
        return label;
    }

    protected StringBuffer appendAddress(ICAddressBreakpoint breakpoint, StringBuffer label) throws CoreException {
        try {
            long address = Long.parseLong(breakpoint.getAddress());
            label.append(" [address: ");
            label.append(CDebugUtils.toHexAddressString((long)address));
            label.append(']');
        }
        catch (NumberFormatException numberFormatException) {}
        return label;
    }

    protected StringBuffer appendFunction(ICFunctionBreakpoint breakpoint, StringBuffer label) throws CoreException {
        String function = breakpoint.getFunction();
        if (function != null && function.trim().length() > 0) {
            label.append(" [");
            label.append("function:");
            label.append(' ');
            label.append(function.trim());
            label.append(']');
        }
        return label;
    }

    protected StringBuffer appendIgnoreCount(ICBreakpoint breakpoint, StringBuffer label) throws CoreException {
        int ignoreCount = breakpoint.getIgnoreCount();
        if (ignoreCount > 0) {
            label.append(" [");
            label.append("ignore count:");
            label.append(' ');
            label.append(ignoreCount);
            label.append(']');
        }
        return label;
    }

    protected void appendCondition(ICBreakpoint breakpoint, StringBuffer buffer) throws CoreException {
        String condition = breakpoint.getCondition();
        if (condition != null && condition.length() > 0) {
            buffer.append(" if ");
            buffer.append(condition);
        }
    }

    private void appendWatchExpression(ICWatchpoint watchpoint, StringBuffer label) throws CoreException {
        String expression = watchpoint.getExpression();
        if (expression != null && expression.length() > 0) {
            label.append(" at '");
            label.append(expression);
            label.append('\'');
        }
    }

    private ImageDescriptor[] computeBreakpointOverlays(ICBreakpoint breakpoint) {
        ImageDescriptor[] overlays = new ImageDescriptor[4];
        try {
            if (breakpoint.isConditional()) {
                ImageDescriptor imageDescriptor = overlays[0] = breakpoint.isEnabled() ? CDebugImages.DESC_OVRS_BREAKPOINT_CONDITIONAL : CDebugImages.DESC_OVRS_BREAKPOINT_CONDITIONAL_DISABLED;
            }
            if (breakpoint.isInstalled()) {
                ImageDescriptor imageDescriptor = overlays[2] = breakpoint.isEnabled() ? CDebugImages.DESC_OVRS_BREAKPOINT_INSTALLED : CDebugImages.DESC_OVRS_BREAKPOINT_INSTALLED_DISABLED;
            }
            if (breakpoint instanceof ICAddressBreakpoint) {
                ImageDescriptor imageDescriptor = overlays[1] = breakpoint.isEnabled() ? CDebugImages.DESC_OVRS_ADDRESS_BREAKPOINT : CDebugImages.DESC_OVRS_ADDRESS_BREAKPOINT_DISABLED;
            }
            if (breakpoint instanceof ICFunctionBreakpoint) {
                overlays[1] = breakpoint.isEnabled() ? CDebugImages.DESC_OVRS_FUNCTION_BREAKPOINT : CDebugImages.DESC_OVRS_FUNCTION_BREAKPOINT_DISABLED;
            }
        }
        catch (CoreException e) {
            CDebugUIPlugin.log(e);
        }
        return overlays;
    }

    protected Image getVariableImage(IVariable element) throws DebugException {
        if (element instanceof ICVariable) {
            ICType type = null;
            try {
                type = ((ICVariable)element).getType();
            }
            catch (DebugException debugException) {}
            if (type != null && (type.isPointer() || type.isReference())) {
                return this.fDebugImageRegistry.get(((ICVariable)element).isEnabled() ? CDebugImages.DESC_OBJS_VARIABLE_POINTER : CDebugImages.DESC_OBJS_VARIABLE_POINTER_DISABLED);
            }
            if (((ICVariable)element).hasChildren()) {
                return this.fDebugImageRegistry.get(((ICVariable)element).isEnabled() ? CDebugImages.DESC_OBJS_VARIABLE_AGGREGATE : CDebugImages.DESC_OBJS_VARIABLE_AGGREGATE_DISABLED);
            }
            return this.fDebugImageRegistry.get(((ICVariable)element).isEnabled() ? CDebugImages.DESC_OBJS_VARIABLE_SIMPLE : CDebugImages.DESC_OBJS_VARIABLE_SIMPLE_DISABLED);
        }
        return null;
    }

    protected Image getRegisterGroupImage(IRegisterGroup element) throws DebugException {
        return this.fDebugImageRegistry.get(CDebugImages.DESC_OBJS_REGISTER_GROUP);
    }

    protected Image getRegisterImage(IRegister element) throws DebugException {
        return this.fDebugImageRegistry.get(CDebugImages.DESC_OBJS_REGISTER);
    }

    protected Image getExpressionImage(IExpression element) throws DebugException {
        return this.fDebugImageRegistry.get(DebugUITools.getImageDescriptor((String)"IMG_OBJS_EXPRESSION"));
    }

    protected Image getSharedLibraryImage(ICSharedLibrary element) throws DebugException {
        if (element.areSymbolsLoaded()) {
            ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[4];
            imageDescriptorArray[1] = CDebugImages.DESC_OVRS_SYMBOLS;
            return this.fImageCache.getImageFor(new OverlayImageDescriptor(this.fDebugImageRegistry.get(CDebugImages.DESC_OBJS_LOADED_SHARED_LIBRARY), imageDescriptorArray));
        }
        return CDebugUIPlugin.getImageDescriptorRegistry().get(CDebugImages.DESC_OBJS_SHARED_LIBRARY);
    }

    protected DisassemblyEditorInput getDisassemblyEditorInput(ICAddressBreakpoint breakpoint) {
        IDebugTarget[] targets = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
        int i = 0;
        while (i < targets.length) {
            IResource resource = breakpoint.getMarker().getResource();
            if (resource != null && resource instanceof IFile) {
                IDebugTarget iDebugTarget = targets[i];
                Class<?> clazz = class$4;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("[Lorg.eclipse.cdt.debug.core.model.IExecFileInfo;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (iDebugTarget.getAdapter((Class)clazz) != null) {
                    String string = ((IFile)resource).getLocation().toOSString();
                    IDebugTarget iDebugTarget2 = targets[i];
                    Class<?> clazz2 = class$4;
                    if (clazz2 == null) {
                        try {
                            clazz2 = Class.forName("[Lorg.eclipse.cdt.debug.core.model.IExecFileInfo;").getComponentType();
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (string.equals(((IExecFileInfo)iDebugTarget2.getAdapter((Class)clazz2)).getExecFile().getLocation().toOSString())) {
                        IDebugTarget iDebugTarget3 = targets[i];
                        Class<?> clazz3 = class$5;
                        if (clazz3 == null) {
                            try {
                                clazz3 = Class.forName("[Lorg.eclipse.cdt.debug.internal.core.sourcelookup.DisassemblyManager;").getComponentType();
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (iDebugTarget3.getAdapter((Class)clazz3) != null) {
                            try {
                                IStorage storage;
                                long address = Long.parseLong(breakpoint.getAddress());
                                IDebugTarget iDebugTarget4 = targets[i];
                                Class<?> clazz4 = class$5;
                                if (clazz4 == null) {
                                    try {
                                        clazz4 = Class.forName("[Lorg.eclipse.cdt.debug.internal.core.sourcelookup.DisassemblyManager;").getComponentType();
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if ((storage = (IStorage)((DisassemblyManager)iDebugTarget4.getAdapter((Class)clazz4)).getSourceElement(address)) != null) {
                                    return new DisassemblyEditorInput(storage);
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                            }
                            catch (CoreException coreException) {}
                        }
                    }
                }
            }
            ++i;
        }
        return null;
    }

    private String getVariableTypeName(ICType type) {
        int index;
        String typeName = type.getName();
        if (type.isArray() && typeName != null && (index = typeName.indexOf(91)) != -1) {
            return typeName.substring(0, index).trim();
        }
        return typeName;
    }

    public void dispose() {
        this.fImageCache.disposeAll();
    }

    private boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }
}

