/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.memory;

import org.eclipse.cdt.debug.core.ICMemoryManager;
import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.actions.AutoRefreshMemoryAction;
import org.eclipse.cdt.debug.internal.ui.actions.ClearMemoryAction;
import org.eclipse.cdt.debug.internal.ui.actions.MemoryActionSelectionGroup;
import org.eclipse.cdt.debug.internal.ui.actions.MemoryFormatAction;
import org.eclipse.cdt.debug.internal.ui.actions.MemoryNumberOfColumnAction;
import org.eclipse.cdt.debug.internal.ui.actions.MemorySizeAction;
import org.eclipse.cdt.debug.internal.ui.actions.RefreshMemoryAction;
import org.eclipse.cdt.debug.internal.ui.actions.ShowAsciiAction;
import org.eclipse.cdt.debug.internal.ui.preferences.ICDebugPreferenceConstants;
import org.eclipse.cdt.debug.internal.ui.views.AbstractDebugEventHandler;
import org.eclipse.cdt.debug.internal.ui.views.AbstractDebugEventHandlerView;
import org.eclipse.cdt.debug.internal.ui.views.IDebugExceptionHandler;
import org.eclipse.cdt.debug.internal.ui.views.memory.MemoryControlArea;
import org.eclipse.cdt.debug.internal.ui.views.memory.MemoryViewAction;
import org.eclipse.cdt.debug.internal.ui.views.memory.MemoryViewContentProvider;
import org.eclipse.cdt.debug.internal.ui.views.memory.MemoryViewEventHandler;
import org.eclipse.cdt.debug.internal.ui.views.memory.MemoryViewer;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;

public class MemoryView
extends AbstractDebugEventHandlerView
implements ISelectionListener,
IPropertyChangeListener,
IDebugExceptionHandler {
    private IDebugModelPresentation fModelPresentation = null;
    private MemoryActionSelectionGroup fMemoryFormatGroup = null;
    private MemoryActionSelectionGroup fMemorySizeGroup = null;
    private MemoryActionSelectionGroup fMemoryNumberOfColumnsGroup = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected Viewer createViewer(Composite parent) {
        CDebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        MemoryViewer viewer = new MemoryViewer(parent, this);
        viewer.setContentProvider(this.createContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)this.getModelPresentation());
        this.getSite().getPage().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        this.setEventHandler(this.createEventHandler((Viewer)viewer));
        return viewer;
    }

    protected void createActions() {
        IUpdate action = null;
        action = new MemoryViewAction((IAdaptable)this, 3);
        action.setText("Cut");
        action.setToolTipText("Cut");
        action.setDescription("Cut");
        this.setGlobalAction(ITextEditorActionConstants.CUT, (MemoryViewAction)action);
        action = new MemoryViewAction((IAdaptable)this, 4);
        action.setText("Copy");
        action.setToolTipText("Copy");
        action.setDescription("Copy");
        this.setGlobalAction(ITextEditorActionConstants.COPY, (MemoryViewAction)action);
        action = new MemoryViewAction((IAdaptable)this, 5);
        action.setText("Paste");
        action.setToolTipText("Paste");
        action.setDescription("Paste");
        this.setGlobalAction(ITextEditorActionConstants.PASTE, (MemoryViewAction)action);
        action = new MemoryViewAction((IAdaptable)this, 7);
        action.setText("Select All");
        action.setToolTipText("Select All");
        action.setDescription("Select All");
        this.setGlobalAction(ITextEditorActionConstants.SELECT_ALL, (MemoryViewAction)action);
        action = new RefreshMemoryAction((MemoryViewer)this.getViewer());
        action.setEnabled(false);
        this.setAction("RefreshMemory", (IAction)action);
        this.add((RefreshMemoryAction)action);
        action = new AutoRefreshMemoryAction((MemoryViewer)this.getViewer());
        action.setEnabled(false);
        action.setChecked(CDebugUIPlugin.getDefault().getPreferenceStore().getBoolean(ICDebugPreferenceConstants.PREF_MEMORY_AUTO_REFRESH));
        this.setAction("AutoRefreshMemory", (IAction)action);
        this.add((AutoRefreshMemoryAction)action);
        action = new ClearMemoryAction((MemoryViewer)this.getViewer());
        action.setEnabled(false);
        this.setAction("ClearMemory", (IAction)action);
        this.add((ClearMemoryAction)action);
        action = new ShowAsciiAction((MemoryViewer)this.getViewer());
        action.setEnabled(false);
        action.setChecked(CDebugUIPlugin.getDefault().getPreferenceStore().getBoolean(ICDebugPreferenceConstants.PREF_MEMORY_SHOW_ASCII));
        this.setAction("ShowAscii", (IAction)action);
        this.add((ShowAsciiAction)action);
        this.fMemoryFormatGroup = new MemoryActionSelectionGroup();
        this.createFormatActionGroup(this.fMemoryFormatGroup);
        this.fMemorySizeGroup = new MemoryActionSelectionGroup();
        this.createSizeActionGroup(this.fMemorySizeGroup);
        this.fMemoryNumberOfColumnsGroup = new MemoryActionSelectionGroup();
        this.createNumberOfColumnsActionGroup(this.fMemoryNumberOfColumnsGroup);
        this.setInitialContent();
    }

    protected String getHelpContextId() {
        return ICDebugHelpContextIds.MEMORY_VIEW;
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("emptyMemoryGroup"));
        menu.add((IContributionItem)new Separator("memoryGroup"));
        menu.add((IContributionItem)new Separator("emptyFormatGroup"));
        menu.add((IContributionItem)new Separator("formatGroup"));
        menu.add((IContributionItem)new Separator("emptyRenderGroup"));
        menu.add((IContributionItem)new Separator("renderGroup"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.appendToGroup("memoryGroup", this.getAction("AutoRefreshMemory"));
        menu.appendToGroup("memoryGroup", this.getAction("RefreshMemory"));
        menu.appendToGroup("memoryGroup", this.getAction("ClearMemory"));
        MenuManager subMenu = new MenuManager("Format");
        IAction[] actions = this.fMemoryFormatGroup.getActions();
        int i = 0;
        while (i < actions.length) {
            subMenu.add(actions[i]);
            ++i;
        }
        menu.appendToGroup("formatGroup", (IContributionItem)subMenu);
        subMenu = new MenuManager("Memory Unit Size         ");
        actions = this.fMemorySizeGroup.getActions();
        i = 0;
        while (i < actions.length) {
            subMenu.add(actions[i]);
            ++i;
        }
        menu.appendToGroup("formatGroup", (IContributionItem)subMenu);
        subMenu = new MenuManager("Number Of Columns");
        actions = this.fMemoryNumberOfColumnsGroup.getActions();
        i = 0;
        while (i < actions.length) {
            subMenu.add(actions[i]);
            ++i;
        }
        menu.appendToGroup("formatGroup", (IContributionItem)subMenu);
        menu.appendToGroup("renderGroup", this.getAction("ShowAscii"));
    }

    protected void configureToolBar(IToolBarManager tbm) {
        tbm.add((IContributionItem)new Separator(this.getClass().getName()));
        tbm.add((IContributionItem)new Separator("memoryGroup"));
        tbm.add(this.getAction("AutoRefreshMemory"));
        tbm.add(this.getAction("RefreshMemory"));
        tbm.add(this.getAction("ClearMemory"));
        tbm.add((IContributionItem)new Separator("renderGroup"));
        tbm.add(this.getAction("ShowAscii"));
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.setViewerInput((IStructuredSelection)selection);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        ((MemoryViewer)this.getViewer()).propertyChange(event);
    }

    public void handleException(DebugException e) {
    }

    public void dispose() {
        this.removeActionGroup(this.fMemoryFormatGroup);
        this.fMemoryFormatGroup.dispose();
        this.removeActionGroup(this.fMemorySizeGroup);
        this.fMemorySizeGroup.dispose();
        this.removeActionGroup(this.fMemoryNumberOfColumnsGroup);
        this.fMemoryNumberOfColumnsGroup.dispose();
        this.remove((ShowAsciiAction)this.getAction("ShowAscii"));
        this.remove((ClearMemoryAction)this.getAction("ClearMemory"));
        this.remove((RefreshMemoryAction)this.getAction("RefreshMemory"));
        this.remove((AutoRefreshMemoryAction)this.getAction("AutoRefreshMemory"));
        this.getSite().getPage().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        CDebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    protected void setViewerInput(IStructuredSelection ssel) {
        Object current;
        Object input;
        ICMemoryManager mm = null;
        if (ssel != null && ssel.size() == 1 && (input = ssel.getFirstElement()) instanceof IDebugElement) {
            IDebugTarget iDebugTarget = ((IDebugElement)input).getDebugTarget();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.cdt.debug.core.ICMemoryManager;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            mm = (ICMemoryManager)iDebugTarget.getAdapter((Class)clazz);
        }
        if ((current = this.getViewer().getInput()) != null && current.equals(mm)) {
            return;
        }
        this.showViewer();
        this.getViewer().setInput(mm);
        this.updateObjects();
    }

    private IContentProvider createContentProvider() {
        return new MemoryViewContentProvider();
    }

    private IDebugModelPresentation getModelPresentation() {
        if (this.fModelPresentation == null) {
            this.fModelPresentation = CDebugUIPlugin.getDebugModelPresentation();
        }
        return this.fModelPresentation;
    }

    protected AbstractDebugEventHandler createEventHandler(Viewer viewer) {
        return new MemoryViewEventHandler(this);
    }

    protected void setInitialContent() {
        ISelection selection = this.getSite().getPage().getSelection("org.eclipse.debug.ui.DebugView");
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            this.setViewerInput((IStructuredSelection)selection);
        } else {
            this.setViewerInput(null);
        }
    }

    protected void createContextMenu(Control menuControl) {
        CTabItem[] items = ((MemoryViewer)this.getViewer()).getTabFolder().getItems();
        int i = 0;
        while (i < items.length) {
            super.createContextMenu(((MemoryControlArea)items[i].getControl()).getMemoryText().getControl());
            ++i;
        }
    }

    private void createFormatActionGroup(MemoryActionSelectionGroup group) {
        int[] nArray = new int[3];
        nArray[1] = 3;
        nArray[2] = 4;
        int[] formats = nArray;
        int i = 0;
        while (i < formats.length) {
            MemoryFormatAction action = new MemoryFormatAction(group, (MemoryViewer)this.getViewer(), formats[i]);
            action.setEnabled(false);
            this.setAction(action.getActionId(), (IAction)action);
            this.add(action);
            group.addAction((IAction)action);
            ++i;
        }
    }

    private void createSizeActionGroup(MemoryActionSelectionGroup group) {
        int[] ids = new int[]{1, 2, 4, 8};
        int i = 0;
        while (i < ids.length) {
            MemorySizeAction action = new MemorySizeAction(group, (MemoryViewer)this.getViewer(), ids[i]);
            action.setEnabled(false);
            this.setAction(action.getActionId(), (IAction)action);
            this.add(action);
            group.addAction((IAction)action);
            ++i;
        }
    }

    private void createNumberOfColumnsActionGroup(MemoryActionSelectionGroup group) {
        int[] nocs = new int[]{1, 2, 4, 8, 16};
        int i = 0;
        while (i < nocs.length) {
            MemoryNumberOfColumnAction action = new MemoryNumberOfColumnAction(group, (MemoryViewer)this.getViewer(), nocs[i]);
            action.setEnabled(false);
            this.setAction(action.getActionId(), (IAction)action);
            this.add(action);
            group.addAction((IAction)action);
            ++i;
        }
    }

    private void removeActionGroup(MemoryActionSelectionGroup group) {
        IAction[] actions = group.getActions();
        int i = 0;
        while (i < actions.length) {
            this.remove((IUpdate)actions[i]);
            ++i;
        }
    }

    private void setGlobalAction(String actionId, MemoryViewAction action) {
        this.add(action);
        this.getViewSite().getActionBars().setGlobalActionHandler(actionId, (IAction)action);
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("[Lorg.eclipse.jface.text.ITextOperationTarget;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return ((MemoryViewer)this.getViewer()).getTextOperationTarget();
        }
        return super.getAdapter(adapter);
    }
}

