/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.cdt.core.CCProjectNature;
import org.eclipse.cdt.core.CProjectNature;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.core.IErrorParser;
import org.eclipse.cdt.core.IProcessList;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.internal.core.CDTLogWriter;
import org.eclipse.cdt.internal.core.CDescriptorManager;
import org.eclipse.cdt.internal.core.model.BufferManager;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.DeltaProcessor;
import org.eclipse.cdt.internal.core.model.IBufferFactory;
import org.eclipse.cdt.internal.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.internal.core.search.indexing.AbstractIndexer;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.matching.MatchLocator;
import org.eclipse.cdt.internal.core.search.processing.JobManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class CCorePlugin
extends Plugin {
    public static final int STATUS_CDTPROJECT_EXISTS = 1;
    public static final int STATUS_CDTPROJECT_MISMATCH = 2;
    public static final int CDT_PROJECT_NATURE_ID_MISMATCH = 3;
    public static final String PLUGIN_ID = "org.eclipse.cdt.core";
    public static final String BUILDER_MODEL_ID = "org.eclipse.cdt.core.CBuildModel";
    public static final String BINARY_PARSER_SIMPLE_ID = "BinaryParser";
    public static final String BINARY_PARSER_UNIQ_ID = "org.eclipse.cdt.core.BinaryParser";
    public static final String PREF_BINARY_PARSER = "binaryparser";
    public static final String DEFAULT_BINARY_PARSER_SIMPLE_ID = "ELF";
    public static final String DEFAULT_BINARY_PARSER_UNIQ_ID = "org.eclipse.cdt.core.ELF";
    public static final String ERROR_PARSER_SIMPLE_ID = "ErrorParser";
    public static final String BUILD_SCANNER_INFO_SIMPLE_ID = "ScannerInfoProvider";
    public static final String BUILD_SCANNER_INFO_UNIQ_ID = "org.eclipse.cdt.core.ScannerInfoProvider";
    public static final String TRANSLATION_TASK_PRIORITIES = "org.eclipse.cdt.core.translation.taskPriorities";
    public static final String TRANSLATION_TASK_PRIORITY_HIGH = "HIGH";
    public static final String TRANSLATION_TASK_PRIORITY_LOW = "LOW";
    public static final String TRANSLATION_TASK_PRIORITY_NORMAL = "NORMAL";
    public static final String TRANSLATION_TASK_TAGS = "org.eclipse.cdt.core.translation.taskTags";
    public static final String DEFAULT_TASK_TAG = "TODO";
    public static final String DEFAULT_TASK_PRIORITY = "NORMAL";
    public static final String CORE_ENCODING = "org.eclipse.cdt.core.encoding";
    public CDTLogWriter cdtLog = null;
    private static CCorePlugin fgCPlugin;
    private static ResourceBundle fgResourceBundle;
    private CDescriptorManager fDescriptorManager;
    private CoreModel fCoreModel;
    private static final String MODEL = "org.eclipse.cdt.core/debug/model";
    private static final String INDEXER = "org.eclipse.cdt.core/debug/indexer";
    private static final String INDEX_MANAGER = "org.eclipse.cdt.core/debug/indexmanager";
    private static final String SEARCH = "org.eclipse.cdt.core/debug/search";
    private static final String MATCH_LOCATOR = "org.eclipse.cdt.core/debug/matchlocator";
    private static final String PARSER = "org.eclipse.cdt.core/debug/parser";
    private static final String DELTA = "org.eclipse.cdt.core/debug/deltaprocessor";

    static {
        try {
            fgResourceBundle = ResourceBundle.getBundle("org.eclipse.cdt.internal.core.CCorePluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            fgResourceBundle = null;
        }
    }

    public static IWorkingCopy[] getSharedWorkingCopies(IBufferFactory factory) {
        Map sharedWorkingCopies;
        Map perFactoryWorkingCopies;
        if (factory == null) {
            factory = BufferManager.getDefaultBufferManager().getDefaultBufferFactory();
        }
        if ((perFactoryWorkingCopies = (Map)(sharedWorkingCopies = CModelManager.getDefault().sharedWorkingCopies).get(factory)) == null) {
            return CModelManager.NoWorkingCopy;
        }
        Collection copies = perFactoryWorkingCopies.values();
        IWorkingCopy[] result = new IWorkingCopy[copies.size()];
        copies.toArray(result);
        return result;
    }

    public static String getResourceString(String key) {
        try {
            return fgResourceBundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return "!" + key + "!";
        }
        catch (NullPointerException nullPointerException) {
            return "#" + key + "#";
        }
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getFormattedString(String key, String arg) {
        return MessageFormat.format(CCorePlugin.getResourceString(key), arg);
    }

    public static String getFormattedString(String key, String[] args) {
        return MessageFormat.format(CCorePlugin.getResourceString(key), args);
    }

    public static ResourceBundle getResourceBundle() {
        return fgResourceBundle;
    }

    public static CCorePlugin getDefault() {
        return fgCPlugin;
    }

    public static void log(Throwable e) {
        CCorePlugin.log((IStatus)new Status(4, PLUGIN_ID, 4, "Error", e));
    }

    public static void log(IStatus status) {
        CCorePlugin.getDefault().getLog().log(status);
    }

    public CCorePlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        fgCPlugin = this;
    }

    public void shutdown() throws CoreException {
        super.shutdown();
        if (this.fDescriptorManager != null) {
            this.fDescriptorManager.shutdown();
        }
        if (this.fCoreModel != null) {
            this.fCoreModel.shutdown();
        }
        if (this.cdtLog != null) {
            this.cdtLog.shutdown();
        }
    }

    public void startup() throws CoreException {
        super.startup();
        this.cdtLog = new CDTLogWriter(CCorePlugin.getDefault().getStateLocation().append(".log").toFile());
        CCorePlugin.getDefault().configurePluginDebugOptions();
        this.fCoreModel = CoreModel.getDefault();
        this.fCoreModel.startup();
        this.fCoreModel.startIndexing();
        this.fDescriptorManager = new CDescriptorManager();
        this.fDescriptorManager.startup();
    }

    public static HashMap getDefaultOptions() {
        HashMap<String, String> defaultOptions = new HashMap<String, String>(10);
        Preferences preferences = CCorePlugin.getDefault().getPluginPreferences();
        HashSet optionNames = CModelManager.OptionNames;
        String[] defaultPropertyNames = preferences.defaultPropertyNames();
        int i = 0;
        while (i < defaultPropertyNames.length) {
            String propertyName = defaultPropertyNames[i];
            if (optionNames.contains(propertyName)) {
                defaultOptions.put(propertyName, preferences.getDefaultString(propertyName));
            }
            ++i;
        }
        String[] propertyNames = preferences.propertyNames();
        int i2 = 0;
        while (i2 < propertyNames.length) {
            String propertyName = propertyNames[i2];
            if (optionNames.contains(propertyName)) {
                defaultOptions.put(propertyName, preferences.getDefaultString(propertyName));
            }
            ++i2;
        }
        defaultOptions.put(CORE_ENCODING, ResourcesPlugin.getEncoding());
        return defaultOptions;
    }

    protected void initializeDefaultPluginPreferences() {
        Preferences preferences = this.getPluginPreferences();
        HashSet optionNames = CModelManager.OptionNames;
        preferences.setDefault(TRANSLATION_TASK_TAGS, DEFAULT_TASK_TAG);
        optionNames.add(TRANSLATION_TASK_TAGS);
        preferences.setDefault(TRANSLATION_TASK_PRIORITIES, "NORMAL");
        optionNames.add(TRANSLATION_TASK_PRIORITIES);
    }

    public static String getOption(String optionName) {
        if (CORE_ENCODING.equals(optionName)) {
            return ResourcesPlugin.getEncoding();
        }
        if (CModelManager.OptionNames.contains(optionName)) {
            Preferences preferences = CCorePlugin.getDefault().getPluginPreferences();
            return preferences.getString(optionName).trim();
        }
        return null;
    }

    public static HashMap getOptions() {
        HashMap<String, String> options = new HashMap<String, String>(10);
        CCorePlugin plugin = CCorePlugin.getDefault();
        if (plugin != null) {
            Preferences preferences = plugin.getPluginPreferences();
            HashSet optionNames = CModelManager.OptionNames;
            String[] defaultPropertyNames = preferences.defaultPropertyNames();
            int i = 0;
            while (i < defaultPropertyNames.length) {
                String propertyName = defaultPropertyNames[i];
                if (optionNames.contains(propertyName)) {
                    options.put(propertyName, preferences.getDefaultString(propertyName));
                }
                ++i;
            }
            String[] propertyNames = preferences.propertyNames();
            int i2 = 0;
            while (i2 < propertyNames.length) {
                String propertyName = propertyNames[i2];
                if (optionNames.contains(propertyName)) {
                    options.put(propertyName, preferences.getString(propertyName).trim());
                }
                ++i2;
            }
            options.put(CORE_ENCODING, ResourcesPlugin.getEncoding());
        }
        return options;
    }

    public static void setOptions(HashMap newOptions) {
        Preferences preferences = CCorePlugin.getDefault().getPluginPreferences();
        if (newOptions == null) {
            newOptions = CCorePlugin.getDefaultOptions();
        }
        Iterator keys = newOptions.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!CModelManager.OptionNames.contains(key) || key.equals(CORE_ENCODING)) continue;
            String value = (String)newOptions.get(key);
            preferences.setValue(key, value);
        }
        CCorePlugin.getDefault().savePluginPreferences();
    }

    public IConsole getConsole(String id) {
        try {
            IExtensionPoint extension = this.getDescriptor().getExtensionPoint("CBuildConsole");
            if (extension != null) {
                IExtension[] extensions = extension.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                    int j = 0;
                    while (j < configElements.length) {
                        String builderID = configElements[j].getAttribute("builderID");
                        if (id == null && builderID == null || id != null && builderID.equals(id)) {
                            return (IConsole)configElements[j].createExecutableExtension("class");
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
        return new IConsole(){

            public void clear() {
            }

            public void start(IProject project) {
            }

            public ConsoleOutputStream getOutputStream() {
                return new ConsoleOutputStream();
            }
        };
    }

    public IConsole getConsole() throws CoreException {
        return this.getConsole(null);
    }

    public IBinaryParser getBinaryParser(IProject project) throws CoreException {
        IBinaryParser parser = null;
        if (project != null) {
            try {
                ICDescriptor cdesc = this.getCProjectDescription(project);
                ICExtensionReference[] cextensions = cdesc.get(BINARY_PARSER_UNIQ_ID, true);
                if (cextensions.length > 0) {
                    parser = (IBinaryParser)((Object)cextensions[0].createExtension());
                }
            }
            catch (CoreException coreException) {}
        }
        if (parser == null) {
            parser = this.getDefaultBinaryParser();
        }
        return parser;
    }

    public IBinaryParser getDefaultBinaryParser() throws CoreException {
        IExtensionPoint extensionPoint;
        IExtension extension;
        IBinaryParser parser = null;
        String id = this.getPluginPreferences().getDefaultString(PREF_BINARY_PARSER);
        if (id == null || id.length() == 0) {
            id = DEFAULT_BINARY_PARSER_UNIQ_ID;
        }
        if ((extension = (extensionPoint = this.getDescriptor().getExtensionPoint(BINARY_PARSER_SIMPLE_ID)).getExtension(id)) != null) {
            IConfigurationElement[] element = extension.getConfigurationElements();
            int i = 0;
            while (i < element.length) {
                if (element[i].getName().equalsIgnoreCase("cextension")) {
                    parser = (IBinaryParser)element[i].createExecutableExtension("run");
                    break;
                }
                ++i;
            }
        } else {
            Status s = new Status(4, PLUGIN_ID, -1, "No Binary Format", null);
            throw new CoreException((IStatus)s);
        }
        return parser;
    }

    public CoreModel getCoreModel() {
        return this.fCoreModel;
    }

    public ICDescriptor getCProjectDescription(IProject project) throws CoreException {
        return this.fDescriptorManager.getDescriptor(project);
    }

    public void mapCProjectOwner(IProject project, String id, boolean override) throws CoreException {
        if (!override) {
            this.fDescriptorManager.configure(project, id);
        } else {
            this.fDescriptorManager.convert(project, id);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IProject createCProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor, String projectID) throws CoreException, OperationCanceledException {
        try {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask("Creating C Project...", 3);
            if (!projectHandle.exists()) {
                projectHandle.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            projectHandle.open((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.mapCProjectOwner(projectHandle, projectID, false);
            CProjectNature.addCNature(projectHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        monitor.done();
        return projectHandle;
    }

    public void convertProjectFromCtoCC(IProject projectHandle, IProgressMonitor monitor) throws CoreException {
        if (projectHandle != null && projectHandle.hasNature("org.eclipse.cdt.core.cnature") && !projectHandle.hasNature("org.eclipse.cdt.core.ccnature")) {
            CCProjectNature.addCCNature(projectHandle, monitor);
        }
    }

    public void convertProjectToC(IProject projectHandle, IProgressMonitor monitor, String projectID) throws CoreException {
        if (projectHandle == null || monitor == null || projectID == null) {
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProjectDescription description = workspace.newProjectDescription(projectHandle.getName());
        description.setLocation(projectHandle.getFullPath());
        this.createCProject(description, projectHandle, monitor, projectID);
    }

    public void convertProjectToCC(IProject projectHandle, IProgressMonitor monitor, String projectID) throws CoreException {
        if (projectHandle == null || monitor == null || projectID == null) {
            return;
        }
        this.createCProject(projectHandle.getDescription(), projectHandle, monitor, projectID);
        this.convertProjectFromCtoCC(projectHandle, monitor);
    }

    public IProcessList getProcessList() {
        IExtension[] extensions;
        IConfigurationElement[] configElements;
        IExtensionPoint extension = this.getDescriptor().getExtensionPoint("ProcessList");
        if (extension != null && (configElements = (extensions = extension.getExtensions())[0].getConfigurationElements()).length != 0) {
            try {
                return (IProcessList)configElements[0].createExecutableExtension("class");
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public String[] getAllErrorParsersIDs() {
        IExtensionPoint extension = this.getDescriptor().getExtensionPoint(ERROR_PARSER_SIMPLE_ID);
        String[] empty = new String[]{};
        if (extension != null) {
            IExtension[] extensions = extension.getExtensions();
            ArrayList<String> list = new ArrayList<String>(extensions.length);
            int i = 0;
            while (i < extensions.length) {
                list.add(extensions[i].getUniqueIdentifier());
                ++i;
            }
            return list.toArray(empty);
        }
        return empty;
    }

    public IErrorParser[] getErrorParser(String id) {
        IErrorParser[] empty = new IErrorParser[]{};
        try {
            IExtensionPoint extension = this.getDescriptor().getExtensionPoint(ERROR_PARSER_SIMPLE_ID);
            if (extension != null) {
                IExtension[] extensions = extension.getExtensions();
                ArrayList<IErrorParser> list = new ArrayList<IErrorParser>(extensions.length);
                int i = 0;
                while (i < extensions.length) {
                    String parserID = extensions[i].getUniqueIdentifier();
                    if (id == null && parserID == null || id != null && parserID.equals(id)) {
                        IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                        int j = 0;
                        while (j < configElements.length) {
                            IErrorParser parser = (IErrorParser)configElements[j].createExecutableExtension("class");
                            list.add(parser);
                            ++j;
                        }
                    }
                    ++i;
                }
                return list.toArray(empty);
            }
        }
        catch (CoreException coreException) {}
        return empty;
    }

    public IScannerInfoProvider getScannerInfoProvider(IProject project) {
        IScannerInfoProvider provider = null;
        if (project != null) {
            try {
                ICDescriptor desc = this.getCProjectDescription(project);
                ICExtensionReference[] extensions = desc.get(BUILD_SCANNER_INFO_UNIQ_ID);
                if (extensions.length > 0) {
                    provider = (IScannerInfoProvider)((Object)extensions[0].createExtension());
                }
            }
            catch (CoreException coreException) {}
        }
        return provider;
    }

    public void configurePluginDebugOptions() {
        if (CCorePlugin.getDefault().isDebugging()) {
            String option = Platform.getDebugOption((String)PARSER);
            if (option != null) {
                Util.VERBOSE_PARSER = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)MODEL)) != null) {
                Util.VERBOSE_MODEL = option.equalsIgnoreCase("true");
            }
            boolean indexFlag = false;
            option = Platform.getDebugOption((String)INDEX_MANAGER);
            if (option != null) {
                IndexManager.VERBOSE = indexFlag = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)INDEXER)) != null) {
                AbstractIndexer.VERBOSE = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)SEARCH)) != null) {
                SearchEngine.VERBOSE = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)DELTA)) != null) {
                DeltaProcessor.VERBOSE = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)MATCH_LOCATOR)) != null) {
                MatchLocator.VERBOSE = option.equalsIgnoreCase("true");
            }
            if (indexFlag) {
                JobManager.VERBOSE = true;
            }
        }
    }
}

