/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModelStatus;
import org.eclipse.cdt.core.model.ICModelStatusConstants;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CModelStatus
extends Status
implements ICModelStatus,
ICModelStatusConstants,
IResourceStatus {
    protected ICElement[] fElements = new ICElement[0];
    protected IPath fPath;
    protected String fString;
    protected static final IStatus[] fgEmptyChildren = new IStatus[0];
    protected IStatus[] fChildren = fgEmptyChildren;
    public static final ICModelStatus VERIFIED_OK = new CModelStatus(0, 0, Util.bind("status.OK"));

    public CModelStatus() {
        super(4, "org.eclipse.cdt.core", 0, "CModelStatus", null);
    }

    public CModelStatus(int code) {
        super(4, "org.eclipse.cdt.core", code, "CModelStatus", null);
        this.fElements = CElementInfo.fgEmptyChildren;
    }

    public CModelStatus(int code, ICElement[] elements) {
        super(4, "org.eclipse.cdt.core", code, "CModelStatus", null);
        this.fElements = elements;
        this.fPath = null;
    }

    public CModelStatus(int code, String string) {
        this(4, code, string);
    }

    public CModelStatus(int severity, int code, String string) {
        super(severity, "org.eclipse.cdt.core", code, "CModelStatus", null);
        this.fElements = CElementInfo.fgEmptyChildren;
        this.fPath = null;
        this.fString = string;
    }

    public CModelStatus(int code, Throwable throwable) {
        super(4, "org.eclipse.cdt.core", code, "CModelStatus", throwable);
        this.fElements = CElementInfo.fgEmptyChildren;
    }

    public CModelStatus(int code, IPath path) {
        super(4, "org.eclipse.cdt.core", code, "CModelStatus", null);
        this.fElements = CElementInfo.fgEmptyChildren;
        this.fPath = path;
    }

    public CModelStatus(int code, ICElement element) {
        this(code, new ICElement[]{element});
    }

    public CModelStatus(int code, ICElement element, String string) {
        this(code, new ICElement[]{element});
        this.fString = string;
    }

    public CModelStatus(int code, ICElement element, IPath path) {
        this(code, new ICElement[]{element});
        this.fPath = path;
    }

    public CModelStatus(CoreException coreException) {
        super(4, "org.eclipse.cdt.core", 966, "CModelStatus", (Throwable)coreException);
    }

    protected int getBits() {
        int severity = 1 << this.getCode() % 100 / 33;
        int category = 1 << this.getCode() / 100 + 3;
        return severity | category;
    }

    public IStatus[] getChildren() {
        return this.fChildren;
    }

    public ICElement[] getElements() {
        return this.fElements;
    }

    public String getMessage() {
        return "Error in C Plugin";
    }

    public IPath getPath() {
        return this.fPath;
    }

    public int getSeverity() {
        if (this.fChildren == fgEmptyChildren) {
            return super.getSeverity();
        }
        int severity = -1;
        int i = 0;
        int max = this.fChildren.length;
        while (i < max) {
            int childrenSeverity = this.fChildren[i].getSeverity();
            if (childrenSeverity > severity) {
                severity = childrenSeverity;
            }
            ++i;
        }
        return severity;
    }

    public String getString() {
        return this.fString;
    }

    public boolean doesNotExist() {
        return this.getCode() == 969;
    }

    public boolean isMultiStatus() {
        return this.fChildren != fgEmptyChildren;
    }

    public boolean isOK() {
        return this.getCode() == 0;
    }

    public boolean matches(int mask) {
        if (!this.isMultiStatus()) {
            return this.matches(this, mask);
        }
        int i = 0;
        int max = this.fChildren.length;
        while (i < max) {
            if (this.matches((CModelStatus)this.fChildren[i], mask)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean matches(CModelStatus status, int mask) {
        int severityMask = mask & 7;
        int categoryMask = mask & 0xFFFFFFF8;
        int bits = status.getBits();
        return !(severityMask != 0 && (bits & severityMask) == 0 || categoryMask != 0 && (bits & categoryMask) == 0);
    }

    public static ICModelStatus newMultiStatus(ICModelStatus[] children) {
        CModelStatus jms = new CModelStatus();
        jms.fChildren = children;
        return jms;
    }

    public String toString() {
        if (this == VERIFIED_OK) {
            return "CModelStatus[OK]";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("C Model Status [");
        buffer.append(this.getMessage());
        buffer.append("]");
        return buffer.toString();
    }
}

