/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModelStatus;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CModelOperation;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public abstract class CreateElementInTUOperation
extends CModelOperation {
    protected static final int INSERT_LAST = 1;
    protected static final int INSERT_AFTER = 2;
    protected static final int INSERT_BEFORE = 3;
    protected int fInsertionPolicy = 1;
    protected ISourceReference fCreatedElement = null;
    protected ICElement fAnchorElement = null;
    protected boolean fCreationOccurred = true;
    protected int fInsertionPosition = -1;
    protected int fReplacementLength = -1;

    public CreateElementInTUOperation(ICElement parentElement) {
        super(null, new ICElement[]{parentElement});
        this.initializeDefaultPosition();
    }

    protected void checkCanceled() {
        if (!this.fNested) {
            super.checkCanceled();
        }
    }

    public void createAfter(ICElement sibling) {
        this.setRelativePosition(sibling, 2);
    }

    public void createBefore(ICElement sibling) {
        this.setRelativePosition(sibling, 3);
    }

    protected void executeOperation() throws CModelException {
        this.beginTask(this.getMainTaskName(), this.getMainAmountOfWork());
        CElementDelta delta = this.newCElementDelta();
        ITranslationUnit unit = this.getTranslationUnit();
        this.insertElement();
        if (this.fCreationOccurred) {
            IBuffer buffer = unit.getBuffer();
            if (buffer == null) {
                return;
            }
            char[] bufferContents = buffer.getCharacters();
            if (bufferContents == null) {
                return;
            }
            char[] elementContents = this.fCreatedElement.getSource().toCharArray();
            switch (this.fReplacementLength) {
                case -1: {
                    buffer.append(elementContents);
                    break;
                }
                case 0: {
                    buffer.replace(this.fInsertionPosition, 0, elementContents);
                    break;
                }
                default: {
                    buffer.replace(this.fInsertionPosition, this.fReplacementLength, this.fCreatedElement.getSource());
                }
            }
            unit.save(null, false);
            boolean isWorkingCopy = unit.isWorkingCopy();
            this.worked(1);
            this.fResultElements = this.generateResultHandles();
            if (!isWorkingCopy && unit.getParent().exists()) {
                int i = 0;
                while (i < this.fResultElements.length) {
                    delta.added(this.fResultElements[i]);
                    ++i;
                }
                this.addDelta(delta);
            }
        }
        this.done();
    }

    protected abstract ICElement generateResultHandle();

    protected ICElement[] generateResultHandles() throws CModelException {
        return new ICElement[]{this.generateResultHandle()};
    }

    protected ITranslationUnit getTranslationUnit() {
        return ((ISourceReference)((Object)this.getParentElement())).getTranslationUnit();
    }

    protected int getMainAmountOfWork() {
        return 2;
    }

    protected abstract String getMainTaskName();

    public ICElement[] getResultElements() {
        return this.fResultElements;
    }

    protected void initializeDefaultPosition() {
    }

    protected void insertElement() throws CModelException {
        if (this.fInsertionPolicy != 1) {
            ISourceRange range = ((ISourceReference)((Object)this.fAnchorElement)).getSourceRange();
            switch (this.fInsertionPolicy) {
                case 2: {
                    this.fReplacementLength = 0;
                    this.fInsertionPosition = range.getStartPos() + range.getLength();
                    break;
                }
                case 3: {
                    this.fReplacementLength = 0;
                    this.fInsertionPosition = range.getStartPos();
                }
                default: {
                    this.fReplacementLength = range.getStartPos() + range.getLength();
                    this.fInsertionPosition = range.getStartPos();
                }
            }
            return;
        }
        this.fReplacementLength = -1;
    }

    protected void setAlteredName(String newName) {
    }

    protected void setRelativePosition(ICElement sibling, int policy) throws IllegalArgumentException {
        if (sibling == null) {
            this.fAnchorElement = null;
            this.fInsertionPolicy = 1;
        } else {
            this.fAnchorElement = sibling;
            this.fInsertionPolicy = policy;
        }
    }

    public ICModelStatus verify() {
        ICElement domPresentParent;
        if (this.getParentElement() == null) {
            return new CModelStatus(968);
        }
        if (this.fAnchorElement != null && !(domPresentParent = this.fAnchorElement.getParent()).equals(this.getParentElement())) {
            return new CModelStatus(993, this.fAnchorElement);
        }
        return CModelStatus.VERIFIED_OK;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    StringBuffer getContent(IFile file) throws CModelException {
        StringBuffer stringBuffer;
        BufferedInputStream stream = null;
        try {
            stream = new BufferedInputStream(file.getContents(true));
        }
        catch (CoreException e) {
            throw new CModelException(e);
        }
        try {
            try {
                char[] b = CreateElementInTUOperation.getInputStreamAsCharArray(stream, -1, null);
                stringBuffer = new StringBuffer(b.length).append(b);
                Object var4_7 = null;
            }
            catch (IOException e) {
                throw new CModelException(e, 985);
            }
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            try {
                if (stream == null) throw throwable;
                ((InputStream)stream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {}
        if (stream == null) return stringBuffer;
        ((InputStream)stream).close();
        return stringBuffer;
    }

    public static char[] getInputStreamAsCharArray(InputStream stream, int length, String encoding) throws IOException {
        char[] contents;
        InputStreamReader reader = null;
        InputStreamReader inputStreamReader = reader = encoding == null ? new InputStreamReader(stream) : new InputStreamReader(stream, encoding);
        if (length == -1) {
            contents = new char[]{};
            int contentsLength = 0;
            int charsRead = -1;
            do {
                int available;
                if (contentsLength + (available = stream.available()) > contents.length) {
                    char[] cArray = contents;
                    contents = new char[contentsLength + available];
                    System.arraycopy(cArray, 0, contents, 0, contentsLength);
                }
                if ((charsRead = reader.read(contents, contentsLength, available)) <= 0) continue;
                contentsLength += charsRead;
            } while (charsRead > 0);
            if (contentsLength < contents.length) {
                char[] cArray = contents;
                contents = new char[contentsLength];
                System.arraycopy(cArray, 0, contents, 0, contentsLength);
            }
        } else {
            contents = new char[length];
            int len = 0;
            int readSize = 0;
            while (readSize != -1 && len != length) {
                readSize = reader.read(contents, len += readSize, length - len);
            }
            if (len != length) {
                char[] cArray = contents;
                contents = new char[len];
                System.arraycopy(cArray, 0, contents, 0, len);
            }
        }
        return contents;
    }

    void save(StringBuffer buffer, IFile file) throws CModelException {
        byte[] bytes = buffer.toString().getBytes();
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        try {
            boolean force = true;
            file.setContents((InputStream)stream, force, true, null);
        }
        catch (CoreException e) {
            throw new CModelException(e);
        }
    }
}

