/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.core.runtime.IConfigurationElement;

public class Option
extends BuildObject
implements IOption {
    private static final String EMPTY_STRING = new String();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private List builtIns;
    private IOptionCategory category;
    private String command;
    private String defaultEnumName;
    private Map enumCommands;
    private ITool tool;
    private Object value;
    private int valueType;

    public Option(ITool tool) {
        this.tool = tool;
    }

    public Option(Tool tool, IConfigurationElement element) {
        this(tool);
        this.setId(element.getAttribute("id"));
        tool.addOption(this);
        this.setName(element.getAttribute("name"));
        String categoryId = element.getAttribute("category");
        if (categoryId != null) {
            this.setCategory(tool.getOptionCategory(categoryId));
        }
        this.command = element.getAttribute("command");
        String valueTypeStr = element.getAttribute("valueType");
        this.valueType = valueTypeStr == null ? -1 : (valueTypeStr.equals("string") ? 2 : (valueTypeStr.equals("stringList") ? 3 : (valueTypeStr.equals("boolean") ? 0 : (valueTypeStr.equals("enumerated") ? 1 : (valueTypeStr.equals("includePath") ? 4 : (valueTypeStr.equals("libs") ? 6 : (valueTypeStr.equals("userObjs") ? 7 : 5)))))));
        this.enumCommands = new HashMap();
        switch (this.valueType) {
            case 0: {
                this.value = new Boolean(element.getAttribute("defaultValue"));
                break;
            }
            case 2: {
                this.value = element.getAttribute("defaultValue");
                break;
            }
            case 1: {
                ArrayList<String> enumList = new ArrayList<String>();
                IConfigurationElement[] enumElements = element.getChildren("enumeratedOptionValue");
                int i = 0;
                while (i < enumElements.length) {
                    String optName = enumElements[i].getAttribute("name");
                    String optCommand = enumElements[i].getAttribute("command");
                    enumList.add(optName);
                    this.enumCommands.put(optName, optCommand);
                    Boolean isDefault = new Boolean(enumElements[i].getAttribute("isDefault"));
                    if (isDefault.booleanValue()) {
                        this.defaultEnumName = optName;
                    }
                    ++i;
                }
                this.value = enumList;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                ArrayList<String> valueList = new ArrayList<String>();
                this.builtIns = new ArrayList();
                IConfigurationElement[] valueElements = element.getChildren("listOptionValue");
                int i = 0;
                while (i < valueElements.length) {
                    IConfigurationElement valueElement = valueElements[i];
                    Boolean isBuiltIn = new Boolean(valueElement.getAttribute("builtIn"));
                    if (isBuiltIn.booleanValue()) {
                        this.builtIns.add(valueElement.getAttribute("value"));
                    } else {
                        valueList.add(valueElement.getAttribute("value"));
                    }
                    ++i;
                }
                this.value = valueList;
                break;
            }
        }
    }

    public String[] getApplicableValues() {
        List enumValues = (List)this.value;
        return enumValues != null ? enumValues.toArray(new String[enumValues.size()]) : EMPTY_STRING_ARRAY;
    }

    public boolean getBooleanValue() {
        Boolean bool = (Boolean)this.value;
        return bool;
    }

    public String[] getBuiltIns() {
        return this.builtIns == null ? EMPTY_STRING_ARRAY : this.builtIns.toArray(new String[this.builtIns.size()]);
    }

    public IOptionCategory getCategory() {
        return this.category != null ? this.category : this.getTool().getTopOptionCategory();
    }

    public String getCommand() {
        return this.command;
    }

    public String[] getDefinedSymbols() throws BuildException {
        if (this.valueType != 5) {
            throw new BuildException("bad value type");
        }
        ArrayList v = (ArrayList)this.value;
        if (v == null) {
            return EMPTY_STRING_ARRAY;
        }
        v.trimToSize();
        return v.toArray(new String[v.size()]);
    }

    public String getEnumCommand(String name) {
        String cmd = (String)this.enumCommands.get(name);
        return cmd == null ? EMPTY_STRING : cmd;
    }

    public String[] getIncludePaths() throws BuildException {
        if (this.valueType != 4) {
            throw new BuildException("bad value type");
        }
        ArrayList v = (ArrayList)this.value;
        if (v == null) {
            return EMPTY_STRING_ARRAY;
        }
        v.trimToSize();
        return v.toArray(new String[v.size()]);
    }

    public String[] getLibraries() throws BuildException {
        if (this.valueType != 6) {
            throw new BuildException("bad value type");
        }
        ArrayList v = (ArrayList)this.value;
        if (v == null) {
            return EMPTY_STRING_ARRAY;
        }
        v.trimToSize();
        return v.toArray(new String[v.size()]);
    }

    public String getSelectedEnum() throws BuildException {
        if (this.valueType != 1) {
            throw new BuildException("bad value type");
        }
        return this.defaultEnumName == null ? EMPTY_STRING : this.defaultEnumName;
    }

    public String[] getStringListValue() throws BuildException {
        if (this.valueType != 3) {
            throw new BuildException("bad value type");
        }
        ArrayList v = (ArrayList)this.value;
        if (v == null) {
            return EMPTY_STRING_ARRAY;
        }
        v.trimToSize();
        return v.toArray(new String[v.size()]);
    }

    public String getStringValue() throws BuildException {
        if (this.valueType != 2) {
            throw new BuildException("bad value type");
        }
        return this.value == null ? EMPTY_STRING : (String)this.value;
    }

    public ITool getTool() {
        return this.tool;
    }

    public String[] getUserObjects() throws BuildException {
        if (this.valueType != 7) {
            throw new BuildException("bad value type");
        }
        ArrayList v = (ArrayList)this.value;
        if (v == null) {
            return EMPTY_STRING_ARRAY;
        }
        v.trimToSize();
        return v.toArray(new String[v.size()]);
    }

    public int getValueType() {
        return this.valueType;
    }

    public void setCategory(IOptionCategory category) {
        this.category = category;
    }

    public IOption setValue(IConfiguration config, String value) throws BuildException {
        if (this.valueType != 2 || this.valueType != 1) {
            throw new BuildException("Bad value for type");
        }
        if (config == null) {
            this.value = value;
            return this;
        }
        return null;
    }

    public IOption setValue(IConfiguration config, String[] value) throws BuildException {
        if (this.valueType != 3 || this.valueType != 4 || this.valueType != 5 || this.valueType != 6 || this.valueType != 7) {
            throw new BuildException("Bad value for type");
        }
        if (config == null) {
            this.value = value;
            return this;
        }
        return null;
    }
}

