/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.editors;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.internal.ui.editors.EditorInputDelegate;
import org.eclipse.cdt.debug.internal.ui.editors.FileNotFoundElement;
import org.eclipse.cdt.debug.internal.ui.wizards.AddDirectorySourceLocationWizard;
import org.eclipse.cdt.debug.internal.ui.wizards.AddSourceLocationWizard;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.util.ExternalEditorInput;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class CDebugEditor
extends CEditor {
    public static final String EDITOR_ID = String.valueOf(CDebugUIPlugin.getUniqueIdentifier()) + ".editor.CDebugEditor";
    private AttachSourceForm fAttachSourceForm = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CDebugEditor() {
        this.setDocumentProvider((IDocumentProvider)CUIPlugin.getDefault().getDocumentProvider());
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        IEditorInput oldInput;
        IEditorInput newInput = input;
        if (input instanceof EditorInputDelegate && ((EditorInputDelegate)input).getDelegate() != null) {
            newInput = ((EditorInputDelegate)input).getDelegate();
        }
        if ((oldInput = this.getEditorInput()) instanceof EditorInputDelegate) {
            oldInput = ((EditorInputDelegate)oldInput).getDelegate();
        }
        if (oldInput != null) {
            CUIPlugin.getDefault().getWorkingCopyManager().disconnect(oldInput);
        }
        super.doSetInput(newInput);
        CUIPlugin.getDefault().getWorkingCopyManager().connect(newInput);
    }

    protected void attachSourceLocation() {
        if (this.getEditorInput() != null) {
            IEditorInput iEditorInput = this.getEditorInput();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.cdt.debug.internal.ui.editors.FileNotFoundElement;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (iEditorInput.getAdapter((Class)clazz) != null) {
                FileNotFoundElement element;
                IEditorInput iEditorInput2 = this.getEditorInput();
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("[Lorg.eclipse.cdt.debug.internal.ui.editors.FileNotFoundElement;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((element = (FileNotFoundElement)iEditorInput2.getAdapter((Class)clazz2)).getLaunch() != null && element.getLaunch().getSourceLocator() instanceof IAdaptable) {
                    ICSourceLocator locator;
                    ILaunch launch = element.getLaunch();
                    IAdaptable iAdaptable = (IAdaptable)element.getLaunch().getSourceLocator();
                    Class<?> clazz3 = class$1;
                    if (clazz3 == null) {
                        try {
                            clazz3 = class$1 = Class.forName("[Lorg.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;").getComponentType();
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((locator = (ICSourceLocator)iAdaptable.getAdapter((Class)clazz3)) != null) {
                        IPath path = element.getFullPath();
                        Wizard wizard = null;
                        if (path.isAbsolute()) {
                            path = path.removeLastSegments(1);
                            wizard = new AddDirectorySourceLocationWizard(path);
                        } else {
                            wizard = new AddSourceLocationWizard(locator.getSourceLocations());
                        }
                        WizardDialog dialog = new WizardDialog(CDebugUIPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
                        if (dialog.open() == 0) {
                            ICSourceLocation[] locations = locator.getSourceLocations();
                            ArrayList<ICSourceLocation> list = new ArrayList<ICSourceLocation>(Arrays.asList(locations));
                            list.add(wizard.getSourceLocation());
                            locator.setSourceLocations(list.toArray(new ICSourceLocation[list.size()]));
                            if (locator instanceof IPersistableSourceLocator) {
                                ILaunchConfiguration configuration = launch.getLaunchConfiguration();
                                this.saveChanges(configuration, (IPersistableSourceLocator)launch.getSourceLocator());
                            }
                            Object newElement = locator.getSourceElement(element.getStackFrame());
                            FileEditorInput newInput = null;
                            if (newElement instanceof IFile) {
                                newInput = new FileEditorInput((IFile)newElement);
                            } else if (newElement instanceof FileStorage) {
                                newInput = new ExternalEditorInput((IStorage)newElement);
                            }
                            IEditorInput oldInput = ((EditorInputDelegate)this.getEditorInput()).getDelegate();
                            CUIPlugin.getDefault().getWorkingCopyManager().disconnect(oldInput);
                            ((EditorInputDelegate)this.getEditorInput()).setDelegate((IEditorInput)newInput);
                            this.resetInput(element.getStackFrame());
                        }
                    }
                }
            }
        }
    }

    private void resetInput(IStackFrame frame) {
        this.setInput(this.getEditorInput());
        IViewPart view = CDebugUIPlugin.getActivePage().findView("org.eclipse.debug.ui.DebugView");
        if (view instanceof IDebugView) {
            ((IDebugView)view).getViewer().setSelection((ISelection)new StructuredSelection((Object)frame));
        }
    }

    protected void saveChanges(ILaunchConfiguration configuration, IPersistableSourceLocator locator) {
        try {
            ILaunchConfigurationWorkingCopy copy = configuration.copy(configuration.getName());
            copy.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, locator.getMemento());
            copy.doSave();
        }
        catch (CoreException e) {
            CDebugUIPlugin.errorDialog(e.getMessage(), null);
        }
    }

    protected Control createStatusControl(Composite parent, IStatus status) {
        this.fAttachSourceForm = new AttachSourceForm(parent, this.getEditorInput());
        return this.fAttachSourceForm.getControl();
    }

    public void updatePartControl(IEditorInput input) {
        if (this.fAttachSourceForm != null) {
            if (this.fAttachSourceForm.getInput() != null && !this.fAttachSourceForm.getInput().equals(input)) {
                this.fAttachSourceForm = null;
                super.updatePartControl(input);
            }
        } else {
            super.updatePartControl(input);
        }
    }

    public void dispose() {
        IEditorInput input;
        IEditorInput newInput = input = this.getEditorInput();
        if (input instanceof EditorInputDelegate && ((EditorInputDelegate)input).getDelegate() != null) {
            newInput = ((EditorInputDelegate)input).getDelegate();
        }
        CUIPlugin.getDefault().getWorkingCopyManager().disconnect(newInput);
        super.dispose();
    }

    public class AttachSourceForm
    implements IPropertyChangeListener {
        private static final int HORIZONTAL_SCROLL_INCREMENT = 10;
        private static final int VERTICAL_SCROLL_INCREMENT = 10;
        private Font fFont;
        private ScrolledComposite fScrolledComposite;
        private Color fBackgroundColor;
        private Color fForegroundColor;
        private Color fSeparatorColor;
        private List fHeaderLabels = new ArrayList();
        private List fBannerLabels = new ArrayList();
        private Label fInputLabel;
        private Button fAttachButton = null;
        private IEditorInput fInput = null;
        static /* synthetic */ Class class$0;

        public AttachSourceForm(Composite parent, IEditorInput input) {
            Display display = parent.getDisplay();
            this.fBackgroundColor = display.getSystemColor(25);
            this.fForegroundColor = display.getSystemColor(24);
            this.fSeparatorColor = new Color((Device)display, 152, 170, 203);
            JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
            this.fScrolledComposite = new ScrolledComposite(parent, 768);
            this.fScrolledComposite.setAlwaysShowScrollBars(false);
            this.fScrolledComposite.setExpandHorizontal(true);
            this.fScrolledComposite.setExpandVertical(true);
            this.fScrolledComposite.addDisposeListener(new DisposeListener(this){
                final /* synthetic */ AttachSourceForm this$1;
                {
                    this.this$1 = attachSourceForm;
                }

                public void widgetDisposed(DisposeEvent e) {
                    JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this.this$1);
                    this.this$1.setScrolledComposite(null);
                    this.this$1.getSeparatorColor().dispose();
                    this.this$1.setSeparatorColor(null);
                    this.this$1.getBannerLabels().clear();
                    this.this$1.getHeaderLabels().clear();
                    if (this.this$1.getFont() != null) {
                        this.this$1.getFont().dispose();
                        this.this$1.setFont(null);
                    }
                }
            });
            this.fScrolledComposite.addControlListener(new ControlListener(this){
                final /* synthetic */ AttachSourceForm this$1;
                {
                    this.this$1 = attachSourceForm;
                }

                public void controlMoved(ControlEvent e) {
                }

                public void controlResized(ControlEvent e) {
                    Rectangle clientArea = this.this$1.getScrolledComposite().getClientArea();
                    ScrollBar verticalBar = this.this$1.getScrolledComposite().getVerticalBar();
                    verticalBar.setIncrement(10);
                    verticalBar.setPageIncrement(clientArea.height - verticalBar.getIncrement());
                    ScrollBar horizontalBar = this.this$1.getScrolledComposite().getHorizontalBar();
                    horizontalBar.setIncrement(10);
                    horizontalBar.setPageIncrement(clientArea.width - horizontalBar.getIncrement());
                }
            });
            Composite composite = this.createComposite((Composite)this.fScrolledComposite);
            composite.setLayout((Layout)new GridLayout());
            this.createTitleLabel(composite, "C/C++ File Editor");
            this.createLabel(composite, null);
            this.createLabel(composite, null);
            this.createHeadingLabel(composite, "Source not found");
            Composite separator = this.createCompositeSeparator(composite);
            GridData data = new GridData(768);
            data.heightHint = 2;
            separator.setLayoutData((Object)data);
            this.fInputLabel = this.createLabel(composite, "");
            this.createLabel(composite, "You can attach a new source location by pressing the button below:");
            this.createLabel(composite, null);
            this.fAttachButton = this.createButton(composite, "&Attach Source...");
            this.fAttachButton.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ AttachSourceForm this$1;
                {
                    this.this$1 = attachSourceForm;
                }

                public void widgetSelected(SelectionEvent event) {
                    AttachSourceForm.access$0(this.this$1).attachSourceLocation();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            separator = this.createCompositeSeparator(composite);
            data = new GridData(768);
            data.heightHint = 2;
            separator.setLayoutData((Object)data);
            this.fScrolledComposite.setContent((Control)composite);
            this.fScrolledComposite.setMinSize(composite.computeSize(-1, -1));
            if (CDebugEditor.this.getEditorInput() != null) {
                this.setInputLabelText(CDebugEditor.this.getEditorInput());
            }
            this.fInput = input;
        }

        private Composite createComposite(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setBackground(this.fBackgroundColor);
            return composite;
        }

        private Label createLabel(Composite parent, String text) {
            Label label = new Label(parent, 0);
            if (text != null) {
                label.setText(text);
            }
            label.setBackground(this.fBackgroundColor);
            label.setForeground(this.fForegroundColor);
            return label;
        }

        private Label createTitleLabel(Composite parent, String text) {
            Label label = new Label(parent, 0);
            if (text != null) {
                label.setText(text);
            }
            label.setBackground(this.fBackgroundColor);
            label.setForeground(this.fForegroundColor);
            label.setFont(JFaceResources.getHeaderFont());
            this.fHeaderLabels.add(label);
            return label;
        }

        private Label createHeadingLabel(Composite parent, String text) {
            Label label = new Label(parent, 0);
            if (text != null) {
                label.setText(text);
            }
            label.setBackground(this.fBackgroundColor);
            label.setForeground(this.fForegroundColor);
            label.setFont(JFaceResources.getBannerFont());
            this.fBannerLabels.add(label);
            return label;
        }

        private Composite createCompositeSeparator(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setBackground(this.fSeparatorColor);
            return composite;
        }

        private Button createButton(Composite parent, String text) {
            Button button = new Button(parent, 0x800000);
            button.setBackground(this.fBackgroundColor);
            button.setForeground(this.fForegroundColor);
            if (text != null) {
                button.setText(text);
            }
            return button;
        }

        public void propertyChange(PropertyChangeEvent event) {
            Label label;
            Iterator iterator = this.fBannerLabels.iterator();
            while (iterator.hasNext()) {
                label = (Label)iterator.next();
                label.setFont(JFaceResources.getBannerFont());
            }
            iterator = this.fHeaderLabels.iterator();
            while (iterator.hasNext()) {
                label = (Label)iterator.next();
                label.setFont(JFaceResources.getHeaderFont());
            }
            Control control = this.fScrolledComposite.getContent();
            this.fScrolledComposite.setMinSize(control.computeSize(-1, -1));
            this.fScrolledComposite.setContent(control);
            this.fScrolledComposite.layout(true);
            this.fScrolledComposite.redraw();
        }

        private void setInputLabelText(IEditorInput input) {
            FileNotFoundElement element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.cdt.debug.internal.ui.editors.FileNotFoundElement;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((element = (FileNotFoundElement)input.getAdapter((Class)clazz)) != null) {
                this.fInputLabel.setText(MessageFormat.format("The debugger can not find the file ''{0}''.", element.getFullPath().toOSString()));
            }
        }

        protected ScrolledComposite getScrolledComposite() {
            return this.fScrolledComposite;
        }

        protected void setScrolledComposite(ScrolledComposite scrolledComposite) {
            this.fScrolledComposite = scrolledComposite;
        }

        protected Color getSeparatorColor() {
            return this.fSeparatorColor;
        }

        protected void setSeparatorColor(Color separatorColor) {
            this.fSeparatorColor = separatorColor;
        }

        protected List getBannerLabels() {
            return this.fBannerLabels;
        }

        protected void setBannerLabels(List bannerLabels) {
            this.fBannerLabels = bannerLabels;
        }

        protected List getHeaderLabels() {
            return this.fHeaderLabels;
        }

        protected void setHeaderLabels(List headerLabels) {
            this.fHeaderLabels = headerLabels;
        }

        protected Font getFont() {
            return this.fFont;
        }

        protected void setFont(Font font) {
            this.fFont = font;
        }

        public Control getControl() {
            return this.fScrolledComposite;
        }

        public IEditorInput getInput() {
            return this.fInput;
        }

        static /* synthetic */ CDebugEditor access$0(AttachSourceForm attachSourceForm) {
            return attachSourceForm.CDebugEditor.this;
        }
    }
}

