/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.internal.core.model.CPathEntry;
import org.eclipse.core.runtime.IPath;

public abstract class ACPathEntry
extends CPathEntry {
    public static IPath[] NO_EXCLUSION_PATTERNS = new IPath[0];
    IPath[] exclusionPatterns;
    boolean isRecursive;

    public ACPathEntry(int kind, boolean isRecursive, IPath[] exclusionPatterns, boolean isExported) {
        super(kind, isExported);
        this.exclusionPatterns = exclusionPatterns;
        this.isRecursive = isRecursive;
    }

    public IPath[] getExclusionPatterns() {
        return this.exclusionPatterns;
    }

    public boolean isRecursive() {
        return this.isRecursive;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ACPathEntry) {
            ACPathEntry otherEntry = (ACPathEntry)obj;
            if (!super.equals(otherEntry)) {
                return false;
            }
            if (this.isRecursive != otherEntry.isRecursive()) {
                return false;
            }
            IPath[] otherExcludes = otherEntry.getExclusionPatterns();
            if (this.exclusionPatterns != otherExcludes) {
                int excludeLength;
                int n = excludeLength = this.exclusionPatterns == null ? 0 : this.exclusionPatterns.length;
                if (otherExcludes.length != excludeLength) {
                    return false;
                }
                int i = 0;
                while (i < excludeLength) {
                    String myPattern = this.exclusionPatterns[i].toString();
                    if (!myPattern.equals(otherExcludes[i].toString())) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }
        return super.equals(obj);
    }
}

