/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.processing;

import org.eclipse.cdt.core.ICLogConstants;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.internal.core.search.processing.IJob;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class JobManager
implements Runnable {
    protected IJob[] awaitingJobs = new IJob[10];
    protected int jobStart = 0;
    protected int jobEnd = -1;
    protected boolean executing = false;
    protected Thread thread;
    private boolean enabled = true;
    public static boolean VERBOSE = false;
    public boolean activated = false;
    private int awaitingClients = 0;

    public static void verbose(String log) {
        System.out.println("(" + Thread.currentThread() + ") " + log);
    }

    public void activateProcessing() {
        this.activated = true;
    }

    public synchronized int awaitingJobsCount() {
        if (!this.activated) {
            return 1;
        }
        return this.jobEnd - this.jobStart + 1;
    }

    public synchronized IJob currentJob() {
        if (!this.enabled) {
            return null;
        }
        if (this.jobStart <= this.jobEnd) {
            return this.awaitingJobs[this.jobStart];
        }
        return null;
    }

    public synchronized void disable() {
        this.enabled = false;
        if (VERBOSE) {
            JobManager.verbose("DISABLING background indexing");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void discardJobs(String jobFamily) {
        block21: {
            if (VERBOSE) {
                JobManager.verbose("DISCARD   background job family - " + jobFamily);
            }
            boolean wasEnabled = this.isEnabled();
            try {
                IJob currentJob;
                JobManager jobManager = this;
                synchronized (jobManager) {
                    currentJob = this.currentJob();
                    this.disable();
                }
                if (currentJob != null && (jobFamily == null || currentJob.belongsTo(jobFamily))) {
                    currentJob.cancel();
                    while (this.thread != null && this.executing) {
                        try {
                            if (VERBOSE) {
                                JobManager.verbose("-> waiting end of current background job - " + currentJob);
                            }
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                int loc = -1;
                JobManager jobManager2 = this;
                synchronized (jobManager2) {
                    int i = this.jobStart;
                    while (true) {
                        block22: {
                            if (i <= this.jobEnd) break block22;
                            this.jobStart = 0;
                            this.jobEnd = loc;
                            break;
                        }
                        currentJob = this.awaitingJobs[i];
                        this.awaitingJobs[i] = null;
                        if (jobFamily != null && !currentJob.belongsTo(jobFamily)) {
                            this.awaitingJobs[++loc] = currentJob;
                        } else {
                            if (VERBOSE) {
                                JobManager.verbose("-> discarding background job  - " + currentJob);
                            }
                            currentJob.cancel();
                        }
                        ++i;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (wasEnabled) {
                    this.enable();
                }
                throw throwable;
            }
            {
                Object var7_10 = null;
                if (wasEnabled) {
                    this.enable();
                }
                if (!VERBOSE) break block21;
            }
            JobManager.verbose("DISCARD   DONE with background job family - " + jobFamily);
        }
    }

    public synchronized void enable() {
        this.enabled = true;
        if (VERBOSE) {
            JobManager.verbose("ENABLING  background indexing");
        }
    }

    public synchronized boolean isEnabled() {
        return this.enabled;
    }

    protected synchronized void moveToNextJob() {
        if (this.jobStart <= this.jobEnd) {
            this.awaitingJobs[this.jobStart++] = null;
            if (this.jobStart > this.jobEnd) {
                this.jobStart = 0;
                this.jobEnd = -1;
            }
        }
    }

    protected void notifyIdle(long idlingTime) {
    }

    /*
     * Exception decompiling
     */
    public boolean performConcurrentJob(IJob searchJob, int waitingPolicy, IProgressMonitor progress, IJob jobToIgnore) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 201->204)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean jobShouldBeIgnored(IJob jobToIgnore) {
        if (jobToIgnore == null) {
            return false;
        }
        return this.currentJob() == jobToIgnore;
    }

    public abstract String processName();

    public synchronized void request(IJob job) {
        if (!job.isReadyToRun()) {
            if (VERBOSE) {
                JobManager.verbose("ABORTED request of background job - " + job);
            }
            return;
        }
        int size = this.awaitingJobs.length;
        if (++this.jobEnd == size) {
            this.jobEnd -= this.jobStart;
            this.awaitingJobs = new IJob[size * 2];
            System.arraycopy(this.awaitingJobs, this.jobStart, this.awaitingJobs, 0, this.jobEnd);
            this.jobStart = 0;
        }
        this.awaitingJobs[this.jobEnd] = job;
        if (VERBOSE) {
            JobManager.verbose("REQUEST   background job - " + job);
        }
    }

    public void reset() {
        if (VERBOSE) {
            JobManager.verbose("Reset");
        }
        if (this.thread != null) {
            this.discardJobs(null);
        } else {
            this.thread = new Thread((Runnable)this, this.processName());
            this.thread.setDaemon(true);
            this.thread.setPriority(4);
            this.thread.start();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        long idlingStart = -1L;
        this.activateProcessing();
        try {
            while (true) {
                if (this.thread == null) {
                    return;
                }
                try {
                    Object var4_5;
                    IJob job = this.currentJob();
                    if (job == null) {
                        if (idlingStart < 0L) {
                            idlingStart = System.currentTimeMillis();
                        }
                        this.notifyIdle(System.currentTimeMillis() - idlingStart);
                        Thread.sleep(500L);
                        continue;
                    }
                    idlingStart = -1L;
                    if (VERBOSE) {
                        JobManager.verbose(String.valueOf(this.awaitingJobsCount()) + " awaiting jobs");
                        JobManager.verbose("STARTING background job - " + job);
                    }
                    try {
                        this.executing = true;
                        job.execute(null);
                    }
                    catch (Throwable throwable) {
                        var4_5 = null;
                        this.executing = false;
                        if (VERBOSE) {
                            JobManager.verbose("FINISHED background job - " + job);
                        }
                        this.moveToNextJob();
                        if (this.awaitingClients != 0) throw throwable;
                        Thread.sleep(50L);
                        throw throwable;
                    }
                    {
                        var4_5 = null;
                        this.executing = false;
                        if (VERBOSE) {
                            JobManager.verbose("FINISHED background job - " + job);
                        }
                        this.moveToNextJob();
                        if (this.awaitingClients != 0) continue;
                        Thread.sleep(50L);
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (RuntimeException e) {
            if (this.thread == null) throw e;
            Util.log(e, "Background Indexer Crash Recovery", ICLogConstants.PDE);
            this.discardJobs(null);
            this.thread = null;
            this.reset();
            throw e;
        }
        catch (Error e) {
            if (this.thread == null) throw e;
            if (e instanceof ThreadDeath) throw e;
            Util.log(e, "Background Indexer Crash Recovery", ICLogConstants.PDE);
            this.discardJobs(null);
            this.thread = null;
            this.reset();
            throw e;
        }
    }

    public void shutdown() {
        this.disable();
        this.discardJobs(null);
        Thread thread = this.thread;
        this.thread = null;
        try {
            if (thread != null) {
                thread.join();
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(10);
        buffer.append("Enabled:").append(this.enabled).append('\n');
        int numJobs = this.jobEnd - this.jobStart + 1;
        buffer.append("Jobs in queue:").append(numJobs).append('\n');
        int i = 0;
        while (i < numJobs && i < 15) {
            buffer.append(i).append(" - job[" + i + "]: ").append(this.awaitingJobs[this.jobStart + i]).append('\n');
            ++i;
        }
        return buffer.toString();
    }
}

