/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariableObject;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIArrayValue;
import org.eclipse.cdt.debug.core.model.ICType;
import org.eclipse.cdt.debug.internal.core.model.CArrayPartitionValue;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CModificationVariable;
import org.eclipse.cdt.debug.internal.core.model.CType;
import org.eclipse.cdt.debug.internal.core.model.CVariable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;

public class CArrayPartition
extends CVariable {
    protected static final int SLOT_SIZE = 100;
    private int fStart;
    private int fEnd;
    private ICDIVariableObject fCDIVariableObject;
    private ICDIVariable fCDIVariable;
    private ICType fType = null;
    private String fQualifiedName = null;
    private CArrayPartitionValue fArrayPartitionValue = null;

    public CArrayPartition(CDebugElement parent, ICDIVariable cdiVariable, int start, int end) {
        super(parent, null);
        this.fStart = start;
        this.fEnd = end;
        this.fCDIVariable = cdiVariable;
    }

    protected ICDIValue retrieveValue() throws DebugException, CDIException {
        return null;
    }

    public String getName() throws DebugException {
        StringBuffer name = new StringBuffer();
        name.append('[');
        name.append(this.fStart);
        name.append("..");
        name.append(this.fEnd);
        name.append(']');
        return name.toString();
    }

    public String getReferenceTypeName() throws DebugException {
        return null;
    }

    public void handleDebugEvent(ICDIEvent event) {
    }

    public IValue getValue() throws DebugException {
        if (this.fArrayPartitionValue == null) {
            this.fArrayPartitionValue = new CArrayPartitionValue(this, this.fCDIVariable, this.getStart(), this.getEnd());
        }
        return this.fArrayPartitionValue;
    }

    public static List splitArray(CDebugElement parent, ICDIVariable cdiVariable, int start, int end) throws DebugException {
        ArrayList<CVariable> children;
        block8: {
            children = new ArrayList<CVariable>();
            int len = end - start + 1;
            int perSlot = 1;
            while (len > perSlot * 100) {
                perSlot *= 100;
            }
            if (perSlot == 1) {
                try {
                    ICDIValue value = cdiVariable.getValue();
                    if (!(value instanceof ICDIArrayValue)) break block8;
                    ICDIVariable[] cdiVars = ((ICDIArrayValue)value).getVariables(start, len);
                    int i = 0;
                    while (i < cdiVars.length) {
                        children.add(new CModificationVariable(parent, cdiVars[i]));
                        ++i;
                    }
                }
                catch (CDIException e) {
                    children.add(new CModificationVariable(parent, new CVariable.ErrorVariable(null, e)));
                }
            } else {
                int pos = start;
                while (pos <= end) {
                    if (pos + perSlot > end) {
                        perSlot = end - pos + 1;
                    }
                    children.add(new CArrayPartition(parent, cdiVariable, pos, pos + perSlot - 1));
                    pos += perSlot;
                }
            }
        }
        return children;
    }

    protected int getStart() {
        return this.fStart;
    }

    protected int getEnd() {
        return this.fEnd;
    }

    public boolean canEnableDisable() {
        return false;
    }

    public ICType getType() throws DebugException {
        if (this.fType == null) {
            try {
                ICDIVariableObject varObject = this.getVariableObject();
                if (varObject != null) {
                    this.fType = new CType(varObject.getType());
                }
            }
            catch (CDIException e) {
                this.requestFailed("Type is not available.", e);
            }
        }
        return this.fType;
    }

    public boolean hasChildren() {
        return true;
    }

    protected String getQualifiedName() throws DebugException {
        if (this.fQualifiedName == null) {
            try {
                if (this.getVariableObject() != null) {
                    this.fQualifiedName = this.getVariableObject().getQualifiedName();
                }
            }
            catch (CDIException e) {
                this.requestFailed("Qualified name is not available.", e);
            }
        }
        return this.fQualifiedName;
    }

    private ICDIVariableObject getVariableObject() throws CDIException {
        if (this.fCDIVariableObject == null) {
            this.fCDIVariableObject = this.getCDISession().getVariableManager().getVariableObjectAsArray(this.fCDIVariable, this.getStart(), this.getEnd() - this.getStart() + 1);
        }
        return this.fCDIVariableObject;
    }
}

