/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTInitializerClause;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.internal.core.parser.ast.ASTQualifiedNamedElement;
import org.eclipse.cdt.internal.core.parser.ast.NamedOffsets;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTReferenceStore;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;

public class ASTVariable
extends ASTSymbol
implements IASTVariable {
    private final boolean previouslyDeclared;
    private final IASTExpression constructorExpression;
    protected final ASTReferenceStore referenceDelegate;
    private final ASTQualifiedNamedElement qualifiedName;
    private NamedOffsets offsets = new NamedOffsets();
    private final IASTExpression bitfieldExpression;
    private final IASTInitializerClause initializerClause;
    private final IASTAbstractDeclaration abstractDeclaration;

    public ASTVariable(ISymbol newSymbol, IASTAbstractDeclaration abstractDeclaration, IASTInitializerClause initializerClause, IASTExpression bitfieldExpression, int startingOffset, int nameOffset, int nameEndOffset, List references, IASTExpression constructorExpression, boolean previouslyDeclared) {
        super(newSymbol);
        this.abstractDeclaration = abstractDeclaration;
        this.initializerClause = initializerClause;
        this.bitfieldExpression = bitfieldExpression;
        this.constructorExpression = constructorExpression;
        this.setStartingOffset(startingOffset);
        this.setNameOffset(nameOffset);
        this.setNameEndOffset(nameEndOffset);
        this.referenceDelegate = new ASTReferenceStore(references);
        this.qualifiedName = new ASTQualifiedNamedElement(this.getOwnerScope(), newSymbol.getName());
        this.previouslyDeclared = previouslyDeclared;
    }

    public boolean isAuto() {
        return this.symbol.getTypeInfo().checkBit(32);
    }

    public boolean isRegister() {
        return this.symbol.getTypeInfo().checkBit(64);
    }

    public boolean isStatic() {
        return this.symbol.getTypeInfo().checkBit(128);
    }

    public boolean isExtern() {
        return this.symbol.getTypeInfo().checkBit(256);
    }

    public boolean isMutable() {
        return this.symbol.getTypeInfo().checkBit(512);
    }

    public IASTAbstractDeclaration getAbstractDeclaration() {
        return this.abstractDeclaration;
    }

    public String getName() {
        return this.getSymbol().getName();
    }

    public IASTInitializerClause getInitializerClause() {
        return this.initializerClause;
    }

    public boolean isBitfield() {
        return this.bitfieldExpression != null;
    }

    public IASTExpression getBitfieldExpression() {
        return this.bitfieldExpression;
    }

    public int getNameOffset() {
        return this.offsets.getNameOffset();
    }

    public void setNameOffset(int o) {
        this.offsets.setNameOffset(o);
    }

    public String[] getFullyQualifiedName() {
        return this.qualifiedName.getFullyQualifiedName();
    }

    public IASTScope getOwnerScope() {
        return (IASTScope)((Object)this.getSymbol().getContainingSymbol().getASTExtension().getPrimaryDeclaration());
    }

    public void acceptElement(ISourceElementRequestor requestor) {
        try {
            requestor.acceptVariable(this);
        }
        catch (Exception exception) {}
        this.referenceDelegate.processReferences(requestor);
        if (this.initializerClause != null) {
            this.initializerClause.acceptElement(requestor);
        }
        if (this.constructorExpression != null) {
            this.constructorExpression.acceptElement(requestor);
        }
        if (this.getAbstractDeclaration() != null) {
            this.getAbstractDeclaration().acceptElement(requestor);
        }
    }

    public void enterScope(ISourceElementRequestor requestor) {
    }

    public void exitScope(ISourceElementRequestor requestor) {
    }

    public void setStartingOffset(int o) {
        this.offsets.setStartingOffset(o);
    }

    public void setEndingOffset(int o) {
        this.offsets.setEndingOffset(o);
    }

    public int getStartingOffset() {
        return this.offsets.getStartingOffset();
    }

    public int getEndingOffset() {
        return this.offsets.getEndingOffset();
    }

    public int getNameEndOffset() {
        return this.offsets.getNameEndOffset();
    }

    public void setNameEndOffset(int o) {
        this.offsets.setNameEndOffset(o);
    }

    public IASTExpression getConstructorExpression() {
        return this.constructorExpression;
    }

    public IASTNode.LookupResult lookup(String prefix, IASTNode.LookupKind kind) {
        return null;
    }
}

