/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ITokenDuple;
import org.eclipse.cdt.core.parser.ast.ASTPointerOperator;
import org.eclipse.cdt.core.parser.ast.ASTSemanticException;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTFactory;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTSimpleTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTemplate;
import org.eclipse.cdt.core.parser.ast.IASTTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.internal.core.parser.Declarator;
import org.eclipse.cdt.internal.core.parser.IDeclaratorOwner;

public class DeclarationWrapper
implements IDeclaratorOwner {
    private boolean imaginary;
    private boolean complex;
    private boolean restrict;
    private int endOffset;
    private ITokenDuple name;
    private IASTSimpleTypeSpecifier.Type simpleType = IASTSimpleTypeSpecifier.Type.UNSPECIFIED;
    private boolean isSigned;
    private boolean isLong;
    private boolean isShort;
    private boolean isUnsigned;
    private final IASTTemplate templateDeclaration;
    private final IASTScope scope;
    private IASTTypeSpecifier typeSpecifier;
    private List declarators = new ArrayList();
    private boolean typeNamed = false;
    private boolean volatil = false;
    private boolean virtual = false;
    private boolean typedef = false;
    private boolean staticc = false;
    private boolean register = false;
    private boolean extern = false;
    private boolean explicit = false;
    private boolean constt = false;
    private int startingOffset = 0;
    private boolean auto = false;
    private boolean mutable = false;
    private boolean friend = false;
    private boolean inline = false;
    private IASTFactory astFactory = null;

    public void setAuto(boolean b) {
        this.auto = b;
    }

    public IASTScope getScope() {
        return this.scope;
    }

    public DeclarationWrapper(IASTScope scope, int startingOffset, IASTTemplate templateDeclaration) {
        this.scope = scope;
        this.startingOffset = startingOffset;
        this.templateDeclaration = templateDeclaration;
    }

    public void setTypenamed(boolean b) {
        this.typeNamed = b;
    }

    public void setMutable(boolean b) {
        this.mutable = b;
    }

    public void setFriend(boolean b) {
        this.friend = b;
    }

    public void setInline(boolean b) {
        this.inline = b;
    }

    public void setRegister(boolean b) {
        this.register = b;
    }

    public void setStatic(boolean b) {
        this.staticc = b;
    }

    public void setTypedef(boolean b) {
        this.typedef = b;
    }

    public void setVirtual(boolean b) {
        this.virtual = b;
    }

    public void setVolatile(boolean b) {
        this.volatil = b;
    }

    public void setExtern(boolean b) {
        this.extern = b;
    }

    public void setExplicit(boolean b) {
        this.explicit = b;
    }

    public void setConst(boolean b) {
        this.constt = b;
    }

    public boolean isAuto() {
        return this.auto;
    }

    public boolean isConst() {
        return this.constt;
    }

    public boolean isExplicit() {
        return this.explicit;
    }

    public boolean isExtern() {
        return this.extern;
    }

    public boolean isFriend() {
        return this.friend;
    }

    public boolean isInline() {
        return this.inline;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public boolean isRegister() {
        return this.register;
    }

    public int getStartingOffset() {
        return this.startingOffset;
    }

    public boolean isStatic() {
        return this.staticc;
    }

    public boolean isTypedef() {
        return this.typedef;
    }

    public boolean isTypeNamed() {
        return this.typeNamed;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public boolean isVolatile() {
        return this.volatil;
    }

    public void addDeclarator(Declarator d) {
        this.declarators.add(d);
    }

    public Iterator getDeclarators() {
        return Collections.unmodifiableList(this.declarators).iterator();
    }

    public IASTTypeSpecifier getTypeSpecifier() {
        return this.typeSpecifier;
    }

    public void setTypeSpecifier(IASTTypeSpecifier specifier) {
        this.typeSpecifier = specifier;
    }

    public List createASTNodes(IASTFactory astFactory) throws ASTSemanticException {
        this.astFactory = astFactory;
        Iterator i = this.declarators.iterator();
        ArrayList<IASTDeclaration> l = new ArrayList<IASTDeclaration>();
        while (i.hasNext()) {
            l.add(this.createASTNode((Declarator)i.next()));
        }
        return l;
    }

    private IASTDeclaration createASTNode(Declarator declarator) throws ASTSemanticException {
        boolean hasInnerDeclarator;
        boolean isWithinClass = this.getScope() instanceof IASTClassSpecifier;
        boolean isFunction = declarator.isFunction();
        boolean bl = hasInnerDeclarator = declarator.getOwnedDeclarator() != null;
        if (hasInnerDeclarator) {
            return this.createIndirectDeclaration(declarator);
        }
        if (this.isTypedef()) {
            return this.createTypedef(declarator, false);
        }
        if (isWithinClass) {
            if (isFunction) {
                return this.createMethodASTNode(declarator, false);
            }
            return this.createFieldASTNode(declarator, false);
        }
        if (isFunction) {
            return this.createFunctionASTNode(declarator, false);
        }
        return this.createVariableASTNode(declarator, false);
    }

    private IASTDeclaration createIndirectDeclaration(Declarator declarator) throws ASTSemanticException {
        if (declarator.getOwnedDeclarator().getOwnedDeclarator() == null) {
            String name;
            Declarator d = declarator.getOwnedDeclarator();
            Iterator i = d.getPointerOperators().iterator();
            if (!i.hasNext()) {
                boolean isFunction;
                boolean isWithinClass = this.scope instanceof IASTClassSpecifier;
                boolean bl = isFunction = declarator.getParameters().size() != 0;
                if (this.isTypedef()) {
                    return this.createTypedef(declarator, true);
                }
                if (isWithinClass) {
                    if (isFunction) {
                        return this.createMethodASTNode(declarator, true);
                    }
                    return this.createFieldASTNode(declarator, true);
                }
                if (isFunction) {
                    return this.createFunctionASTNode(declarator, true);
                }
                return this.createVariableASTNode(declarator, true);
            }
            List convertedParms = this.createParameterList(declarator.getParameters());
            IASTAbstractDeclaration abs = null;
            try {
                abs = this.astFactory.createAbstractDeclaration(this.constt, this.volatil, this.getTypeSpecifier(), declarator.getPointerOperators(), declarator.getArrayModifiers(), convertedParms, (ASTPointerOperator)i.next());
            }
            catch (Exception exception) {
                throw new ASTSemanticException();
            }
            String string = name = d.getPointerOperatorNameDuple() != null ? String.valueOf(d.getPointerOperatorNameDuple().toString()) + d.getName() : d.getName();
            if (this.typedef) {
                try {
                    return this.astFactory.createTypedef(this.scope, name, abs, this.getStartingOffset(), d.getNameStartOffset(), d.getNameEndOffset());
                }
                catch (ASTSemanticException e1) {
                    throw e1;
                }
                catch (Exception exception) {
                    throw new ASTSemanticException();
                }
            }
            try {
                return this.astFactory.createVariable(this.scope, name, this.auto, d.getInitializerClause(), d.getBitFieldExpression(), abs, this.mutable, this.extern, this.register, this.staticc, this.getStartingOffset(), d.getNameStartOffset(), d.getNameEndOffset(), d.getConstructorExpression());
            }
            catch (Exception exception) {
                throw new ASTSemanticException();
            }
        }
        throw new ASTSemanticException();
    }

    private IASTTypedefDeclaration createTypedef(Declarator declarator, boolean nested) throws ASTSemanticException {
        try {
            return this.astFactory.createTypedef(this.scope, nested ? declarator.getOwnedDeclarator().getName() : declarator.getName(), this.astFactory.createAbstractDeclaration(this.constt, this.volatil, this.getTypeSpecifier(), declarator.getPointerOperators(), declarator.getArrayModifiers(), null, null), this.startingOffset, declarator.getNameStartOffset(), declarator.getNameEndOffset());
        }
        catch (ASTSemanticException e) {
            throw e;
        }
        catch (Exception exception) {
            throw new ASTSemanticException();
        }
    }

    private IASTMethod createMethodASTNode(Declarator declarator, boolean nested) throws ASTSemanticException {
        try {
            return this.astFactory.createMethod(this.scope, nested ? declarator.getOwnedDeclarator().getName() : declarator.getName(), this.createParameterList(declarator.getParameters()), this.astFactory.createAbstractDeclaration(this.constt, this.volatil, this.getTypeSpecifier(), declarator.getPointerOperators(), declarator.getArrayModifiers(), null, null), declarator.getExceptionSpecification(), this.inline, this.friend, this.staticc, this.startingOffset, declarator.getNameStartOffset(), declarator.getNameEndOffset(), this.templateDeclaration, declarator.isConst(), declarator.isVolatile(), this.virtual, this.explicit, declarator.isPureVirtual(), ((IASTClassSpecifier)this.scope).getCurrentVisibilityMode(), declarator.getConstructorMemberInitializers(), declarator.hasFunctionBody(), declarator.hasFunctionTryBlock());
        }
        catch (ASTSemanticException e) {
            throw e;
        }
        catch (Exception exception) {
            throw new ASTSemanticException();
        }
    }

    private IASTFunction createFunctionASTNode(Declarator declarator, boolean nested) throws ASTSemanticException {
        try {
            return this.astFactory.createFunction(this.scope, nested ? declarator.getOwnedDeclarator().getNameDuple() : declarator.getNameDuple(), this.createParameterList(declarator.getParameters()), this.astFactory.createAbstractDeclaration(this.constt, this.volatil, this.getTypeSpecifier(), declarator.getPointerOperators(), declarator.getArrayModifiers(), null, null), declarator.getExceptionSpecification(), this.inline, this.friend, this.staticc, this.startingOffset, declarator.getNameStartOffset(), declarator.getNameEndOffset(), this.templateDeclaration, declarator.isConst(), declarator.isVolatile(), this.virtual, this.explicit, declarator.isPureVirtual(), declarator.getConstructorMemberInitializers(), declarator.hasFunctionBody(), declarator.hasFunctionTryBlock());
        }
        catch (ASTSemanticException e) {
            throw e;
        }
        catch (Exception exception) {
            throw new ASTSemanticException();
        }
    }

    private IASTField createFieldASTNode(Declarator declarator, boolean nested) throws ASTSemanticException {
        try {
            return this.astFactory.createField(this.scope, nested ? declarator.getOwnedDeclarator().getName() : declarator.getName(), this.auto, declarator.getInitializerClause(), declarator.getBitFieldExpression(), this.astFactory.createAbstractDeclaration(this.constt, this.volatil, this.getTypeSpecifier(), declarator.getPointerOperators(), declarator.getArrayModifiers(), null, null), this.mutable, this.extern, this.register, this.staticc, this.startingOffset, declarator.getNameStartOffset(), declarator.getNameEndOffset(), declarator.getConstructorExpression(), ((IASTClassSpecifier)this.scope).getCurrentVisibilityMode());
        }
        catch (ASTSemanticException e) {
            throw e;
        }
        catch (Exception exception) {
            throw new ASTSemanticException();
        }
    }

    private List createParameterList(List currentParameters) throws ASTSemanticException {
        ArrayList<IASTParameterDeclaration> result = new ArrayList<IASTParameterDeclaration>();
        Iterator i = currentParameters.iterator();
        while (i.hasNext()) {
            DeclarationWrapper wrapper = (DeclarationWrapper)i.next();
            Iterator j = wrapper.getDeclarators();
            while (j.hasNext()) {
                Declarator declarator = (Declarator)j.next();
                try {
                    result.add(this.astFactory.createParameterDeclaration(wrapper.isConst(), wrapper.isVolatile(), wrapper.getTypeSpecifier(), declarator.getPointerOperators(), declarator.getArrayModifiers(), null, null, declarator.getName() == null ? "" : declarator.getName(), declarator.getInitializerClause(), wrapper.getStartingOffset(), declarator.getNameStartOffset(), declarator.getNameEndOffset(), wrapper.getEndOffset()));
                }
                catch (Exception exception) {
                    throw new ASTSemanticException();
                }
            }
        }
        return result;
    }

    private IASTVariable createVariableASTNode(Declarator declarator, boolean nested) throws ASTSemanticException {
        try {
            return this.astFactory.createVariable(this.scope, nested ? declarator.getOwnedDeclarator().getName() : declarator.getName(), this.isAuto(), declarator.getInitializerClause(), declarator.getBitFieldExpression(), this.astFactory.createAbstractDeclaration(this.constt, this.volatil, this.getTypeSpecifier(), declarator.getPointerOperators(), declarator.getArrayModifiers(), null, null), this.mutable, this.extern, this.register, this.staticc, this.getStartingOffset(), declarator.getNameStartOffset(), declarator.getNameEndOffset(), declarator.getConstructorExpression());
        }
        catch (ASTSemanticException e) {
            throw e;
        }
        catch (Exception exception) {
            throw new ASTSemanticException();
        }
    }

    public DeclarationWrapper getDeclarationWrapper() {
        return this;
    }

    public boolean isUnsigned() {
        return this.isUnsigned;
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public boolean isShort() {
        return this.isShort;
    }

    public boolean isLong() {
        return this.isLong;
    }

    public void setLong(boolean b) {
        this.isLong = b;
    }

    public void setShort(boolean b) {
        this.isShort = b;
    }

    public void setSigned(boolean b) {
        this.isSigned = b;
    }

    public void setUnsigned(boolean b) {
        this.isUnsigned = b;
    }

    public IASTSimpleTypeSpecifier.Type getSimpleType() {
        return this.simpleType;
    }

    public void setSimpleType(IASTSimpleTypeSpecifier.Type type) {
        this.simpleType = type;
    }

    public void setTypeName(ITokenDuple duple) {
        this.name = duple;
    }

    public ITokenDuple getName() {
        return this.name;
    }

    public void setName(ITokenDuple duple) {
        this.name = duple;
    }

    public IASTTemplate getOwnerTemplate() {
        return this.templateDeclaration;
    }

    public void setEndingOffset(int i) {
        this.endOffset = i;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public void setRestrict(boolean b) {
        this.restrict = b;
    }

    public boolean isRestrict() {
        return this.restrict;
    }

    public void setImaginary(boolean b) {
        this.imaginary = b;
    }

    public boolean isComplex() {
        return this.complex;
    }

    public boolean isImaginary() {
        return this.imaginary;
    }

    public void setComplex(boolean b) {
        this.complex = b;
    }
}

