/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.cdt.core.parser.ILineOffsetReconciler;
import org.eclipse.cdt.core.parser.IOffsetDuple;
import org.eclipse.cdt.internal.core.parser.OffsetDuple;

public class LineOffsetReconciler
implements ILineOffsetReconciler {
    private Reader ourReader;
    int currentOffset = 0;

    public LineOffsetReconciler(Reader input) {
        this.ourReader = input;
    }

    public int getLineNumberForOffset(int offset) {
        if (offset < this.currentOffset) {
            this.resetReader();
        }
        int lineNumber = 1;
        int i = this.currentOffset;
        while (i < offset) {
            int c = this.getChar();
            if (c == -1) {
                return -1;
            }
            if (c == 10) {
                ++lineNumber;
            }
            ++i;
        }
        return lineNumber;
    }

    private int getChar() {
        int c;
        try {
            c = this.ourReader.read();
            ++this.currentOffset;
        }
        catch (IOException iOException) {
            return -1;
        }
        return c;
    }

    private void resetReader() {
        try {
            this.ourReader.reset();
            this.currentOffset = 0;
        }
        catch (IOException iOException) {
            throw new Error("Could not reset Reader");
        }
    }

    public IOffsetDuple getOffsetRangeForLineNumber(int LineNumber) {
        int c;
        int lineNumber = 1;
        int floor = -1;
        int ceiling = -1;
        int offset = 0;
        while (lineNumber != LineNumber) {
            c = this.getChar();
            ++offset;
            if (c != 10) continue;
            ++lineNumber;
        }
        floor = offset;
        while (lineNumber == LineNumber) {
            c = this.getChar();
            ++offset;
            if (c != 10) continue;
            ++lineNumber;
        }
        ceiling = offset;
        return new OffsetDuple(floor, ceiling);
    }
}

